/*
 * Decompiled with CFR 0.152.
 */
package com.codelibs.systrace.retrace;

import com.codelibs.systrace.Log;
import com.codelibs.systrace.retrace.MappingProcessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;

public class MappingReader {
    private static final String TAG = "MappingReader";
    private static final String SPLIT = ":";
    private static final String SPACE = " ";
    private static final String ARROW = "->";
    private static final String LEFT_PUNC = "(";
    private static final String RIGHT_PUNC = ")";
    private static final String DOT = ".";
    private final File proguardMappingFile;

    public MappingReader(File proguardMappingFile) {
        this.proguardMappingFile = proguardMappingFile;
    }

    public void read(MappingProcessor mappingProcessor) throws IOException {
        LineNumberReader reader = new LineNumberReader(new BufferedReader(new FileReader(this.proguardMappingFile)));
        try {
            String line;
            String className = null;
            while ((line = reader.readLine()) != null) {
                if (!(line = line.trim()).startsWith("#")) {
                    if (line.endsWith(SPLIT)) {
                        className = this.parseClassMapping(line, mappingProcessor);
                        continue;
                    }
                    if (className == null) continue;
                    this.parseClassMemberMapping(className, line, mappingProcessor);
                    continue;
                }
                Log.i(TAG, "comment:# %s", line);
            }
        }
        catch (IOException err) {
            throw new IOException("Can't read mapping file", err);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String parseClassMapping(String line, MappingProcessor mappingProcessor) {
        String newClassName;
        int leftIndex = line.indexOf(ARROW);
        if (leftIndex < 0) {
            return null;
        }
        int offset = 2;
        int rightIndex = line.indexOf(SPLIT, leftIndex + offset);
        if (rightIndex < 0) {
            return null;
        }
        String className = line.substring(0, leftIndex).trim();
        boolean ret = mappingProcessor.processClassMapping(className, newClassName = line.substring(leftIndex + offset, rightIndex).trim());
        return ret ? className : null;
    }

    private void parseClassMemberMapping(String className, String line, MappingProcessor mappingProcessor) {
        int leftIndex4;
        int leftIndex1 = line.indexOf(SPLIT);
        int leftIndex2 = leftIndex1 < 0 ? -1 : line.indexOf(SPLIT, leftIndex1 + 1);
        int spaceIndex = line.indexOf(SPACE, leftIndex2 + 2);
        int argIndex1 = line.indexOf(LEFT_PUNC, spaceIndex + 1);
        int argIndex2 = argIndex1 < 0 ? -1 : line.indexOf(RIGHT_PUNC, argIndex1 + 1);
        int leftIndex3 = argIndex2 < 0 ? -1 : line.indexOf(SPLIT, argIndex2 + 1);
        int n = leftIndex4 = leftIndex3 < 0 ? -1 : line.indexOf(SPLIT, leftIndex3 + 1);
        int rightIndex = line.indexOf(ARROW, (leftIndex4 >= 0 ? leftIndex4 : (leftIndex3 >= 0 ? leftIndex3 : (argIndex2 >= 0 ? argIndex2 : spaceIndex))) + 1);
        if (spaceIndex < 0 || rightIndex < 0) {
            return;
        }
        String type = line.substring(leftIndex2 + 1, spaceIndex).trim();
        String name = line.substring(spaceIndex + 1, argIndex1 >= 0 ? argIndex1 : rightIndex).trim();
        String newName = line.substring(rightIndex + 2).trim();
        String newClassName = className;
        int dotIndex = name.lastIndexOf(DOT);
        if (dotIndex >= 0) {
            className = name.substring(0, dotIndex);
            name = name.substring(dotIndex + 1);
        }
        if (type.length() > 0 && name.length() > 0 && newName.length() > 0 && argIndex2 >= 0) {
            String arguments = line.substring(argIndex1 + 1, argIndex2).trim();
            mappingProcessor.processMethodMapping(className, type, name, arguments, newClassName, newName);
        }
    }
}

