/*
 * Decompiled with CFR 0.152.
 */
package com.codelibs.systrace.retrace;

import com.codelibs.systrace.retrace.MappingProcessor;
import com.codelibs.systrace.retrace.MethodInfo;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Type;

public class MappingCollector
implements MappingProcessor {
    private static final String TAG = "MappingCollector";
    private static final int DEFAULT_CAPACITY = 2000;
    public HashMap<String, String> mObfuscatedRawClassMap = new HashMap(2000);
    public HashMap<String, String> mRawObfuscatedClassMap = new HashMap(2000);
    private final Map<String, Map<String, Set<MethodInfo>>> mObfuscatedClassMethodMap = new HashMap<String, Map<String, Set<MethodInfo>>>();
    private final Map<String, Map<String, Set<MethodInfo>>> mOriginalClassMethodMap = new HashMap<String, Map<String, Set<MethodInfo>>>();

    @Override
    public boolean processClassMapping(String className, String newClassName) {
        this.mObfuscatedRawClassMap.put(newClassName, className);
        this.mRawObfuscatedClassMap.put(className, newClassName);
        return true;
    }

    @Override
    public void processMethodMapping(String className, String methodReturnType, String methodName, String methodArguments, String newClassName, String newMethodName) {
        Set<MethodInfo> methodSet2;
        Set<MethodInfo> methodSet;
        newClassName = this.mRawObfuscatedClassMap.get(className);
        Map<String, Set<MethodInfo>> methodMap = this.mObfuscatedClassMethodMap.get(newClassName);
        if (methodMap == null) {
            methodMap = new HashMap<String, Set<MethodInfo>>();
            this.mObfuscatedClassMethodMap.put(newClassName, methodMap);
        }
        if ((methodSet = methodMap.get(newMethodName)) == null) {
            methodSet = new LinkedHashSet<MethodInfo>();
            methodMap.put(newMethodName, methodSet);
        }
        methodSet.add(new MethodInfo(className, methodReturnType, methodName, methodArguments));
        Map<String, Set<MethodInfo>> methodMap2 = this.mOriginalClassMethodMap.get(className);
        if (methodMap2 == null) {
            methodMap2 = new HashMap<String, Set<MethodInfo>>();
            this.mOriginalClassMethodMap.put(className, methodMap2);
        }
        if ((methodSet2 = methodMap2.get(methodName)) == null) {
            methodSet2 = new LinkedHashSet<MethodInfo>();
            methodMap2.put(methodName, methodSet2);
        }
        methodSet2.add(new MethodInfo(newClassName, methodReturnType, newMethodName, methodArguments));
    }

    public String originalClassName(String proguardClassName, String defaultClassName) {
        if (this.mObfuscatedRawClassMap.containsKey(proguardClassName)) {
            return this.mObfuscatedRawClassMap.get(proguardClassName);
        }
        return defaultClassName;
    }

    public String proguardClassName(String originalClassName, String defaultClassName) {
        if (this.mRawObfuscatedClassMap.containsKey(originalClassName)) {
            return this.mRawObfuscatedClassMap.get(originalClassName);
        }
        return defaultClassName;
    }

    public MethodInfo originalMethodInfo(String obfuscatedClassName, String obfuscatedMethodName, String obfuscatedMethodDesc) {
        Set<MethodInfo> methodSet;
        DescInfo descInfo = this.parseMethodDesc(obfuscatedMethodDesc, false);
        Map<String, Set<MethodInfo>> methodMap = this.mObfuscatedClassMethodMap.get(obfuscatedClassName);
        if (methodMap != null && (methodSet = methodMap.get(obfuscatedMethodName)) != null) {
            for (MethodInfo methodInfo : methodSet) {
                if (!methodInfo.matches(descInfo.returnType, descInfo.arguments)) continue;
                MethodInfo newMethodInfo = new MethodInfo(methodInfo);
                newMethodInfo.setDesc(descInfo.desc);
                return newMethodInfo;
            }
        }
        MethodInfo defaultMethodInfo = MethodInfo.deFault();
        defaultMethodInfo.setDesc(descInfo.desc);
        defaultMethodInfo.setOriginalName(obfuscatedMethodName);
        return defaultMethodInfo;
    }

    public MethodInfo obfuscatedMethodInfo(String originalClassName, String originalMethodName, String originalMethodDesc) {
        Set<MethodInfo> methodSet;
        DescInfo descInfo = this.parseMethodDesc(originalMethodDesc, true);
        Map<String, Set<MethodInfo>> methodMap = this.mOriginalClassMethodMap.get(originalClassName);
        if (methodMap != null && null != (methodSet = methodMap.get(originalMethodName))) {
            for (MethodInfo methodInfo : methodSet) {
                MethodInfo newMethodInfo = new MethodInfo(methodInfo);
                this.obfuscatedMethodInfo(newMethodInfo);
                if (!newMethodInfo.matches(descInfo.returnType, descInfo.arguments)) continue;
                newMethodInfo.setDesc(descInfo.desc);
                return newMethodInfo;
            }
        }
        MethodInfo defaultMethodInfo = MethodInfo.deFault();
        defaultMethodInfo.setDesc(descInfo.desc);
        defaultMethodInfo.setOriginalName(originalMethodName);
        return defaultMethodInfo;
    }

    private void obfuscatedMethodInfo(MethodInfo methodInfo) {
        String methodReturnType;
        String key;
        String methodArguments = methodInfo.getOriginalArguments();
        String[] args = methodArguments.split(",");
        StringBuffer stringBuffer = new StringBuffer();
        for (String str : args) {
            String key2 = str.replace("[", "").replace("]", "");
            if (this.mRawObfuscatedClassMap.containsKey(key2)) {
                stringBuffer.append(str.replace(key2, this.mRawObfuscatedClassMap.get(key2)));
            } else {
                stringBuffer.append(str);
            }
            stringBuffer.append(',');
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        if (this.mRawObfuscatedClassMap.containsKey(key = (methodReturnType = methodInfo.getOriginalType()).replace("[", "").replace("]", ""))) {
            methodReturnType = methodReturnType.replace(key, this.mRawObfuscatedClassMap.get(key));
        }
        methodInfo.setOriginalArguments(stringBuffer.toString());
        methodInfo.setOriginalType(methodReturnType);
    }

    private DescInfo parseMethodDesc(String desc, boolean isRawToObfuscated) {
        Type returnObj;
        DescInfo descInfo = new DescInfo();
        Type[] argsObj = Type.getArgumentTypes((String)desc);
        StringBuffer argumentsBuffer = new StringBuffer();
        StringBuffer descBuffer = new StringBuffer();
        descBuffer.append('(');
        for (Type type : argsObj) {
            String key = type.getClassName().replace("[", "").replace("]", "");
            if (isRawToObfuscated) {
                if (this.mRawObfuscatedClassMap.containsKey(key)) {
                    argumentsBuffer.append(type.getClassName().replace(key, this.mRawObfuscatedClassMap.get(key)));
                    descBuffer.append(type.toString().replace(key, this.mRawObfuscatedClassMap.get(key)));
                } else {
                    argumentsBuffer.append(type.getClassName());
                    descBuffer.append(type.toString());
                }
            } else if (this.mObfuscatedRawClassMap.containsKey(key)) {
                argumentsBuffer.append(type.getClassName().replace(key, this.mObfuscatedRawClassMap.get(key)));
                descBuffer.append(type.toString().replace(key, this.mObfuscatedRawClassMap.get(key)));
            } else {
                argumentsBuffer.append(type.getClassName());
                descBuffer.append(type.toString());
            }
            argumentsBuffer.append(',');
        }
        descBuffer.append(')');
        try {
            returnObj = Type.getReturnType((String)desc);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            returnObj = Type.getReturnType((String)(desc + ";"));
        }
        if (isRawToObfuscated) {
            String key = returnObj.getClassName().replace("[", "").replace("]", "");
            if (this.mRawObfuscatedClassMap.containsKey(key)) {
                descInfo.setReturnType(returnObj.getClassName().replace(key, this.mRawObfuscatedClassMap.get(key)));
                descBuffer.append(returnObj.toString().replace(key, this.mRawObfuscatedClassMap.get(key)));
            } else {
                descInfo.setReturnType(returnObj.getClassName());
                descBuffer.append(returnObj.toString());
            }
        } else {
            String key = returnObj.getClassName().replace("[", "").replace("]", "");
            if (this.mObfuscatedRawClassMap.containsKey(key)) {
                descInfo.setReturnType(returnObj.getClassName().replace(key, this.mObfuscatedRawClassMap.get(key)));
                descBuffer.append(returnObj.toString().replace(key, this.mObfuscatedRawClassMap.get(key)));
            } else {
                descInfo.setReturnType(returnObj.getClassName());
                descBuffer.append(returnObj.toString());
            }
        }
        if (argumentsBuffer.length() > 0) {
            argumentsBuffer.deleteCharAt(argumentsBuffer.length() - 1);
        }
        descInfo.setArguments(argumentsBuffer.toString());
        descInfo.setDesc(descBuffer.toString());
        return descInfo;
    }

    private static class DescInfo {
        private String desc;
        private String arguments;
        private String returnType;

        private DescInfo() {
        }

        public void setArguments(String arguments) {
            this.arguments = arguments;
        }

        public void setReturnType(String returnType) {
            this.returnType = returnType;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
}

