/*
 * Decompiled with CFR 0.152.
 */
package com.codelibs.systrace;

import com.codelibs.systrace.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class Util {
    private static final String TAG = "Util";
    public static final int BUFFER_SIZE = 16384;

    private Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addZipEntry(ZipOutputStream zipOutputStream, ZipEntry zipEntry, InputStream inputStream) throws Exception {
        try {
            zipOutputStream.putNextEntry(zipEntry);
            byte[] buffer = new byte[16384];
            int length = -1;
            while ((length = inputStream.read(buffer, 0, buffer.length)) != -1) {
                zipOutputStream.write(buffer, 0, length);
                zipOutputStream.flush();
            }
        }
        catch (ZipException e) {
            Log.e(TAG, "addZipEntry err!", new Object[0]);
        }
        finally {
            Util.closeQuietly(inputStream);
            zipOutputStream.closeEntry();
        }
    }

    public static boolean isNullOrNil(String str) {
        return str == null || str.isEmpty();
    }

    public static Field getDeclaredFieldRecursive(Object clazz, String fieldName) throws NoSuchFieldException, ClassNotFoundException {
        Class realClazz = null;
        if (clazz instanceof String) {
            realClazz = Class.forName((String)clazz);
        } else if (clazz instanceof Class) {
            realClazz = (Class)clazz;
        } else {
            throw new IllegalArgumentException("Illegal clazz type: " + clazz.getClass());
        }
        Class currClazz = realClazz;
        while (true) {
            try {
                Field field = currClazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                if (currClazz.equals(Object.class)) {
                    throw e;
                }
                currClazz = currClazz.getSuperclass();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRealZipOrJar(File input) {
        boolean bl;
        ZipFile zf = null;
        try {
            zf = new ZipFile(input);
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                Util.closeQuietly(zf);
                throw throwable;
            }
            Util.closeQuietly(zf);
            return bl2;
        }
        Util.closeQuietly(zf);
        return bl;
    }

    public static void closeQuietly(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof Closeable) {
            try {
                ((Closeable)obj).close();
            }
            catch (Throwable throwable) {}
        } else if (obj instanceof AutoCloseable) {
            try {
                ((AutoCloseable)obj).close();
            }
            catch (Throwable throwable) {}
        } else if (obj instanceof ZipFile) {
            try {
                ((ZipFile)obj).close();
            }
            catch (Throwable throwable) {}
        } else {
            throw new IllegalArgumentException("obj " + obj + " is not closeable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String readFileAsString(String filePath) {
        StringBuffer fileData;
        block11: {
            fileData = new StringBuffer();
            InputStreamReader fileReader = null;
            FileInputStream inputStream = null;
            inputStream = new FileInputStream(filePath);
            fileReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            char[] buf = new char[16384];
            int numRead = 0;
            while ((numRead = fileReader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
            }
            try {
                Util.closeQuietly(fileReader);
                Util.closeQuietly(inputStream);
            }
            catch (Exception e) {
                Log.e(TAG, "file op readFileAsString close e type:%s, e msg:%s, filePath:%s", e.getClass().getSimpleName(), e.getMessage(), filePath);
            }
            break block11;
            catch (Exception e) {
                try {
                    Log.e(TAG, "file op readFileAsString e type:%s, e msg:%s, filePath:%s", e.getClass().getSimpleName(), e.getMessage(), filePath);
                }
                catch (Throwable throwable) {
                    try {
                        Util.closeQuietly(fileReader);
                        Util.closeQuietly(inputStream);
                    }
                    catch (Exception e2) {
                        Log.e(TAG, "file op readFileAsString close e type:%s, e msg:%s, filePath:%s", e2.getClass().getSimpleName(), e2.getMessage(), filePath);
                    }
                    throw throwable;
                }
                try {
                    Util.closeQuietly(fileReader);
                    Util.closeQuietly(inputStream);
                }
                catch (Exception e3) {
                    Log.e(TAG, "file op readFileAsString close e type:%s, e msg:%s, filePath:%s", e3.getClass().getSimpleName(), e3.getMessage(), filePath);
                }
            }
        }
        return fileData.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileUsingStream(File source, File dest) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        File parent = dest.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest, false);
            byte[] buffer = new byte[16384];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        catch (Throwable throwable) {
            Util.closeQuietly(is);
            Util.closeQuietly(os);
            throw throwable;
        }
        Util.closeQuietly(is);
        Util.closeQuietly(os);
    }
}

