/*
 * Decompiled with CFR 0.152.
 */
package com.codelibs.systrace;

import com.codelibs.systrace.Log;
import com.codelibs.systrace.TraceBuildConstants;
import com.codelibs.systrace.Util;
import com.codelibs.systrace.retrace.MappingCollector;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;

public class TraceBuildConfig {
    private static final String TAG = "Matrix.TraceBuildConfig";
    private final String mPackageName;
    private final String mMappingPath;
    private final String mBaseMethodMap;
    private final String mMethodMapFile;
    private final String mIgnoreMethodMapFile;
    private final String mBlackListDir;
    private final HashSet<String> mBlackClassMap;
    private final HashSet<String> mBlackPackageMap;

    public TraceBuildConfig(String packageName, String mappingPath, String baseMethodMap, String methodMapFile, String ignoreMethodMapFile, String blackListFile) {
        this.mPackageName = packageName;
        this.mMappingPath = mappingPath;
        this.mBaseMethodMap = baseMethodMap;
        this.mMethodMapFile = methodMapFile;
        this.mIgnoreMethodMapFile = ignoreMethodMapFile;
        this.mBlackListDir = blackListFile;
        this.mBlackClassMap = new HashSet();
        this.mBlackPackageMap = new HashSet();
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getMappingPath() {
        return this.mMappingPath;
    }

    public String getBaseMethodMap() {
        return this.mBaseMethodMap;
    }

    public String getMethodMapFile() {
        return this.mMethodMapFile;
    }

    public String getBlackListFile() {
        return this.mBlackListDir;
    }

    public String getIgnoreMethodMapFile() {
        return this.mIgnoreMethodMapFile;
    }

    public String toString() {
        return "\nPackageName:" + this.mPackageName + "\nMappingPath:" + this.mMappingPath + "\nMethodMapFile:" + this.mMethodMapFile;
    }

    public boolean isNeedTraceClass(String fileName) {
        boolean isNeed = true;
        if (fileName.endsWith(".class")) {
            for (String unTraceCls : TraceBuildConstants.UN_TRACE_CLASS) {
                if (!fileName.contains(unTraceCls)) continue;
                isNeed = false;
                break;
            }
        } else {
            isNeed = false;
        }
        return isNeed;
    }

    public boolean isNeedTrace(String clsName, MappingCollector mappingCollector) {
        boolean isNeed = true;
        if (this.mBlackClassMap.contains(clsName)) {
            isNeed = false;
        } else {
            if (null != mappingCollector) {
                clsName = mappingCollector.originalClassName(clsName, clsName);
            }
            for (String packageName : this.mBlackPackageMap) {
                if (!clsName.startsWith(packageName.replaceAll("/", "."))) continue;
                isNeed = false;
                break;
            }
        }
        return isNeed;
    }

    public boolean isMethodBeatClass(String className, HashMap<String, String> mCollectedClassExtendMap) {
        boolean isApplication = (className = className.replace(".", "/")).equals("com/sample/systrace/TraceTag");
        if (isApplication) {
            return true;
        }
        if (mCollectedClassExtendMap.containsKey(className)) {
            return mCollectedClassExtendMap.get(className).equals("com/sample/systrace/TraceTag");
        }
        return false;
    }

    public void parseBlackFile(MappingCollector processor) {
        String blackStr;
        String[] blackArray;
        File blackConfigFile = new File(this.mBlackListDir);
        if (!blackConfigFile.exists()) {
            Log.w(TAG, "black config file not exist %s", blackConfigFile.getAbsoluteFile());
        }
        if ((blackArray = (blackStr = "[package]\n-keepclass com/sample/systrace/TraceTag\n" + Util.readFileAsString(blackConfigFile.getAbsolutePath())).split("\n")) != null) {
            for (String black : blackArray) {
                if ((black = black.trim().replace("/", ".")).length() == 0) continue;
                if (black.startsWith("#")) {
                    Log.i(TAG, "[parseBlackFile] comment:%s", black);
                    continue;
                }
                if (black.startsWith("[")) continue;
                if (black.startsWith("-keepclass ")) {
                    black = black.replace("-keepclass ", "");
                    this.mBlackClassMap.add(processor.proguardClassName(black, black));
                    continue;
                }
                if (!black.startsWith("-keeppackage ")) continue;
                black = black.replace("-keeppackage ", "");
                this.mBlackPackageMap.add(black);
            }
        }
        Log.i(TAG, "[parseBlackFile] BlackClassMap size:%s BlackPrefixMap size:%s", this.mBlackClassMap.size(), this.mBlackPackageMap.size());
    }

    public static class Builder {
        public String mPackageName;
        public String mMappingPath;
        public String mBaseMethodMap;
        public String mMethodMapFile;
        public String mIgnoreMethodMapFile;
        public String mBlackListFile;

        public Builder setPackageName(String packageName) {
            this.mPackageName = packageName;
            return this;
        }

        public Builder setMappingPath(String mappingPath) {
            this.mMappingPath = mappingPath;
            return this;
        }

        public Builder setBaseMethodMap(String baseMethodMap) {
            this.mBaseMethodMap = baseMethodMap;
            return this;
        }

        public Builder setMethodMapDir(String methodMapDir) {
            this.mMethodMapFile = methodMapDir;
            return this;
        }

        public Builder setIgnoreMethodMapDir(String methodMapDir) {
            this.mIgnoreMethodMapFile = methodMapDir;
            return this;
        }

        public Builder setBlackListFile(String blackListFile) {
            this.mBlackListFile = blackListFile;
            return this;
        }

        public TraceBuildConfig build() {
            return new TraceBuildConfig(this.mPackageName, this.mMappingPath, this.mBaseMethodMap, this.mMethodMapFile, this.mIgnoreMethodMapFile, this.mBlackListFile);
        }
    }
}

