/*
 * Decompiled with CFR 0.152.
 */
package com.codelibs.systrace;

import com.codelibs.systrace.Log;
import com.codelibs.systrace.TraceBuildConfig;
import com.codelibs.systrace.Util;
import com.codelibs.systrace.item.TraceMethod;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AdviceAdapter;

public class MethodTracer {
    private static final String TAG = "Matrix.MethodTracer";
    private static AtomicInteger traceMethodCount = new AtomicInteger();
    private final TraceBuildConfig mTraceConfig;
    private final HashMap<String, TraceMethod> mCollectedMethodMap;
    private final HashMap<String, String> mCollectedClassExtendMap;

    MethodTracer(TraceBuildConfig config, HashMap<String, TraceMethod> collectedMap, HashMap<String, String> collectedClassExtendMap) {
        this.mTraceConfig = config;
        this.mCollectedClassExtendMap = collectedClassExtendMap;
        this.mCollectedMethodMap = collectedMap;
    }

    public void trace(Map<File, File> srcFolderList, Map<File, File> dependencyJarList) {
        this.traceMethodFromSrc(srcFolderList);
        this.traceMethodFromJar(dependencyJarList);
    }

    private void traceMethodFromSrc(Map<File, File> srcMap) {
        if (null != srcMap) {
            for (Map.Entry<File, File> entry : srcMap.entrySet()) {
                this.innerTraceMethodFromSrc(entry.getKey(), entry.getValue());
            }
        }
    }

    private void traceMethodFromJar(Map<File, File> dependencyMap) {
        if (null != dependencyMap) {
            for (Map.Entry<File, File> entry : dependencyMap.entrySet()) {
                this.innerTraceMethodFromJar(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerTraceMethodFromSrc(File input, File output) {
        ArrayList<File> classFileList = new ArrayList<File>();
        if (input.isDirectory()) {
            this.listClassFiles(classFileList, input);
        } else {
            classFileList.add(input);
        }
        for (File classFile : classFileList) {
            InputStream is = null;
            FileOutputStream os = null;
            try {
                String changedFileInputFullPath = classFile.getAbsolutePath();
                File changedFileOutput = new File(changedFileInputFullPath.replace(input.getAbsolutePath(), output.getAbsolutePath()));
                if (!changedFileOutput.exists()) {
                    changedFileOutput.getParentFile().mkdirs();
                }
                changedFileOutput.createNewFile();
                if (this.mTraceConfig.isNeedTraceClass(classFile.getName())) {
                    is = new FileInputStream(classFile);
                    ClassReader classReader = new ClassReader(is);
                    ClassWriter classWriter = new ClassWriter(1);
                    TraceClassAdapter classVisitor = new TraceClassAdapter(327680, (ClassVisitor)classWriter);
                    classReader.accept((ClassVisitor)classVisitor, 8);
                    is.close();
                    os = output.isDirectory() ? new FileOutputStream(changedFileOutput) : new FileOutputStream(output);
                    os.write(classWriter.toByteArray());
                    os.close();
                    continue;
                }
                Util.copyFileUsingStream(classFile, changedFileOutput);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    is.close();
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerTraceMethodFromJar(File input, File output) {
        ZipOutputStream zipOutputStream = null;
        ZipFile zipFile = null;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(output));
            zipFile = new ZipFile(input);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                InputStream inputStream;
                ZipEntry zipEntry = enumeration.nextElement();
                String zipEntryName = zipEntry.getName();
                if (this.mTraceConfig.isNeedTraceClass(zipEntryName)) {
                    inputStream = zipFile.getInputStream(zipEntry);
                    ClassReader classReader = new ClassReader(inputStream);
                    ClassWriter classWriter = new ClassWriter(1);
                    TraceClassAdapter classVisitor = new TraceClassAdapter(327680, (ClassVisitor)classWriter);
                    classReader.accept((ClassVisitor)classVisitor, 8);
                    byte[] data = classWriter.toByteArray();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
                    ZipEntry newZipEntry = new ZipEntry(zipEntryName);
                    Util.addZipEntry(zipOutputStream, newZipEntry, byteArrayInputStream);
                    continue;
                }
                inputStream = zipFile.getInputStream(zipEntry);
                ZipEntry newZipEntry = new ZipEntry(zipEntryName);
                Util.addZipEntry(zipOutputStream, newZipEntry, inputStream);
            }
        }
        catch (Exception e) {
            Log.e(TAG, "[traceMethodFromJar] err! %s", output.getAbsolutePath());
        }
        finally {
            try {
                if (zipOutputStream != null) {
                    zipOutputStream.finish();
                    zipOutputStream.flush();
                    zipOutputStream.close();
                }
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception e) {
                Log.e(TAG, "close stream err!", new Object[0]);
            }
        }
    }

    private void listClassFiles(ArrayList<File> classFiles, File folder) {
        File[] files = folder.listFiles();
        if (null == files) {
            Log.e(TAG, "[listClassFiles] files is null! %s", folder.getAbsolutePath());
            return;
        }
        for (File file : files) {
            if (file == null) continue;
            if (file.isDirectory()) {
                this.listClassFiles(classFiles, file);
                continue;
            }
            if (null == file || !file.isFile()) continue;
            classFiles.add(file);
        }
    }

    private class TraceMethodAdapter
    extends AdviceAdapter {
        private final String methodName;
        private final String name;
        private final String className;
        private final boolean isMethodBeatClass;

        protected TraceMethodAdapter(int api, MethodVisitor mv, int access, String name, String desc, String className, boolean isMethodBeatClass) {
            super(api, mv, access, name, desc);
            TraceMethod traceMethod = TraceMethod.create(0, access, className, name, desc);
            this.methodName = traceMethod.getMethodName();
            this.isMethodBeatClass = isMethodBeatClass;
            this.className = className;
            this.name = name;
        }

        protected void onMethodEnter() {
            TraceMethod traceMethod = (TraceMethod)MethodTracer.this.mCollectedMethodMap.get(this.methodName);
            if (traceMethod != null) {
                int parmIndex;
                traceMethodCount.incrementAndGet();
                String sectionName = this.methodName;
                int length = sectionName.length();
                if (length > 127 && (length = (sectionName = sectionName.substring(0, parmIndex = sectionName.indexOf(40))).length()) > 127) {
                    sectionName = sectionName.substring(length - 127);
                }
                this.mv.visitLdcInsn((Object)sectionName);
                this.mv.visitMethodInsn(184, "com/sample/systrace/TraceTag", "i", "(Ljava/lang/String;)V", false);
            }
        }

        protected void onMethodExit(int opcode) {
            TraceMethod traceMethod = (TraceMethod)MethodTracer.this.mCollectedMethodMap.get(this.methodName);
            if (traceMethod != null) {
                traceMethodCount.incrementAndGet();
                this.mv.visitMethodInsn(184, "com/sample/systrace/TraceTag", "o", "()V", false);
            }
        }
    }

    private class TraceClassAdapter
    extends ClassVisitor {
        private String className;
        private boolean isABSClass;
        private boolean isMethodBeatClass;

        TraceClassAdapter(int i, ClassVisitor classVisitor) {
            super(i, classVisitor);
            this.isABSClass = false;
            this.isMethodBeatClass = false;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.className = name;
            if ((access & 0x400) > 0 || (access & 0x200) > 0) {
                this.isABSClass = true;
            }
            if (MethodTracer.this.mTraceConfig.isMethodBeatClass(this.className, MethodTracer.this.mCollectedClassExtendMap)) {
                this.isMethodBeatClass = true;
            }
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.isABSClass) {
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
            MethodVisitor methodVisitor = this.cv.visitMethod(access, name, desc, signature, exceptions);
            return new TraceMethodAdapter(this.api, methodVisitor, access, name, desc, this.className, this.isMethodBeatClass);
        }

        public void visitEnd() {
            super.visitEnd();
        }
    }
}

