/*
 * Decompiled with CFR 0.152.
 */
package com.codelibs.systrace;

import com.codelibs.systrace.Log;
import com.codelibs.systrace.TraceBuildConfig;
import com.codelibs.systrace.Util;
import com.codelibs.systrace.item.TraceMethod;
import com.codelibs.systrace.retrace.MappingCollector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class MethodCollector {
    private static final String TAG = "Matrix.MethodCollector";
    private final HashMap<String, TraceMethod> mCollectedMethodMap;
    private final HashMap<String, TraceMethod> mCollectedIgnoreMethodMap;
    private final HashMap<String, TraceMethod> mCollectedBlackMethodMap;
    private final HashMap<String, String> mCollectedClassExtendMap;
    private final TraceBuildConfig mTraceConfig;
    private final AtomicInteger mMethodId = new AtomicInteger(0);
    private final MappingCollector mMappingCollector;
    private int mIncrementCount;
    private int mIgnoreCount;

    public MethodCollector(TraceBuildConfig config, MappingCollector mappingCollector) {
        this.mCollectedMethodMap = new HashMap();
        this.mCollectedClassExtendMap = new HashMap();
        this.mCollectedIgnoreMethodMap = new HashMap();
        this.mCollectedBlackMethodMap = new HashMap();
        this.mTraceConfig = config;
        this.mMappingCollector = mappingCollector;
    }

    public HashMap<String, String> getCollectedClassExtendMap() {
        return this.mCollectedClassExtendMap;
    }

    public HashMap collect(List<File> srcFolderList, List<File> dependencyJarList) {
        this.mTraceConfig.parseBlackFile(this.mMappingCollector);
        File originMethodMapFile = new File(this.mTraceConfig.getBaseMethodMap());
        this.getMethodFromBaseMethod(originMethodMapFile);
        Log.i(TAG, "[collect] %s method from %s", this.mCollectedMethodMap.size(), this.mTraceConfig.getBaseMethodMap());
        this.retraceMethodMap(this.mMappingCollector, this.mCollectedMethodMap);
        this.collectMethodFromSrc(srcFolderList, true);
        this.collectMethodFromJar(dependencyJarList, true);
        this.collectMethodFromSrc(srcFolderList, false);
        this.collectMethodFromJar(dependencyJarList, false);
        Log.i(TAG, "[collect] incrementCount:%s ignoreMethodCount:%s", this.mIncrementCount, this.mIgnoreCount);
        this.saveCollectedMethod(this.mMappingCollector);
        this.saveIgnoreCollectedMethod(this.mMappingCollector);
        return this.mCollectedMethodMap;
    }

    private void retraceMethodMap(MappingCollector processor, HashMap<String, TraceMethod> methodMap) {
        if (null == processor || null == methodMap) {
            return;
        }
        HashMap<String, TraceMethod> retraceMethodMap = new HashMap<String, TraceMethod>(methodMap.size());
        for (Map.Entry<String, TraceMethod> entry : methodMap.entrySet()) {
            TraceMethod traceMethod = entry.getValue();
            traceMethod.proguard(processor);
            retraceMethodMap.put(traceMethod.getMethodName(), traceMethod);
        }
        methodMap.clear();
        methodMap.putAll(retraceMethodMap);
        retraceMethodMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveIgnoreCollectedMethod(MappingCollector mappingCollector) {
        File methodMapFile = new File(this.mTraceConfig.getIgnoreMethodMapFile());
        if (!methodMapFile.getParentFile().exists()) {
            methodMapFile.getParentFile().mkdirs();
        }
        ArrayList<TraceMethod> ignoreMethodList = new ArrayList<TraceMethod>();
        ignoreMethodList.addAll(this.mCollectedIgnoreMethodMap.values());
        Log.i(TAG, "[saveIgnoreCollectedMethod] size:%s path:%s", this.mCollectedIgnoreMethodMap.size(), methodMapFile.getAbsolutePath());
        ArrayList<TraceMethod> blackMethodList = new ArrayList<TraceMethod>();
        blackMethodList.addAll(this.mCollectedBlackMethodMap.values());
        Log.i(TAG, "[saveIgnoreBlackMethod] size:%s path:%s", this.mCollectedBlackMethodMap.size(), methodMapFile.getAbsolutePath());
        Collections.sort(ignoreMethodList, new Comparator<TraceMethod>(){

            @Override
            public int compare(TraceMethod o1, TraceMethod o2) {
                return o1.className.compareTo(o2.className);
            }
        });
        Collections.sort(blackMethodList, new Comparator<TraceMethod>(){

            @Override
            public int compare(TraceMethod o1, TraceMethod o2) {
                return o1.className.compareTo(o2.className);
            }
        });
        PrintWriter pw = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(methodMapFile, false);
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            pw = new PrintWriter(w);
            pw.println("ignore methods:");
            for (TraceMethod traceMethod : ignoreMethodList) {
                traceMethod.revert(mappingCollector);
                pw.println(traceMethod.toIgnoreString());
            }
            pw.println("");
            pw.println("black methods:");
            for (TraceMethod traceMethod : blackMethodList) {
                traceMethod.revert(mappingCollector);
                pw.println(traceMethod.toIgnoreString());
            }
        }
        catch (Exception e) {
            Log.e(TAG, "write method map Exception:%s", e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCollectedMethod(MappingCollector mappingCollector) {
        File methodMapFile = new File(this.mTraceConfig.getMethodMapFile());
        if (!methodMapFile.getParentFile().exists()) {
            methodMapFile.getParentFile().mkdirs();
        }
        ArrayList<TraceMethod> methodList = new ArrayList<TraceMethod>();
        methodList.addAll(this.mCollectedMethodMap.values());
        Log.i(TAG, "[saveCollectedMethod] size:%s path:%s", this.mCollectedMethodMap.size(), methodMapFile.getAbsolutePath());
        Collections.sort(methodList, new Comparator<TraceMethod>(){

            @Override
            public int compare(TraceMethod o1, TraceMethod o2) {
                return o1.id - o2.id;
            }
        });
        PrintWriter pw = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(methodMapFile, false);
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            pw = new PrintWriter(w);
            for (TraceMethod traceMethod : methodList) {
                traceMethod.revert(mappingCollector);
                pw.println(traceMethod.toString());
            }
        }
        catch (Exception e) {
            Log.e(TAG, "write method map Exception:%s", e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
    }

    private void collectMethodFromSrc(List<File> srcFolderList, boolean isSingle) {
        if (null != srcFolderList) {
            for (File srcFile : srcFolderList) {
                this.innerCollectMethodFromSrc(srcFile, isSingle);
            }
        }
    }

    private void collectMethodFromJar(List<File> dependencyJarList, boolean isSingle) {
        if (null != dependencyJarList) {
            for (File jarFile : dependencyJarList) {
                this.innerCollectMethodFromJar(jarFile, isSingle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMethodFromBaseMethod(File baseMethodFile) {
        if (!baseMethodFile.exists()) {
            Log.w(TAG, "[getMethodFromBaseMethod] not exist!%s", baseMethodFile.getAbsolutePath());
            return;
        }
        try (Scanner fileReader = null;){
            fileReader = new Scanner(baseMethodFile, "UTF-8");
            while (fileReader.hasNext()) {
                String nextLine = fileReader.nextLine();
                if (Util.isNullOrNil(nextLine)) continue;
                if ((nextLine = nextLine.trim()).startsWith("#")) {
                    Log.i("[getMethodFromBaseMethod] comment %s", nextLine, new Object[0]);
                    continue;
                }
                String[] fields = nextLine.split(",");
                TraceMethod traceMethod = new TraceMethod();
                traceMethod.id = Integer.parseInt(fields[0]);
                traceMethod.accessFlag = Integer.parseInt(fields[1]);
                String[] methodField = fields[2].split(" ");
                traceMethod.className = methodField[0].replace("/", ".");
                traceMethod.methodName = methodField[1];
                if (methodField.length > 2) {
                    traceMethod.desc = methodField[2].replace("/", ".");
                }
                if (this.mMethodId.get() < traceMethod.id) {
                    this.mMethodId.set(traceMethod.id);
                }
                if (!this.mTraceConfig.isNeedTrace(traceMethod.className, this.mMappingCollector)) continue;
                this.mCollectedMethodMap.put(traceMethod.getMethodName(), traceMethod);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerCollectMethodFromSrc(File srcFile, boolean isSingle) {
        ArrayList<File> classFileList = new ArrayList<File>();
        if (srcFile.isDirectory()) {
            this.listClassFiles(classFileList, srcFile);
        } else {
            classFileList.add(srcFile);
        }
        for (File classFile : classFileList) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(classFile);
                ClassReader classReader = new ClassReader((InputStream)is);
                ClassWriter classWriter = new ClassWriter(1);
                ClassVisitor visitor = isSingle ? new SingleTraceClassAdapter(327680, (ClassVisitor)classWriter) : new TraceClassAdapter(327680, (ClassVisitor)classWriter);
                classReader.accept(visitor, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void innerCollectMethodFromJar(File fromJar, boolean isSingle) {
        block11: {
            ZipFile zipFile = null;
            zipFile = new ZipFile(fromJar);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String zipEntryName = zipEntry.getName();
                if (!this.mTraceConfig.isNeedTraceClass(zipEntryName)) continue;
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                ClassReader classReader = new ClassReader(inputStream);
                ClassWriter classWriter = new ClassWriter(1);
                ClassVisitor visitor = isSingle ? new SingleTraceClassAdapter(327680, (ClassVisitor)classWriter) : new TraceClassAdapter(327680, (ClassVisitor)classWriter);
                classReader.accept(visitor, 0);
            }
            try {
                zipFile.close();
            }
            catch (Exception e) {
                Log.e(TAG, "close stream err! fromJar:%s", fromJar.getAbsolutePath());
            }
            break block11;
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        zipFile.close();
                    }
                    catch (Exception e2) {
                        Log.e(TAG, "close stream err! fromJar:%s", fromJar.getAbsolutePath());
                    }
                    throw throwable;
                }
                try {
                    zipFile.close();
                }
                catch (Exception e3) {
                    Log.e(TAG, "close stream err! fromJar:%s", fromJar.getAbsolutePath());
                }
            }
        }
    }

    private void listClassFiles(ArrayList<File> classFiles, File folder) {
        File[] files = folder.listFiles();
        if (null == files) {
            Log.e(TAG, "[listClassFiles] files is null! %s", folder.getAbsolutePath());
            return;
        }
        for (File file : files) {
            if (file == null) continue;
            if (file.isDirectory()) {
                this.listClassFiles(classFiles, file);
                continue;
            }
            if (null == file || !file.isFile() || !this.mTraceConfig.isNeedTraceClass(file.getName())) continue;
            classFiles.add(file);
        }
    }

    private class CollectMethodNode
    extends MethodNode {
        private String className;
        private boolean isConstructor;

        CollectMethodNode(String className, int access, String name, String desc, String signature, String[] exceptions) {
            super(327680, access, name, desc, signature, exceptions);
            this.className = className;
        }

        public void visitEnd() {
            super.visitEnd();
            TraceMethod traceMethod = TraceMethod.create(0, this.access, this.className, this.name, this.desc);
            if ("<init>".equals(this.name)) {
                this.isConstructor = true;
            }
            if ((this.isEmptyMethod() || this.isGetSetMethod() || this.isSingleMethod()) && MethodCollector.this.mTraceConfig.isNeedTrace(traceMethod.className, MethodCollector.this.mMappingCollector)) {
                MethodCollector.this.mIgnoreCount++;
                MethodCollector.this.mCollectedIgnoreMethodMap.put(traceMethod.getMethodName(), traceMethod);
                return;
            }
            if (MethodCollector.this.mTraceConfig.isNeedTrace(traceMethod.className, MethodCollector.this.mMappingCollector) && !MethodCollector.this.mCollectedMethodMap.containsKey(traceMethod.getMethodName())) {
                traceMethod.id = MethodCollector.this.mMethodId.incrementAndGet();
                MethodCollector.this.mCollectedMethodMap.put(traceMethod.getMethodName(), traceMethod);
                MethodCollector.this.mIncrementCount++;
            } else if (!MethodCollector.this.mTraceConfig.isNeedTrace(traceMethod.className, MethodCollector.this.mMappingCollector) && !MethodCollector.this.mCollectedBlackMethodMap.containsKey(traceMethod.className)) {
                MethodCollector.this.mIgnoreCount++;
                MethodCollector.this.mCollectedBlackMethodMap.put(traceMethod.getMethodName(), traceMethod);
            }
        }

        private boolean isGetSetMethod() {
            int ignoreCount = 0;
            for (AbstractInsnNode insnNode : this.instructions) {
                int opcode = insnNode.getOpcode();
                if (-1 == opcode || opcode == 180 || opcode == 178 || opcode == 1 || opcode == 2 || opcode == 177 || opcode == 176 || opcode == 175 || opcode == 174 || opcode == 173 || opcode == 172 || opcode == 181 || opcode == 179 || opcode == 3 || opcode == 4 || opcode <= 53) continue;
                if (this.isConstructor && opcode == 183) {
                    if (++ignoreCount <= 1) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        private boolean isSingleMethod() {
            for (AbstractInsnNode insnNode : this.instructions) {
                int opcode = insnNode.getOpcode();
                if (-1 == opcode || 182 > opcode || opcode > 186) continue;
                return false;
            }
            return true;
        }

        private boolean isEmptyMethod() {
            for (AbstractInsnNode insnNode : this.instructions) {
                int opcode = insnNode.getOpcode();
                if (-1 == opcode) continue;
                return false;
            }
            return true;
        }
    }

    private class TraceClassAdapter
    extends ClassVisitor {
        private String className;
        private boolean isABSClass;

        TraceClassAdapter(int i, ClassVisitor classVisitor) {
            super(i, classVisitor);
            this.isABSClass = false;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.className = name;
            if ((access & 0x400) > 0 || (access & 0x200) > 0) {
                this.isABSClass = true;
            }
            MethodCollector.this.mCollectedClassExtendMap.put(this.className, superName);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.isABSClass) {
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
            return new CollectMethodNode(this.className, access, name, desc, signature, exceptions);
        }

        public void visitEnd() {
            super.visitEnd();
        }
    }

    private class SingleTraceClassAdapter
    extends ClassVisitor {
        SingleTraceClassAdapter(int i, ClassVisitor classVisitor) {
            super(i, classVisitor);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            MethodCollector.this.mCollectedClassExtendMap.put(name, superName);
        }
    }
}

