/*
 * Decompiled with CFR 0.152.
 */
package com.codelibs.systrace;

import java.io.PrintWriter;
import java.io.StringWriter;

public class Log {
    private static LogImp debugLog;
    private static LogImp logImp;

    private Log() {
    }

    public static void setLogImp(LogImp imp) {
        logImp = imp;
    }

    public static LogImp getImpl() {
        return logImp;
    }

    public static void v(String tag, String msg, Object ... obj) {
        if (logImp != null) {
            logImp.v(tag, msg, obj);
        }
    }

    public static void e(String tag, String msg, Object ... obj) {
        if (logImp != null) {
            logImp.e(tag, msg, obj);
        }
    }

    public static void w(String tag, String msg, Object ... obj) {
        if (logImp != null) {
            logImp.w(tag, msg, obj);
        }
    }

    public static void i(String tag, String msg, Object ... obj) {
        if (logImp != null) {
            logImp.i(tag, msg, obj);
        }
    }

    public static void d(String tag, String msg, Object ... obj) {
        if (logImp != null) {
            logImp.d(tag, msg, obj);
        }
    }

    public static void printErrStackTrace(String tag, Throwable tr, String format, Object ... obj) {
        if (logImp != null) {
            logImp.printErrStackTrace(tag, tr, format, obj);
        }
    }

    static {
        logImp = debugLog = new LogImp(){

            @Override
            public void v(String tag, String msg, Object ... obj) {
                String log = obj == null ? msg : String.format(msg, obj);
                System.out.println(String.format("[VERBOSE][%s]%s", tag, log));
            }

            @Override
            public void i(String tag, String msg, Object ... obj) {
                String log = obj == null ? msg : String.format(msg, obj);
                System.out.println(String.format("[INFO][%s]%s", tag, log));
            }

            @Override
            public void d(String tag, String msg, Object ... obj) {
                String log = obj == null ? msg : String.format(msg, obj);
                System.out.println(String.format("[DEBUG][%s]%s", tag, log));
            }

            @Override
            public void w(String tag, String msg, Object ... obj) {
                String log = obj == null ? msg : String.format(msg, obj);
                System.out.println(String.format("[WARN][%s]%s", tag, log));
            }

            @Override
            public void e(String tag, String msg, Object ... obj) {
                String log = obj == null ? msg : String.format(msg, obj);
                System.out.println(String.format("[ERROR][%s]%s", tag, log));
            }

            @Override
            public void printErrStackTrace(String tag, Throwable tr, String format, Object ... obj) {
                String log;
                String string = log = obj == null ? format : String.format(format, obj);
                if (log == null) {
                    log = "";
                }
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                tr.printStackTrace(pw);
                log = log + "  " + sw.toString();
                System.out.println(String.format("[ERROR][%s]%s", tag, log));
            }
        };
    }

    public static interface LogImp {
        public void v(String var1, String var2, Object ... var3);

        public void i(String var1, String var2, Object ... var3);

        public void w(String var1, String var2, Object ... var3);

        public void d(String var1, String var2, Object ... var3);

        public void e(String var1, String var2, Object ... var3);

        public void printErrStackTrace(String var1, Throwable var2, String var3, Object ... var4);
    }
}

