/*
 * Decompiled with CFR 0.152.
 */
package com.zeroarst.compiler;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.zeroarst.compiler.ClassValidator;
import com.zeroarst.library.Callback;
import com.zeroarst.library.CallbackFragment;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.zeroarst.library.CallbackFragment"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public final class CallbackFragmentProcessor
extends AbstractProcessor {
    private Messager mMgr;
    private boolean mHelperClassGenerated = false;
    private static final String CLEAR_FRAGMENT_CALLBACK_FIELDS_METHOD_NAME = "clearFragmentCallbackFields";
    private static final String FRAGMENT_CALLBACK_FIELDS_NAME = "mFragmentCallbackFields";
    private static final String HELPER_CLASS_NAME = "_CallbackFragmentHelper";
    private static final String HELPER_CAST_METHOD_NAME = "castFragmentCallback";
    private static final ClassName FRAGMENT_CLASS_NAME = ClassName.get((String)"android.support.v4.app", (String)"Fragment", (String[])new String[0]);

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.mMgr = processingEnvironment.getMessager();
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(CallbackFragment.class)) {
            TypeElement annotatedClass = (TypeElement)element;
            if (!this.isValidClass(annotatedClass)) {
                return true;
            }
            try {
                if (!this.mHelperClassGenerated) {
                    this.generateHelperClass(annotatedClass);
                    this.mHelperClassGenerated = true;
                }
                this.generateFragmentCode(annotatedClass);
            }
            catch (IOException e) {
                this.mMgr.printMessage(Diagnostic.Kind.ERROR, String.format("Couldn't generate class for %s: %s", annotatedClass, e.getMessage()), element);
            }
        }
        return true;
    }

    private boolean isSubClass(TypeElement typeElement, ClassName superClassName) {
        TypeElement superTypeElement = (TypeElement)((DeclaredType)typeElement.getSuperclass()).asElement();
        if (superTypeElement.toString().equals(Object.class.getName())) {
            return false;
        }
        if (superTypeElement.toString().equals(superClassName.reflectionName())) {
            return true;
        }
        return this.isSubClass(superTypeElement, superClassName);
    }

    private boolean isValidClass(TypeElement annotatedClass) {
        ClassValidator classValidator = new ClassValidator(annotatedClass);
        if (!this.isSubClass(annotatedClass, FRAGMENT_CLASS_NAME)) {
            this.mMgr.printMessage(Diagnostic.Kind.ERROR, String.format("Classes annotated with %s must extend %s", CallbackFragment.class.getSimpleName(), FRAGMENT_CLASS_NAME), annotatedClass);
            return false;
        }
        if (!classValidator.isPublic()) {
            this.mMgr.printMessage(Diagnostic.Kind.ERROR, String.format("Classes annotated with %s must be public", CallbackFragment.class.getSimpleName()), annotatedClass);
            return false;
        }
        if (classValidator.isAbstract()) {
            this.mMgr.printMessage(Diagnostic.Kind.ERROR, String.format("Classes annotated with %s must not be abstract.", CallbackFragment.class.getSimpleName()), annotatedClass);
            return false;
        }
        return true;
    }

    private void generateFragmentCode(TypeElement annotatedClass) throws IOException {
        PackageElement pkg = this.processingEnv.getElementUtils().getPackageOf(annotatedClass);
        ClassName annotatedClassName = ClassName.get((TypeElement)annotatedClass);
        String packageName = pkg.getQualifiedName().toString();
        ClassName generatedClassName = ClassName.get((String)packageName, (String)(annotatedClass.getSimpleName().toString() + "Callbackable"), (String[])new String[0]);
        MethodSpec createMs = MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addStatement("$T fg = new $T()", new Object[]{generatedClassName, generatedClassName}).addStatement("fg.setArguments(new $T())", new Object[]{ClassName.get((String)"android.os", (String)"Bundle", (String[])new String[0])}).addStatement("return fg", new Object[0]).returns((TypeName)annotatedClassName).build();
        MethodSpec onAttachMs = MethodSpec.methodBuilder((String)"onAttach").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get((String)"android.content", (String)"Context", (String[])new String[0]), "context", new Modifier[0]).addStatement("super.onAttach(context)", new Object[0]).addStatement("_CallbackFragmentHelper.castFragmentCallback(this, mFragmentCallbackFields)", new Object[0]).build();
        MethodSpec onDetachMs = MethodSpec.methodBuilder((String)"onDetach").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super.onDetach()", new Object[0]).addStatement("_CallbackFragmentHelper.clearFragmentCallbackFields(this, mFragmentCallbackFields)", new Object[0]).build();
        FieldSpec callbackFieldSpec = FieldSpec.builder((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{Field.class}), (String)FRAGMENT_CALLBACK_FIELDS_NAME, (Modifier[])new Modifier[]{Modifier.PRIVATE}).initializer("new $T<$T>()", new Object[]{ArrayList.class, Field.class}).build();
        TypeSpec ts = TypeSpec.classBuilder((ClassName)generatedClassName).superclass((TypeName)annotatedClassName).addField(callbackFieldSpec).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(createMs).addMethod(onAttachMs).addMethod(onDetachMs).build();
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)ts).build();
        javaFile.writeTo(this.processingEnv.getFiler());
    }

    private void generateHelperClass(TypeElement annotatedClass) throws IOException {
        PackageElement pkg = this.processingEnv.getElementUtils().getPackageOf(annotatedClass);
        String packageName = pkg.getQualifiedName().toString();
        CodeBlock cb = CodeBlock.builder().add("for (Class<?> cls : fragment.getClass().getSuperclass().getDeclaredClasses()) {\n", new Object[0]).add("    $T callback = cls.getAnnotation($T.class);\n", new Object[]{Callback.class, Callback.class}).add("    if (callback == null)\n", new Object[0]).add("        continue;\n", new Object[0]).add("    for ($T f : fragment.getClass().getSuperclass().getDeclaredFields()) {\n", new Object[]{Field.class}).add("        if (f.getType() != cls)\n", new Object[0]).add("            continue;\n", new Object[0]).add("        String formatter = \"%s must implement \" + cls.toString();\n", new Object[0]).add("        try {\n", new Object[0]).add("            if (fragment.getTargetFragment() != null) {\n", new Object[0]).add("                if (cls.isAssignableFrom(fragment.getTargetFragment().getClass())) {\n", new Object[0]).add("                    if (!f.isAccessible());\n", new Object[0]).add("                        f.setAccessible(true);\n", new Object[0]).add("                    f.set(fragment, fragment.getTargetFragment());\n", new Object[0]).add("                    fragmentCallbackFields.add(f);\n", new Object[0]).add("                } else if (callback.mandatory())\n", new Object[0]).add("                    throw new ClassCastException(String.format(formatter, fragment.getTargetFragment().getClass()));\n", new Object[0]).add("            } else if (fragment.getParentFragment() != null) {\n", new Object[0]).add("                if (cls.isAssignableFrom(fragment.getParentFragment().getClass())) {\n", new Object[0]).add("                    if (!f.isAccessible())\n", new Object[0]).add("                        f.setAccessible(true);\n", new Object[0]).add("                    f.set(fragment, fragment.getParentFragment());\n", new Object[0]).add("                    fragmentCallbackFields.add(f);\n", new Object[0]).add("                } else if (callback.mandatory())\n", new Object[0]).add("                    throw new ClassCastException(String.format(formatter, fragment.getParentFragment().getClass()));\n", new Object[0]).add("            } else {\n", new Object[0]).add("                if (cls.isAssignableFrom(fragment.getContext().getClass())) {\n", new Object[0]).add("                    if (!f.isAccessible())\n", new Object[0]).add("                        f.setAccessible(true);\n", new Object[0]).add("                    f.set(fragment, fragment.getContext());\n", new Object[0]).add("                    fragmentCallbackFields.add(f);\n", new Object[0]).add("                } else if (callback.mandatory())\n", new Object[0]).add("                    throw new ClassCastException(String.format(formatter, fragment.getContext().getClass()));\n", new Object[0]).add("            }\n", new Object[0]).add("        } catch (IllegalAccessException e) {\n", new Object[0]).add("            $T.e(TAG, e.getMessage(), e);\n", new Object[]{ClassName.get((String)"android.util", (String)"Log", (String[])new String[0])}).add("        }\n", new Object[0]).add("    }\n", new Object[0]).add("}\n", new Object[0]).build();
        MethodSpec castFragmentCallbackMs = MethodSpec.methodBuilder((String)HELPER_CAST_METHOD_NAME).addModifiers(new Modifier[]{Modifier.STATIC}).addParameter((TypeName)ClassName.get((String)"android.support.v4.app", (String)"Fragment", (String[])new String[0]), "fragment", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{Field.class}), "fragmentCallbackFields", new Modifier[0]).addCode(cb).build();
        MethodSpec clearFragmentCallbackFieldMs = MethodSpec.methodBuilder((String)CLEAR_FRAGMENT_CALLBACK_FIELDS_METHOD_NAME).addModifiers(new Modifier[]{Modifier.STATIC}).addParameter((TypeName)ClassName.get((String)"android.support.v4.app", (String)"Fragment", (String[])new String[0]), "fragment", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{Field.class}), "fragmentCallbackFields", new Modifier[0]).addCode("for ($T f : fragmentCallbackFields) {\n", new Object[]{Field.class}).addCode("    try {\n", new Object[0]).addCode("        f.set(fragment, null);\n", new Object[0]).addCode("    } catch (IllegalAccessException e) { \n", new Object[0]).addCode("        $T.e(TAG, e.getMessage(), e);\n", new Object[]{ClassName.get((String)"android.util", (String)"Log", (String[])new String[0])}).addCode("    }\n", new Object[0]).addCode("}\n", new Object[0]).build();
        ClassName generatedClassName = ClassName.get((String)packageName, (String)HELPER_CLASS_NAME, (String[])new String[0]);
        TypeSpec ts = TypeSpec.classBuilder((ClassName)generatedClassName).addField(FieldSpec.builder(String.class, (String)"TAG", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("\"$T\"", new Object[]{generatedClassName}).build()).addModifiers(new Modifier[]{Modifier.FINAL}).addMethod(castFragmentCallbackMs).addMethod(clearFragmentCallbackFieldMs).build();
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)ts).build();
        javaFile.writeTo(this.processingEnv.getFiler());
    }
}

