// Copyright © 2020 IBA Group, a.s. All rights reserved. Use of this source code is governed by Eclipse Public License – v 2.0 that can be found at: https://www.eclipse.org/legal/epl-2.0/

package org.zowe.kotlinsdk.zowe.client.sdk.zostso

/**
 * Constants for various tso related info
 */
object TsoConstants {
  /**
   * Default character-set value
   */
  const val DEFAULT_CHSET = "697"

  /**
   * Default number of columns value
   */
  const val DEFAULT_COLS = "80"

  /**
   * Default code page value
   */
  const val DEFAULT_CPAGE = "1047"

  /**
   * Default logonProcedure value
   */
  const val DEFAULT_PROC = "IZUFPROC"

  /**
   * Default number of rows value
   */
  const val DEFAULT_ROWS = "24"

  /**
   * Default region-size value
   */
  const val DEFAULT_RSIZE = "4096"

  /**
   * z/OSMF unknown error
   */
  const val ZOSMF_UNKNOWN_ERROR = "zOSMF unknown error response"
}
