# Zowe CLI Third Party Library Usage

* [Imperative CLI Framework for Zowe](#imperative-cli-framework-for-zowe-dependency-attributions)
* [Zowe CLI](#zowe-cli-dependency-attributions)
* [IBM&reg CICS&reg Plug-in for Zowe CLI](#ibm&reg-cics&reg-plug-in-for-zowe-cli-dependency-attributions)
* [IBM&reg Db2&reg Plug-in for Zowe CLI](#ibm&reg-db2&reg-plug-in-for-zowe-cli-dependency-attributions)
* [Performance Timing Utility](#performance-timing-utility-dependency-attributions)
* [IBM&reg MQ Plug-in for Zowe CLI](#ibm&reg-mq-plug-in-for-zowe-cli-dependency-attributions)
* [z/OS&reg FTP Plug-in for Zowe CLI](#z/os&reg-ftp-plug-in-for-zowe-cli-dependency-attributions)
* [IBM&reg IMS&reg Plug-in for Zowe CLI](#ibm&reg-ims&reg-plug-in-for-zowe-cli-dependency-attributions)

### Imperative CLI Framework for Zowe Dependency Attributions
| Third-party Software | Version | License | GitHub |
| -------------------- | --------| ------- | ------ |
| agent-base | 6.0.2 | MIT | [agent-base](https://github.com/TooTallNate/node-agent-base#readme) | 
| agentkeepalive | 4.2.1 | MIT | [agentkeepalive](https://github.com/node-modules/agentkeepalive#readme) | 
| aggregate-error | 3.1.0 | MIT | [aggregate-error](https://github.com/sindresorhus/aggregate-error#readme) | 
| ansi-regex | 5.0.1 | MIT | [ansi-regex](https://github.com/chalk/ansi-regex#readme) | 
| ansi-styles | 3.2.1 | MIT | [ansi-styles](https://github.com/chalk/ansi-styles#readme) | 
| ansi-styles | 4.3.0 | MIT | [ansi-styles](https://github.com/chalk/ansi-styles#readme) | 
| ansi-styles | 5.2.0 | MIT | [ansi-styles](https://github.com/chalk/ansi-styles#readme) | 
| argparse | 1.0.10 | MIT | [argparse](https://github.com/nodeca/argparse#readme) | 
| argparse | 2.0.1 | Python-2.0 | [argparse](https://github.com/nodeca/argparse#readme) | 
| array-timsort | 1.0.3 | MIT | [array-timsort](https://github.com/kaelzhang/node-array-timsort) | 
| balanced-match | 1.0.2 | MIT | [balanced-match](https://github.com/juliangruber/balanced-match) | 
| balloon-css | 1.2.0 | MIT | [balloon-css](http://kazzkiq.github.io/balloon.css/) | 
| bootstrap | 4.6.0 | MIT | [bootstrap](https://getbootstrap.com/) | 
| brace-expansion | 1.1.11 | MIT | [brace-expansion](https://github.com/juliangruber/brace-expansion) | 
| braces | 3.0.2 | MIT | [braces](https://github.com/micromatch/braces) | 
| builtins | 1.0.3 | MIT | [builtins](https://github.com/juliangruber/builtins#readme) | 
| builtins | 5.0.1 | MIT | [builtins](https://github.com/juliangruber/builtins#readme) | 
| cacache | 15.3.0 | ISC | [cacache](https://github.com/npm/cacache#readme) | 
| camelcase | 5.3.1 | MIT | [camelcase](https://github.com/sindresorhus/camelcase#readme) | 
| chalk | 2.4.2 | MIT | [chalk](https://github.com/chalk/chalk#readme) | 
| chalk | 4.1.2 | MIT | [chalk](https://github.com/chalk/chalk#readme) | 
| chownr | 1.1.4 | ISC | [chownr](https://github.com/isaacs/chownr#readme) | 
| chownr | 2.0.0 | ISC | [chownr](https://github.com/isaacs/chownr#readme) | 
| clean-stack | 2.2.0 | MIT | [clean-stack](https://github.com/sindresorhus/clean-stack#readme) | 
| cli-table3 | 0.6.2 | MIT | [cli-table3](https://github.com/cli-table/cli-table3) | 
| clipboard | 2.0.8 | MIT | [clipboard](https://clipboardjs.com) | 
| cliui | 6.0.0 | ISC | [cliui](https://github.com/yargs/cliui#readme) | 
| color-convert | 1.9.3 | MIT | [color-convert](https://github.com/Qix-/color-convert#readme) | 
| color-convert | 2.0.1 | MIT | [color-convert](https://github.com/Qix-/color-convert#readme) | 
| color-name | 1.1.3 | MIT | [color-name](https://github.com/dfcreative/color-name) | 
| color-name | 1.1.4 | MIT | [color-name](https://github.com/colorjs/color-name) | 
| colors | 1.4.0 | MIT | [colors](https://github.com/Marak/colors.js) | 
| comment-json | 4.1.1 | MIT | [comment-json](https://github.com/kaelzhang/node-comment-json#readme) | 
| compute-scroll-into-view | 1.0.17 | MIT | [compute-scroll-into-view](https://scroll-into-view-if-needed.netlify.com) | 
| concat-map | 0.0.1 | MIT | [concat-map](https://github.com/substack/node-concat-map) | 
| core-util-is | 1.0.3 | MIT | [core-util-is](https://github.com/isaacs/core-util-is#readme) | 
| cross-spawn | 7.0.3 | MIT | [cross-spawn](https://github.com/moxystudio/node-cross-spawn) | 
| dataobject-parser | 1.2.1 | MIT | [dataobject-parser](https://github.com/Gigzolo/dataobject-parser) | 
| date-format | 4.0.9 | MIT | [date-format](https://github.com/nomiddlename/date-format#readme) | 
| debug | 4.3.4 | MIT | [debug](https://github.com/debug-js/debug#readme) | 
| decamelize | 1.2.0 | MIT | [decamelize](https://github.com/sindresorhus/decamelize#readme) | 
| deepmerge | 4.2.2 | MIT | [deepmerge](https://github.com/TehShrike/deepmerge) | 
| delegate | 3.2.0 | MIT | [delegate](https://github.com/zenorocha/delegate#readme) | 
| depd | 1.1.2 | MIT | [depd](https://github.com/dougwilson/nodejs-depd#readme) | 
| diff | 5.1.0 | BSD-3-Clause | [diff](https://github.com/kpdecker/jsdiff#readme) | 
| diff-sequences | 27.0.6 | MIT | [diff-sequences](https://github.com/facebook/jest#readme) | 
| diff2html | 3.4.20-usewontache.1.60e7a2e | MIT | [diff2html](https://diff2html.xyz) | 
| emoji-regex | 8.0.0 | MIT | [emoji-regex](https://mths.be/emoji-regex) | 
| encoding | 0.1.13 | MIT | [encoding](https://github.com/andris9/encoding#readme) | 
| entities | 2.1.0 | BSD-2-Clause | [entities](https://github.com/fb55/entities#readme) | 
| err-code | 1.1.2 | MIT | [err-code](https://github.com/IndigoUnited/js-err-code#readme) | 
| err-code | 2.0.3 | MIT | [err-code](https://github.com/IndigoUnited/js-err-code#readme) | 
| escape-string-regexp | 1.0.5 | MIT | [escape-string-regexp](https://github.com/sindresorhus/escape-string-regexp) | 
| esprima | 4.0.1 | BSD-2-Clause | [esprima](http://esprima.org) | 
| fast-glob | 3.2.7 | MIT | [fast-glob](https://github.com/mrmlnc/fast-glob#readme) | 
| fastest-levenshtein | 1.0.12 | MIT | [fastest-levenshtein](https://github.com/ka-weihe/fastest-levenshtein#README) | 
| fastq | 1.13.0 | ISC | [fastq](https://github.com/mcollina/fastq#readme) | 
| fill-range | 7.0.1 | MIT | [fill-range](https://github.com/jonschlinkert/fill-range) | 
| find-up | 2.1.0 | MIT | [find-up](https://github.com/sindresorhus/find-up#readme) | 
| find-up | 4.1.0 | MIT | [find-up](https://github.com/sindresorhus/find-up#readme) | 
| flatted | 3.2.5 | ISC | [flatted](https://github.com/WebReflection/flatted#readme) | 
| fs-extra | 8.1.0 | MIT | [fs-extra](https://github.com/jprichardson/node-fs-extra) | 
| fs-extra | 10.1.0 | MIT | [fs-extra](https://github.com/jprichardson/node-fs-extra) | 
| fs-minipass | 2.1.0 | ISC | [fs-minipass](https://github.com/npm/fs-minipass#readme) | 
| fs.realpath | 1.0.0 | ISC | [fs.realpath](https://github.com/isaacs/fs.realpath#readme) | 
| get-caller-file | 2.0.5 | ISC | [get-caller-file](https://github.com/stefanpenner/get-caller-file#readme) | 
| github-markdown-css | 5.1.0 | MIT | [github-markdown-css](https://github.com/sindresorhus/github-markdown-css#readme) | 
| glob | 7.2.3 | ISC | [glob](https://github.com/isaacs/node-glob#readme) | 
| glob-parent | 5.1.2 | ISC | [glob-parent](https://github.com/gulpjs/glob-parent#readme) | 
| good-listener | 1.2.2 | MIT | [good-listener](https://github.com/zenorocha/good-listener#readme) | 
| graceful-fs | 4.2.10 | ISC | [graceful-fs](https://github.com/isaacs/node-graceful-fs#readme) | 
| has-flag | 3.0.0 | MIT | [has-flag](https://github.com/sindresorhus/has-flag#readme) | 
| has-flag | 4.0.0 | MIT | [has-flag](https://github.com/sindresorhus/has-flag#readme) | 
| has-own-prop | 2.0.0 | MIT | [has-own-prop](https://github.com/sindresorhus/has-own-prop#readme) | 
| highlight.js | 11.6.0 | BSD-3-Clause | [highlight.js](https://highlightjs.org/) | 
| hosted-git-info | 4.1.0 | ISC | [hosted-git-info](https://github.com/npm/hosted-git-info) | 
| hosted-git-info | 5.1.0 | ISC | [hosted-git-info](https://github.com/npm/hosted-git-info) | 
| http-cache-semantics | 4.1.1 | BSD-2-Clause | [http-cache-semantics](https://github.com/kornelski/http-cache-semantics#readme) | 
| http-proxy-agent | 4.0.1 | MIT | [http-proxy-agent](https://github.com/TooTallNate/node-http-proxy-agent#readme) | 
| https-proxy-agent | 5.0.1 | MIT | [https-proxy-agent](https://github.com/TooTallNate/node-https-proxy-agent#readme) | 
| humanize-ms | 1.2.1 | MIT | [humanize-ms](https://github.com/node-modules/humanize-ms#readme) | 
| iconv-lite | 0.6.3 | MIT | [iconv-lite](https://github.com/ashtuchkin/iconv-lite) | 
| ignore-walk | 3.0.4 | ISC | [ignore-walk](https://github.com/isaacs/ignore-walk#readme) | 
| imurmurhash | 0.1.4 | MIT | [imurmurhash](https://github.com/jensyt/imurmurhash-js) | 
| indent-string | 4.0.0 | MIT | [indent-string](https://github.com/sindresorhus/indent-string#readme) | 
| infer-owner | 1.0.4 | ISC | [infer-owner](https://github.com/npm/infer-owner#readme) | 
| inflight | 1.0.6 | ISC | [inflight](https://github.com/isaacs/inflight) | 
| inherits | 2.0.4 | ISC | [inherits](https://github.com/isaacs/inherits#readme) | 
| ip | 2.0.0 | MIT | [ip](https://github.com/indutny/node-ip) | 
| is-extglob | 2.1.1 | MIT | [is-extglob](https://github.com/jonschlinkert/is-extglob) | 
| is-fullwidth-code-point | 3.0.0 | MIT | [is-fullwidth-code-point](https://github.com/sindresorhus/is-fullwidth-code-point#readme) | 
| is-glob | 4.0.3 | MIT | [is-glob](https://github.com/micromatch/is-glob) | 
| is-lambda | 1.0.1 | MIT | [is-lambda](https://github.com/watson/is-lambda) | 
| is-number | 7.0.0 | MIT | [is-number](https://github.com/jonschlinkert/is-number) | 
| isexe | 2.0.0 | ISC | [isexe](https://github.com/isaacs/isexe#readme) | 
| jest-diff | 27.0.6 | MIT | [jest-diff](https://github.com/facebook/jest#readme) | 
| jest-get-type | 27.0.6 | MIT | [jest-get-type](https://github.com/facebook/jest#readme) | 
| jquery | 3.6.0 | MIT | [jquery](https://jquery.com) | 
| js-yaml | 4.1.0 | MIT | [js-yaml](https://github.com/nodeca/js-yaml#readme) | 
| json-parse-even-better-errors | 2.3.1 | MIT | [json-parse-even-better-errors](https://github.com/npm/json-parse-even-better-errors#readme) | 
| jsonfile | 4.0.0 | MIT | [jsonfile](https://github.com/jprichardson/node-jsonfile#readme) | 
| jsonfile | 6.1.0 | MIT | [jsonfile](https://github.com/jprichardson/node-jsonfile#readme) | 
| jsonparse | 1.3.1 | MIT | [jsonparse](https://github.com/creationix/jsonparse#readme) | 
| jsonschema | 1.1.1 | MIT | [jsonschema](https://github.com/tdegrunt/jsonschema#readme) | 
| jstree | 3.3.12 | MIT | [jstree](http://jstree.com) | 
| linkify-it | 3.0.3 | MIT | [linkify-it](https://github.com/markdown-it/linkify-it#readme) | 
| locate-path | 2.0.0 | MIT | [locate-path](https://github.com/sindresorhus/locate-path#readme) | 
| locate-path | 5.0.0 | MIT | [locate-path](https://github.com/sindresorhus/locate-path#readme) | 
| lodash | 4.17.21 | MIT | [lodash](https://lodash.com/) | 
| lodash-deep | 2.0.0 | MIT | [lodash-deep](https://github.com/marklagendijk/lodash-deep) | 
| log4js | 6.4.6 | Apache-2.0 | [log4js](https://log4js-node.github.io/log4js-node/) | 
| lru-cache | 5.1.1 | ISC | [lru-cache](https://github.com/isaacs/node-lru-cache#readme) | 
| lru-cache | 6.0.0 | ISC | [lru-cache](https://github.com/isaacs/node-lru-cache#readme) | 
| lru-cache | 7.14.0 | ISC | [lru-cache](https://github.com/isaacs/node-lru-cache#readme) | 
| make-fetch-happen | 8.0.14 | ISC | [make-fetch-happen](https://github.com/npm/make-fetch-happen#readme) | 
| markdown-it | 12.3.2 | MIT | [markdown-it](https://github.com/markdown-it/markdown-it#readme) | 
| mdurl | 1.0.1 | MIT | [mdurl](https://github.com/markdown-it/mdurl#readme) | 
| merge2 | 1.4.1 | MIT | [merge2](https://github.com/teambition/merge2) | 
| micromatch | 4.0.4 | MIT | [micromatch](https://github.com/micromatch/micromatch) | 
| minimatch | 3.0.8 | ISC | [minimatch](https://github.com/isaacs/minimatch#readme) | 
| minimatch | 3.1.2 | ISC | [minimatch](https://github.com/isaacs/minimatch#readme) | 
| minimist | 1.2.6 | MIT | [minimist](https://github.com/substack/minimist) | 
| minipass | 3.3.4 | ISC | [minipass](https://github.com/isaacs/minipass#readme) | 
| minipass-collect | 1.0.2 | ISC | [minipass-collect](https://github.com/isaacs/minipass-collect#readme) | 
| minipass-fetch | 1.4.1 | MIT | [minipass-fetch](https://github.com/npm/minipass-fetch#readme) | 
| minipass-flush | 1.0.5 | ISC | [minipass-flush](https://github.com/isaacs/minipass-flush#readme) | 
| minipass-json-stream | 1.0.1 | MIT | [minipass-json-stream](https://github.com/npm/minipass-json-stream#readme) | 
| minipass-pipeline | 1.2.4 | ISC | [minipass-pipeline]() | 
| minipass-sized | 1.0.3 | ISC | [minipass-sized](https://github.com/isaacs/minipass-sized#readme) | 
| minizlib | 2.1.2 | MIT | [minizlib](https://github.com/isaacs/minizlib#readme) | 
| mkdirp | 1.0.4 | MIT | [mkdirp](https://github.com/isaacs/node-mkdirp#readme) | 
| ms | 2.1.2 | MIT | [ms](https://github.com/zeit/ms#readme) | 
| mustache | 2.3.0 | MIT | [mustache](https://github.com/janl/mustache.js) | 
| mute-stream | 0.0.8 | ISC | [mute-stream](https://github.com/isaacs/mute-stream#readme) | 
| npm-bundled | 1.1.2 | ISC | [npm-bundled](https://github.com/npm/npm-bundled#readme) | 
| npm-install-checks | 4.0.0 | BSD-2-Clause | [npm-install-checks](https://github.com/npm/npm-install-checks#readme) | 
| npm-normalize-package-bin | 1.0.1 | ISC | [npm-normalize-package-bin](https://github.com/npm/npm-normalize-package-bin#readme) | 
| npm-package-arg | 8.1.5 | ISC | [npm-package-arg](https://github.com/npm/npm-package-arg) | 
| npm-package-arg | 9.1.0 | ISC | [npm-package-arg](https://github.com/npm/npm-package-arg) | 
| npm-packlist | 2.2.2 | ISC | [npm-packlist](https://github.com/npm/npm-packlist#readme) | 
| npm-pick-manifest | 6.1.1 | ISC | [npm-pick-manifest](https://github.com/npm/npm-pick-manifest#readme) | 
| npm-registry-fetch | 8.1.5 | ISC | [npm-registry-fetch](https://github.com/npm/registry-fetch#readme) | 
| once | 1.4.0 | ISC | [once](https://github.com/isaacs/once#readme) | 
| opener | 1.5.2 | (WTFPL OR MIT) | [opener](https://github.com/domenic/opener#readme) | 
| p-limit | 1.3.0 | MIT | [p-limit](https://github.com/sindresorhus/p-limit#readme) | 
| p-limit | 2.3.0 | MIT | [p-limit](https://github.com/sindresorhus/p-limit#readme) | 
| p-locate | 2.0.0 | MIT | [p-locate](https://github.com/sindresorhus/p-locate#readme) | 
| p-locate | 4.1.0 | MIT | [p-locate](https://github.com/sindresorhus/p-locate#readme) | 
| p-map | 4.0.0 | MIT | [p-map](https://github.com/sindresorhus/p-map#readme) | 
| p-try | 1.0.0 | MIT | [p-try](https://github.com/sindresorhus/p-try#readme) | 
| p-try | 2.2.0 | MIT | [p-try](https://github.com/sindresorhus/p-try#readme) | 
| pacote | 11.1.4 | ISC | [pacote](https://github.com/npm/pacote#readme) | 
| path-exists | 3.0.0 | MIT | [path-exists](https://github.com/sindresorhus/path-exists#readme) | 
| path-exists | 4.0.0 | MIT | [path-exists](https://github.com/sindresorhus/path-exists#readme) | 
| path-is-absolute | 1.0.1 | MIT | [path-is-absolute](https://github.com/sindresorhus/path-is-absolute#readme) | 
| path-key | 3.1.1 | MIT | [path-key](https://github.com/sindresorhus/path-key#readme) | 
| picomatch | 2.3.0 | MIT | [picomatch](https://github.com/micromatch/picomatch) | 
| pkg-up | 2.0.0 | MIT | [pkg-up](https://github.com/sindresorhus/pkg-up#readme) | 
| pretty-format | 27.2.5 | MIT | [pretty-format](https://github.com/facebook/jest#readme) | 
| prettyjson | 1.2.2 | MIT | [prettyjson](http://rafeca.com/prettyjson) | 
| proc-log | 2.0.1 | ISC | [proc-log](https://github.com/npm/proc-log#readme) | 
| progress | 2.0.3 | MIT | [progress](https://github.com/visionmedia/node-progress#readme) | 
| promise-inflight | 1.0.1 | ISC | [promise-inflight](https://github.com/iarna/promise-inflight#readme) | 
| promise-retry | 1.1.1 | MIT | [promise-retry](https://github.com/IndigoUnited/node-promise-retry#readme) | 
| promise-retry | 2.0.1 | MIT | [promise-retry](https://github.com/IndigoUnited/node-promise-retry#readme) | 
| queue-microtask | 1.2.3 | MIT | [queue-microtask](https://github.com/feross/queue-microtask) | 
| react-is | 17.0.2 | MIT | [react-is](https://reactjs.org/) | 
| read | 1.0.7 | ISC | [read](https://github.com/isaacs/read#readme) | 
| read-package-json-fast | 1.2.2 | ISC | [read-package-json-fast](https://github.com/npm/read-package-json-fast#readme) | 
| readline-sync | 1.4.10 | MIT | [readline-sync](https://github.com/anseki/readline-sync) | 
| repeat-string | 1.6.1 | MIT | [repeat-string](https://github.com/jonschlinkert/repeat-string) | 
| require-directory | 2.1.1 | MIT | [require-directory](https://github.com/troygoode/node-require-directory/) | 
| require-main-filename | 2.0.0 | ISC | [require-main-filename](https://github.com/yargs/require-main-filename#readme) | 
| retry | 0.10.1 | MIT | [retry](https://github.com/tim-kos/node-retry) | 
| retry | 0.12.0 | MIT | [retry](https://github.com/tim-kos/node-retry) | 
| reusify | 1.0.4 | MIT | [reusify](https://github.com/mcollina/reusify#readme) | 
| rfdc | 1.3.0 | MIT | [rfdc](https://github.com/davidmarkclements/rfdc#readme) | 
| rimraf | 2.7.1 | ISC | [rimraf](https://github.com/isaacs/rimraf#readme) | 
| rimraf | 3.0.2 | ISC | [rimraf](https://github.com/isaacs/rimraf#readme) | 
| run-parallel | 1.2.0 | MIT | [run-parallel](https://github.com/feross/run-parallel) | 
| safer-buffer | 2.1.2 | MIT | [safer-buffer](https://github.com/ChALkeR/safer-buffer#readme) | 
| scroll-into-view-if-needed | 2.2.28 | MIT | [scroll-into-view-if-needed](https://scroll-into-view-if-needed.netlify.com) | 
| select | 1.1.2 | MIT | [select](https://github.com/zenorocha/select#readme) | 
| semver | 7.5.2 | ISC | [semver](https://github.com/npm/node-semver#readme) | 
| set-blocking | 2.0.0 | ISC | [set-blocking](https://github.com/yargs/set-blocking#readme) | 
| shebang-command | 2.0.0 | MIT | [shebang-command](https://github.com/kevva/shebang-command#readme) | 
| shebang-regex | 3.0.0 | MIT | [shebang-regex](https://github.com/sindresorhus/shebang-regex#readme) | 
| smart-buffer | 4.2.0 | MIT | [smart-buffer](https://github.com/JoshGlazebrook/smart-buffer/) | 
| socks | 2.7.0 | MIT | [socks](https://github.com/JoshGlazebrook/socks/) | 
| socks-proxy-agent | 5.0.1 | MIT | [socks-proxy-agent](https://github.com/TooTallNate/node-socks-proxy-agent#readme) | 
| split.js | 1.6.4 | MIT | [split.js](https://split.js.org/) | 
| sprintf-js | 1.0.3 | BSD-3-Clause | [sprintf-js](https://github.com/alexei/sprintf.js#readme) | 
| ssri | 8.0.1 | ISC | [ssri](https://github.com/npm/ssri#readme) | 
| stack-trace | 0.0.10 | MIT | [stack-trace](https://github.com/felixge/node-stack-trace) | 
| streamroller | 3.0.8 | MIT | [streamroller](https://github.com/nomiddlename/streamroller#readme) | 
| string-width | 4.2.3 | MIT | [string-width](https://github.com/sindresorhus/string-width#readme) | 
| strip-ansi | 6.0.1 | MIT | [strip-ansi](https://github.com/chalk/strip-ansi#readme) | 
| supports-color | 5.5.0 | MIT | [supports-color](https://github.com/chalk/supports-color#readme) | 
| supports-color | 7.2.0 | MIT | [supports-color](https://github.com/chalk/supports-color#readme) | 
| tar | 6.1.11 | ISC | [tar](https://github.com/npm/node-tar#readme) | 
| tiny-emitter | 2.1.0 | MIT | [tiny-emitter](https://github.com/scottcorgan/tiny-emitter#readme) | 
| to-regex-range | 5.0.1 | MIT | [to-regex-range](https://github.com/micromatch/to-regex-range) | 
| uc.micro | 1.0.6 | MIT | [uc.micro](https://github.com/markdown-it/uc.micro#readme) | 
| underscore | 1.13.4 | MIT | [underscore](https://underscorejs.org) | 
| unique-filename | 1.1.1 | ISC | [unique-filename](https://github.com/iarna/unique-filename) | 
| unique-slug | 2.0.2 | ISC | [unique-slug](https://github.com/iarna/unique-slug#readme) | 
| universalify | 0.1.2 | MIT | [universalify](https://github.com/RyanZim/universalify#readme) | 
| universalify | 2.0.0 | MIT | [universalify](https://github.com/RyanZim/universalify#readme) | 
| url-search-params-polyfill | 8.1.1 | MIT | [url-search-params-polyfill](https://github.com/jerrybendy/url-search-params-polyfill) | 
| validate-npm-package-name | 3.0.0 | ISC | [validate-npm-package-name](https://github.com/npm/validate-npm-package-name) | 
| validate-npm-package-name | 4.0.0 | ISC | [validate-npm-package-name](https://github.com/npm/validate-npm-package-name) | 
| which | 2.0.2 | ISC | [which](https://github.com/isaacs/node-which#readme) | 
| which | 3.0.0 | ISC | [which](https://github.com/npm/node-which#readme) | 
| which-module | 2.0.0 | ISC | [which-module](https://github.com/nexdrew/which-module#readme) | 
| wontache | 0.1.0 | BSD-3-Clause | [wontache](https://jgonggrijp.gitlab.io/wontache/) | 
| wrap-ansi | 6.2.0 | MIT | [wrap-ansi](https://github.com/chalk/wrap-ansi#readme) | 
| wrap-ansi | 7.0.0 | MIT | [wrap-ansi](https://github.com/chalk/wrap-ansi#readme) | 
| wrappy | 1.0.2 | ISC | [wrappy](https://github.com/npm/wrappy) | 
| y18n | 4.0.3 | ISC | [y18n](https://github.com/yargs/y18n) | 
| yallist | 3.1.1 | ISC | [yallist](https://github.com/isaacs/yallist#readme) | 
| yallist | 4.0.0 | ISC | [yallist](https://github.com/isaacs/yallist#readme) | 
| yamljs | 0.3.0 | MIT | [yamljs](https://github.com/jeremyfa/yaml.js#readme) | 
| yargs | 15.3.1 | MIT | [yargs](https://yargs.js.org/) | 
| yargs-parser | 18.1.3 | ISC | [yargs-parser](https://github.com/yargs/yargs-parser#readme) | 
| @colors/colors | 1.5.0 | MIT | [colors](https://github.com/DABH/colors.js) | 
| @gar/promisify | 1.1.3 | MIT | [promisify](https://github.com/wraithgar/gar-promisify#readme) | 
| @jest/types | 27.2.5 | MIT | [types](https://github.com/facebook/jest#readme) | 
| @nodelib/fs.scandir | 2.1.5 | MIT | [fs.scandir](https://github.com/nodelib/nodelib/tree/master#readme) | 
| @nodelib/fs.stat | 2.0.5 | MIT | [fs.stat](https://github.com/nodelib/nodelib/tree/master#readme) | 
| @nodelib/fs.walk | 1.2.8 | MIT | [fs.walk](https://github.com/nodelib/nodelib/tree/master#readme) | 
| @npmcli/ci-detect | 1.4.0 | ISC | [ci-detect](https://github.com/npm/ci-detect#readme) | 
| @npmcli/fs | 1.1.1 | ISC | [fs](https://github.com/npm/fs#readme) | 
| @npmcli/git | 2.1.0 | ISC | [git](https://github.com/npm/git#readme) | 
| @npmcli/installed-package-contents | 1.0.7 | ISC | [installed-package-contents](https://github.com/npm/installed-package-contents#readme) | 
| @npmcli/move-file | 1.1.2 | MIT | [move-file](https://github.com/npm/move-file#readme) | 
| @npmcli/promise-spawn | 1.3.2 | ISC | [promise-spawn](https://github.com/npm/promise-spawn#readme) | 
| @tootallnate/once | 1.1.2 | MIT | [once](https://github.com/TooTallNate/once#readme) | 
| @types/istanbul-lib-coverage | 2.0.3 | MIT | [istanbul-lib-coverage](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/istanbul-lib-coverage) | 
| @types/istanbul-lib-report | 3.0.0 | MIT | [istanbul-lib-report](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/istanbul-lib-report) | 
| @types/istanbul-reports | 3.0.1 | MIT | [istanbul-reports](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/istanbul-reports) | 
| @types/node | 14.18.28 | MIT | [node](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/node) | 
| @types/yargs | 13.0.4 | MIT | [yargs](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/yargs) | 
| @types/yargs | 16.0.4 | MIT | [yargs](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/yargs) | 
| @types/yargs-parser | 20.2.1 | MIT | [yargs-parser](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/yargs-parser) | 
| @zowe/perf-timing | 1.0.7 | EPL-2.0 | [perf-timing](https://github.com/zowe/perf-timing.git) | 

### Zowe CLI Dependency Attributions
| Third-party Software | Version | License | GitHub |
| -------------------- | --------| ------- | ------ |
| anyhow | 1.0.69 | MIT OR Apache-2.0 | [anyhow](https://github.com/dtolnay/anyhow.git) | 
| async-stream | 0.3.5 | MIT | [async-stream](https://github.com/tokio-rs/async-stream.git) | 
| async-stream-impl | 0.3.5 | MIT | [async-stream-impl](https://github.com/tokio-rs/async-stream.git) | 
| base64 | 0.13.1 | Apache-2.0 | [base64](https://github.com/marshallpierce/rust-base64.git) | 
| bitflags | 2.3.3 | MIT OR Apache-2.0 | [bitflags](https://github.com/bitflags/bitflags) | 
| bumpalo | 3.12.0 | Apache-2.0 | [bumpalo](https://github.com/fitzgen/bumpalo.git) | 
| bytes | 1.4.0 | MIT | [bytes](https://github.com/tokio-rs/bytes.git) | 
| cfg-if | 1.0.0 | Apache-2.0 | [cfg-if](https://github.com/alexcrichton/cfg-if) | 
| core-foundation-sys | 0.8.3 | Apache-2.0 | [core-foundation-sys](https://github.com/servo/core-foundation-rs) | 
| crossbeam-channel | 0.5.8 | MIT OR Apache-2.0 | [crossbeam-channel](https://github.com/crossbeam-rs/crossbeam/tree/master/crossbeam-channel) | 
| crossbeam-deque | 0.8.3 | MIT OR Apache-2.0 | [crossbeam-deque](https://github.com/crossbeam-rs/crossbeam/tree/master/crossbeam-deque) | 
| crossbeam-epoch | 0.9.14 | MIT OR Apache-2.0 | [crossbeam-epoch](https://github.com/crossbeam-rs/crossbeam/tree/master/crossbeam-epoch) | 
| crossbeam-utils | 0.8.15 | MIT OR Apache-2.0 | [crossbeam-utils](https://github.com/crossbeam-rs/crossbeam/tree/master/crossbeam-utils) | 
| either | 1.8.1 | MIT OR Apache-2.0 | [either](https://github.com/bluss/either.git) | 
| errno | 0.3.1 | MIT OR Apache-2.0 | [errno](https://github.com/lambda-fairy/rust-errno.git) | 
| errno-dragonfly | 0.1.2 | MIT | [errno-dragonfly](https://github.com/mneumann/errno-dragonfly-rs.git) | 
| fslock | 0.2.1 | MIT | [fslock](https://github.com/brunoczim/fslock.git) | 
| futures-core | 0.3.28 | MIT OR Apache-2.0 | [futures-core](https://rust-lang.github.io/futures-rs) | 
| hermit-abi | 0.2.6 | Apache-2.0 | [hermit-abi](https://github.com/hermitcore/rusty-hermit.git) | 
| hermit-abi | 0.3.2 | MIT OR Apache-2.0 | [hermit-abi](https://github.com/hermitcore/rusty-hermit.git) | 
| home | 0.5.4 | MIT OR Apache-2.0 | [home](https://github.com/brson/home.git) | 
| is-terminal | 0.4.9 | MIT | [is-terminal](https://github.com/sunfishcode/is-terminal.git) | 
| is_ci | 1.1.1 | ISC | [is_ci](https://github.com/zkat/is_ci.git) | 
| itoa | 1.0.6 | MIT OR Apache-2.0 | [itoa](https://github.com/dtolnay/itoa.git) | 
| js-sys | 0.3.61 | Apache-2.0 | [js-sys](https://rustwasm.github.io/wasm-bindgen/) | 
| libc | 0.2.147 | MIT OR Apache-2.0 | [libc](https://github.com/rust-lang/libc) | 
| linux-raw-sys | 0.4.3 | Apache-2.0 WITH LLVM-exception OR Apache-2.0 OR MIT | [linux-raw-sys](https://github.com/sunfishcode/linux-raw-sys.git) | 
| log | 0.4.17 | MIT OR Apache-2.0 | [log](https://github.com/rust-lang/log.git) | 
| memoffset | 0.8.0 | MIT | [memoffset](https://github.com/Gilnaa/memoffset.git) | 
| mio | 0.8.6 | MIT | [mio](https://github.com/tokio-rs/mio) | 
| ntapi | 0.4.0 | Apache-2.0 OR MIT | [ntapi](https://github.com/MSxDOS/ntapi.git) | 
| num_cpus | 1.15.0 | MIT OR Apache-2.0 | [num_cpus](https://github.com/seanmonstar/num_cpus.git) | 
| once_cell | 1.17.1 | MIT OR Apache-2.0 | [once_cell](https://github.com/matklad/once_cell.git) | 
| pathsearch | 0.2.0 | MIT | [pathsearch](https://github.com/wez/wzsh.git) | 
| pin-project-lite | 0.2.9 | Apache-2.0 OR MIT | [pin-project-lite](https://github.com/taiki-e/pin-project-lite.git) | 
| proc-macro2 | 1.0.52 | MIT OR Apache-2.0 | [proc-macro2](https://github.com/dtolnay/proc-macro2.git) | 
| quote | 1.0.26 | MIT OR Apache-2.0 | [quote](https://github.com/dtolnay/quote.git) | 
| rayon | 1.7.0 | MIT OR Apache-2.0 | [rayon](https://github.com/rayon-rs/rayon.git) | 
| rayon-core | 1.11.0 | MIT OR Apache-2.0 | [rayon-core](https://github.com/rayon-rs/rayon.git) | 
| rpassword | 5.0.1 | Apache-2.0 | [rpassword](https://github.com/conradkleinespel/rpassword) | 
| rustix | 0.38.3 | Apache-2.0 WITH LLVM-exception OR Apache-2.0 OR MIT | [rustix](https://github.com/bytecodealliance/rustix.git) | 
| ryu | 1.0.13 | Apache-2.0 OR BSL-1.0 | [ryu](https://github.com/dtolnay/ryu.git) | 
| scopeguard | 1.1.0 | Apache-2.0 | [scopeguard](https://github.com/bluss/scopeguard.git) | 
| serde | 1.0.156 | MIT OR Apache-2.0 | [serde](https://serde.rs) | 
| serde_derive | 1.0.156 | MIT OR Apache-2.0 | [serde_derive](https://serde.rs) | 
| serde_json | 1.0.94 | MIT OR Apache-2.0 | [serde_json](https://github.com/serde-rs/json.git) | 
| simple-error | 0.2.3 | Apache-2.0 | [simple-error](https://github.com/WiSaGaN/simple-error.git) | 
| socket2 | 0.4.9 | MIT OR Apache-2.0 | [socket2](https://github.com/rust-lang/socket2) | 
| supports-color | 2.0.0 | Apache-2.0 | [supports-color](https://github.com/zkat/supports-color.git) | 
| syn | 1.0.109 | MIT OR Apache-2.0 | [syn](https://github.com/dtolnay/syn.git) | 
| syn | 2.0.12 | MIT OR Apache-2.0 | [syn](https://github.com/dtolnay/syn.git) | 
| sysinfo | 0.29.4 | MIT | [sysinfo](https://github.com/GuillaumeGomez/sysinfo.git) | 
| tokio | 1.28.0 | MIT | [tokio](https://tokio.rs) | 
| tokio-macros | 2.1.0 | MIT | [tokio-macros](https://tokio.rs) | 
| tokio-stream | 0.1.14 | MIT | [tokio-stream](https://tokio.rs) | 
| tokio-test | 0.4.2 | MIT | [tokio-test](https://tokio.rs) | 
| unicode-ident | 1.0.8 | (MIT OR Apache-2.0) AND Unicode-DFS-2016 | [unicode-ident](https://github.com/dtolnay/unicode-ident.git) | 
| wasi | 0.11.0+wasi-snapshot-preview1 | Apache-2.0 WITH LLVM-exception OR Apache-2.0 OR MIT | [wasi](https://github.com/bytecodealliance/wasi.git) | 
| wasm-bindgen | 0.2.84 | Apache-2.0 | [wasm-bindgen](https://rustwasm.github.io/) | 
| wasm-bindgen-backend | 0.2.84 | Apache-2.0 | [wasm-bindgen-backend](https://rustwasm.github.io/wasm-bindgen/) | 
| wasm-bindgen-macro | 0.2.84 | Apache-2.0 | [wasm-bindgen-macro](https://rustwasm.github.io/wasm-bindgen/) | 
| wasm-bindgen-macro-support | 0.2.84 | Apache-2.0 | [wasm-bindgen-macro-support](https://rustwasm.github.io/wasm-bindgen/) | 
| wasm-bindgen-shared | 0.2.84 | Apache-2.0 | [wasm-bindgen-shared](https://rustwasm.github.io/wasm-bindgen/) | 
| web-sys | 0.3.61 | Apache-2.0 | [web-sys](https://rustwasm.github.io/wasm-bindgen/web-sys/index.html) | 
| whoami | 1.4.0 | Apache-2.0 OR BSL-1.0 OR MIT | [whoami](https://github.com/ardaku/whoami/blob/stable/CHANGELOG.md) | 
| winapi | 0.3.9 | Apache-2.0 | [winapi](https://github.com/retep998/winapi-rs.git) | 
| winapi-i686-pc-windows-gnu | 0.4.0 | Apache-2.0 | [winapi-i686-pc-windows-gnu](https://github.com/retep998/winapi-rs.git) | 
| winapi-x86_64-pc-windows-gnu | 0.4.0 | Apache-2.0 | [winapi-x86_64-pc-windows-gnu](https://github.com/retep998/winapi-rs.git) | 
| windows-sys | 0.45.0 | MIT OR Apache-2.0 | [windows-sys](https://github.com/microsoft/windows-rs.git) | 
| windows-sys | 0.48.0 | MIT OR Apache-2.0 | [windows-sys](https://github.com/microsoft/windows-rs.git) | 
| windows-targets | 0.42.2 | MIT OR Apache-2.0 | [windows-targets](https://github.com/microsoft/windows-rs.git) | 
| windows-targets | 0.48.0 | MIT OR Apache-2.0 | [windows-targets](https://github.com/microsoft/windows-rs.git) | 
| windows_aarch64_gnullvm | 0.42.2 | MIT OR Apache-2.0 | [windows_aarch64_gnullvm](https://github.com/microsoft/windows-rs.git) | 
| windows_aarch64_gnullvm | 0.48.0 | MIT OR Apache-2.0 | [windows_aarch64_gnullvm](https://github.com/microsoft/windows-rs.git) | 
| windows_aarch64_msvc | 0.42.2 | MIT OR Apache-2.0 | [windows_aarch64_msvc](https://github.com/microsoft/windows-rs.git) | 
| windows_aarch64_msvc | 0.48.0 | MIT OR Apache-2.0 | [windows_aarch64_msvc](https://github.com/microsoft/windows-rs.git) | 
| windows_i686_gnu | 0.42.2 | MIT OR Apache-2.0 | [windows_i686_gnu](https://github.com/microsoft/windows-rs.git) | 
| windows_i686_gnu | 0.48.0 | MIT OR Apache-2.0 | [windows_i686_gnu](https://github.com/microsoft/windows-rs.git) | 
| windows_i686_msvc | 0.42.2 | MIT OR Apache-2.0 | [windows_i686_msvc](https://github.com/microsoft/windows-rs.git) | 
| windows_i686_msvc | 0.48.0 | MIT OR Apache-2.0 | [windows_i686_msvc](https://github.com/microsoft/windows-rs.git) | 
| windows_x86_64_gnu | 0.42.2 | MIT OR Apache-2.0 | [windows_x86_64_gnu](https://github.com/microsoft/windows-rs.git) | 
| windows_x86_64_gnu | 0.48.0 | MIT OR Apache-2.0 | [windows_x86_64_gnu](https://github.com/microsoft/windows-rs.git) | 
| windows_x86_64_gnullvm | 0.42.2 | MIT OR Apache-2.0 | [windows_x86_64_gnullvm](https://github.com/microsoft/windows-rs.git) | 
| windows_x86_64_gnullvm | 0.48.0 | MIT OR Apache-2.0 | [windows_x86_64_gnullvm](https://github.com/microsoft/windows-rs.git) | 
| windows_x86_64_msvc | 0.42.2 | MIT OR Apache-2.0 | [windows_x86_64_msvc](https://github.com/microsoft/windows-rs.git) | 
| windows_x86_64_msvc | 0.48.0 | MIT OR Apache-2.0 | [windows_x86_64_msvc](https://github.com/microsoft/windows-rs.git) | 
| yansi | 0.5.1 | Apache-2.0 | [yansi](https://github.com/SergioBenitez/yansi.git) | 
| agent-base | 6.0.2 | MIT | [agent-base](https://github.com/TooTallNate/node-agent-base#readme) | 
| agentkeepalive | 4.2.1 | MIT | [agentkeepalive](https://github.com/node-modules/agentkeepalive#readme) | 
| aggregate-error | 3.1.0 | MIT | [aggregate-error](https://github.com/sindresorhus/aggregate-error#readme) | 
| ansi-regex | 2.1.1 | MIT | [ansi-regex](https://github.com/chalk/ansi-regex#readme) | 
| ansi-regex | 5.0.1 | MIT | [ansi-regex](https://github.com/chalk/ansi-regex#readme) | 
| ansi-styles | 3.2.1 | MIT | [ansi-styles](https://github.com/chalk/ansi-styles#readme) | 
| ansi-styles | 4.3.0 | MIT | [ansi-styles](https://github.com/chalk/ansi-styles#readme) | 
| ansi-styles | 5.2.0 | MIT | [ansi-styles](https://github.com/chalk/ansi-styles#readme) | 
| aproba | 1.2.0 | ISC | [aproba](https://github.com/iarna/aproba) | 
| are-we-there-yet | 1.1.7 | ISC | [are-we-there-yet](https://github.com/iarna/are-we-there-yet) | 
| argparse | 1.0.10 | MIT | [argparse](https://github.com/nodeca/argparse#readme) | 
| argparse | 2.0.1 | Python-2.0 | [argparse](https://github.com/nodeca/argparse#readme) | 
| array-timsort | 1.0.3 | MIT | [array-timsort](https://github.com/kaelzhang/node-array-timsort) | 
| asn1 | 0.2.6 | MIT | [asn1](https://github.com/joyent/node-asn1#readme) | 
| balanced-match | 1.0.2 | MIT | [balanced-match](https://github.com/juliangruber/balanced-match) | 
| base64-js | 1.5.1 | MIT | [base64-js](https://github.com/beatgammit/base64-js) | 
| bcrypt-pbkdf | 1.0.2 | BSD-3-Clause | [bcrypt-pbkdf](https://github.com/joyent/node-bcrypt-pbkdf#readme) | 
| bl | 4.1.0 | MIT | [bl](https://github.com/rvagg/bl) | 
| brace-expansion | 1.1.11 | MIT | [brace-expansion](https://github.com/juliangruber/brace-expansion) | 
| brace-expansion | 2.0.1 | MIT | [brace-expansion](https://github.com/juliangruber/brace-expansion) | 
| braces | 3.0.2 | MIT | [braces](https://github.com/micromatch/braces) | 
| buffer | 5.7.1 | MIT | [buffer](https://github.com/feross/buffer) | 
| buildcheck | 0.0.3 | MIT | [buildcheck](https://github.com/mscdex/buildcheck#readme) | 
| builtins | 1.0.3 | MIT | [builtins](https://github.com/juliangruber/builtins#readme) | 
| builtins | 5.0.1 | MIT | [builtins](https://github.com/juliangruber/builtins#readme) | 
| cacache | 15.3.0 | ISC | [cacache](https://github.com/npm/cacache#readme) | 
| camelcase | 5.3.1 | MIT | [camelcase](https://github.com/sindresorhus/camelcase#readme) | 
| chalk | 2.4.2 | MIT | [chalk](https://github.com/chalk/chalk#readme) | 
| chalk | 4.1.2 | MIT | [chalk](https://github.com/chalk/chalk#readme) | 
| chownr | 1.1.4 | ISC | [chownr](https://github.com/isaacs/chownr#readme) | 
| chownr | 2.0.0 | ISC | [chownr](https://github.com/isaacs/chownr#readme) | 
| clean-stack | 2.2.0 | MIT | [clean-stack](https://github.com/sindresorhus/clean-stack#readme) | 
| cli-table3 | 0.6.2 | MIT | [cli-table3](https://github.com/cli-table/cli-table3) | 
| cliui | 6.0.0 | ISC | [cliui](https://github.com/yargs/cliui#readme) | 
| code-point-at | 1.1.0 | MIT | [code-point-at](https://github.com/sindresorhus/code-point-at#readme) | 
| color-convert | 1.9.3 | MIT | [color-convert](https://github.com/Qix-/color-convert#readme) | 
| color-convert | 2.0.1 | MIT | [color-convert](https://github.com/Qix-/color-convert#readme) | 
| color-name | 1.1.3 | MIT | [color-name](https://github.com/dfcreative/color-name) | 
| color-name | 1.1.4 | MIT | [color-name](https://github.com/colorjs/color-name) | 
| colors | 1.4.0 | MIT | [colors](https://github.com/Marak/colors.js) | 
| commander | 5.1.0 | MIT | [commander](https://github.com/tj/commander.js#readme) | 
| comment-json | 4.1.1 | MIT | [comment-json](https://github.com/kaelzhang/node-comment-json#readme) | 
| concat-map | 0.0.1 | MIT | [concat-map](https://github.com/substack/node-concat-map) | 
| console-control-strings | 1.1.0 | ISC | [console-control-strings](https://github.com/iarna/console-control-strings#readme) | 
| core-util-is | 1.0.3 | MIT | [core-util-is](https://github.com/isaacs/core-util-is#readme) | 
| cpu-features | 0.0.4 | MIT | [cpu-features](https://github.com/mscdex/cpu-features#readme) | 
| cross-spawn | 7.0.3 | MIT | [cross-spawn](https://github.com/moxystudio/node-cross-spawn) | 
| dataobject-parser | 1.2.1 | MIT | [dataobject-parser](https://github.com/Gigzolo/dataobject-parser) | 
| date-format | 4.0.9 | MIT | [date-format](https://github.com/nomiddlename/date-format#readme) | 
| debug | 4.3.4 | MIT | [debug](https://github.com/debug-js/debug#readme) | 
| decamelize | 1.2.0 | MIT | [decamelize](https://github.com/sindresorhus/decamelize#readme) | 
| decompress-response | 6.0.0 | MIT | [decompress-response](https://github.com/sindresorhus/decompress-response#readme) | 
| deep-extend | 0.6.0 | MIT | [deep-extend](https://github.com/unclechu/node-deep-extend) | 
| deepmerge | 4.2.2 | MIT | [deepmerge](https://github.com/TehShrike/deepmerge) | 
| delegates | 1.0.0 | MIT | [delegates](https://github.com/visionmedia/node-delegates#readme) | 
| depd | 1.1.2 | MIT | [depd](https://github.com/dougwilson/nodejs-depd#readme) | 
| detect-libc | 2.0.0 | Apache-2.0 | [detect-libc](https://github.com/lovell/detect-libc#readme) | 
| diff | 5.1.0 | BSD-3-Clause | [diff](https://github.com/kpdecker/jsdiff#readme) | 
| diff-sequences | 27.4.0 | MIT | [diff-sequences](https://github.com/facebook/jest#readme) | 
| diff2html | 3.4.20-usewontache.1.60e7a2e | MIT | [diff2html](https://diff2html.xyz) | 
| emoji-regex | 8.0.0 | MIT | [emoji-regex](https://mths.be/emoji-regex) | 
| encoding | 0.1.13 | MIT | [encoding](https://github.com/andris9/encoding#readme) | 
| end-of-stream | 1.4.4 | MIT | [end-of-stream](https://github.com/mafintosh/end-of-stream) | 
| entities | 2.1.0 | BSD-2-Clause | [entities](https://github.com/fb55/entities#readme) | 
| err-code | 1.1.2 | MIT | [err-code](https://github.com/IndigoUnited/js-err-code#readme) | 
| err-code | 2.0.3 | MIT | [err-code](https://github.com/IndigoUnited/js-err-code#readme) | 
| escape-string-regexp | 1.0.5 | MIT | [escape-string-regexp](https://github.com/sindresorhus/escape-string-regexp) | 
| esprima | 4.0.1 | BSD-2-Clause | [esprima](http://esprima.org) | 
| expand-template | 2.0.3 | (MIT OR WTFPL) | [expand-template](https://github.com/ralphtheninja/expand-template) | 
| fast-glob | 3.2.7 | MIT | [fast-glob](https://github.com/mrmlnc/fast-glob#readme) | 
| fastest-levenshtein | 1.0.12 | MIT | [fastest-levenshtein](https://github.com/ka-weihe/fastest-levenshtein#README) | 
| fastq | 1.13.0 | ISC | [fastq](https://github.com/mcollina/fastq#readme) | 
| fill-range | 7.0.1 | MIT | [fill-range](https://github.com/jonschlinkert/fill-range) | 
| find-process | 1.4.7 | MIT | [find-process](https://github.com/yibn2008/find-process#readme) | 
| find-up | 2.1.0 | MIT | [find-up](https://github.com/sindresorhus/find-up#readme) | 
| find-up | 4.1.0 | MIT | [find-up](https://github.com/sindresorhus/find-up#readme) | 
| find-up | 5.0.0 | MIT | [find-up](https://github.com/sindresorhus/find-up#readme) | 
| flatted | 3.2.5 | ISC | [flatted](https://github.com/WebReflection/flatted#readme) | 
| fs-constants | 1.0.0 | MIT | [fs-constants](https://github.com/mafintosh/fs-constants) | 
| fs-extra | 8.1.0 | MIT | [fs-extra](https://github.com/jprichardson/node-fs-extra) | 
| fs-extra | 10.1.0 | MIT | [fs-extra](https://github.com/jprichardson/node-fs-extra) | 
| fs-minipass | 2.1.0 | ISC | [fs-minipass](https://github.com/npm/fs-minipass#readme) | 
| fs.realpath | 1.0.0 | ISC | [fs.realpath](https://github.com/isaacs/fs.realpath#readme) | 
| gauge | 2.7.4 | ISC | [gauge](https://github.com/iarna/gauge) | 
| get-caller-file | 2.0.5 | ISC | [get-caller-file](https://github.com/stefanpenner/get-caller-file#readme) | 
| get-stream | 6.0.1 | MIT | [get-stream](https://github.com/sindresorhus/get-stream#readme) | 
| github-from-package | 0.0.0 | MIT | [github-from-package](https://github.com/substack/github-from-package) | 
| glob | 7.2.3 | ISC | [glob](https://github.com/isaacs/node-glob#readme) | 
| glob-parent | 5.1.2 | ISC | [glob-parent](https://github.com/gulpjs/glob-parent#readme) | 
| graceful-fs | 4.2.9 | ISC | [graceful-fs](https://github.com/isaacs/node-graceful-fs#readme) | 
| has-flag | 3.0.0 | MIT | [has-flag](https://github.com/sindresorhus/has-flag#readme) | 
| has-flag | 4.0.0 | MIT | [has-flag](https://github.com/sindresorhus/has-flag#readme) | 
| has-own-prop | 2.0.0 | MIT | [has-own-prop](https://github.com/sindresorhus/has-own-prop#readme) | 
| has-unicode | 2.0.1 | ISC | [has-unicode](https://github.com/iarna/has-unicode) | 
| highlight.js | 11.6.0 | BSD-3-Clause | [highlight.js](https://highlightjs.org/) | 
| hosted-git-info | 3.0.8 | ISC | [hosted-git-info](https://github.com/npm/hosted-git-info) | 
| hosted-git-info | 4.1.0 | ISC | [hosted-git-info](https://github.com/npm/hosted-git-info) | 
| hosted-git-info | 5.1.0 | ISC | [hosted-git-info](https://github.com/npm/hosted-git-info) | 
| http-cache-semantics | 4.1.1 | BSD-2-Clause | [http-cache-semantics](https://github.com/kornelski/http-cache-semantics#readme) | 
| http-proxy-agent | 4.0.1 | MIT | [http-proxy-agent](https://github.com/TooTallNate/node-http-proxy-agent#readme) | 
| https-proxy-agent | 5.0.1 | MIT | [https-proxy-agent](https://github.com/TooTallNate/node-https-proxy-agent#readme) | 
| humanize-ms | 1.2.1 | MIT | [humanize-ms](https://github.com/node-modules/humanize-ms#readme) | 
| iconv-lite | 0.6.3 | MIT | [iconv-lite](https://github.com/ashtuchkin/iconv-lite) | 
| ieee754 | 1.2.1 | BSD-3-Clause | [ieee754](https://github.com/feross/ieee754#readme) | 
| ignore-walk | 3.0.4 | ISC | [ignore-walk](https://github.com/isaacs/ignore-walk#readme) | 
| imurmurhash | 0.1.4 | MIT | [imurmurhash](https://github.com/jensyt/imurmurhash-js) | 
| indent-string | 4.0.0 | MIT | [indent-string](https://github.com/sindresorhus/indent-string#readme) | 
| infer-owner | 1.0.4 | ISC | [infer-owner](https://github.com/npm/infer-owner#readme) | 
| inflight | 1.0.6 | ISC | [inflight](https://github.com/isaacs/inflight) | 
| inherits | 2.0.4 | ISC | [inherits](https://github.com/isaacs/inherits#readme) | 
| ini | 1.3.8 | ISC | [ini](https://github.com/isaacs/ini#readme) | 
| ip | 2.0.0 | MIT | [ip](https://github.com/indutny/node-ip) | 
| is-extglob | 2.1.1 | MIT | [is-extglob](https://github.com/jonschlinkert/is-extglob) | 
| is-fullwidth-code-point | 1.0.0 | MIT | [is-fullwidth-code-point](https://github.com/sindresorhus/is-fullwidth-code-point) | 
| is-fullwidth-code-point | 3.0.0 | MIT | [is-fullwidth-code-point](https://github.com/sindresorhus/is-fullwidth-code-point#readme) | 
| is-glob | 4.0.3 | MIT | [is-glob](https://github.com/micromatch/is-glob) | 
| is-lambda | 1.0.1 | MIT | [is-lambda](https://github.com/watson/is-lambda) | 
| is-number | 7.0.0 | MIT | [is-number](https://github.com/jonschlinkert/is-number) | 
| isarray | 1.0.0 | MIT | [isarray](https://github.com/juliangruber/isarray) | 
| isexe | 2.0.0 | ISC | [isexe](https://github.com/isaacs/isexe#readme) | 
| jest-diff | 27.0.6 | MIT | [jest-diff](https://github.com/facebook/jest#readme) | 
| jest-get-type | 27.4.0 | MIT | [jest-get-type](https://github.com/facebook/jest#readme) | 
| js-yaml | 4.1.0 | MIT | [js-yaml](https://github.com/nodeca/js-yaml#readme) | 
| json-parse-even-better-errors | 2.3.1 | MIT | [json-parse-even-better-errors](https://github.com/npm/json-parse-even-better-errors#readme) | 
| jsonfile | 4.0.0 | MIT | [jsonfile](https://github.com/jprichardson/node-jsonfile#readme) | 
| jsonfile | 6.1.0 | MIT | [jsonfile](https://github.com/jprichardson/node-jsonfile#readme) | 
| jsonparse | 1.3.1 | MIT | [jsonparse](https://github.com/creationix/jsonparse#readme) | 
| jsonschema | 1.1.1 | MIT | [jsonschema](https://github.com/tdegrunt/jsonschema#readme) | 
| keytar | 7.9.0 | MIT | [keytar](http://atom.github.io/node-keytar) | 
| linkify-it | 3.0.3 | MIT | [linkify-it](https://github.com/markdown-it/linkify-it#readme) | 
| locate-path | 2.0.0 | MIT | [locate-path](https://github.com/sindresorhus/locate-path#readme) | 
| locate-path | 5.0.0 | MIT | [locate-path](https://github.com/sindresorhus/locate-path#readme) | 
| locate-path | 6.0.0 | MIT | [locate-path](https://github.com/sindresorhus/locate-path#readme) | 
| lodash | 4.17.21 | MIT | [lodash](https://lodash.com/) | 
| lodash-deep | 2.0.0 | MIT | [lodash-deep](https://github.com/marklagendijk/lodash-deep) | 
| log4js | 6.4.6 | Apache-2.0 | [log4js](https://log4js-node.github.io/log4js-node/) | 
| lru-cache | 5.1.1 | ISC | [lru-cache](https://github.com/isaacs/node-lru-cache#readme) | 
| lru-cache | 6.0.0 | ISC | [lru-cache](https://github.com/isaacs/node-lru-cache#readme) | 
| lru-cache | 7.14.0 | ISC | [lru-cache](https://github.com/isaacs/node-lru-cache#readme) | 
| make-fetch-happen | 8.0.14 | ISC | [make-fetch-happen](https://github.com/npm/make-fetch-happen#readme) | 
| markdown-it | 12.3.2 | MIT | [markdown-it](https://github.com/markdown-it/markdown-it#readme) | 
| mdurl | 1.0.1 | MIT | [mdurl](https://github.com/markdown-it/mdurl#readme) | 
| merge2 | 1.4.1 | MIT | [merge2](https://github.com/teambition/merge2) | 
| micromatch | 4.0.4 | MIT | [micromatch](https://github.com/micromatch/micromatch) | 
| mimic-response | 3.1.0 | MIT | [mimic-response](https://github.com/sindresorhus/mimic-response#readme) | 
| minimatch | 3.1.2 | ISC | [minimatch](https://github.com/isaacs/minimatch#readme) | 
| minimatch | 5.0.1 | ISC | [minimatch](https://github.com/isaacs/minimatch#readme) | 
| minimist | 1.2.6 | MIT | [minimist](https://github.com/substack/minimist) | 
| minipass | 3.3.5 | ISC | [minipass](https://github.com/isaacs/minipass#readme) | 
| minipass | 5.0.0 | ISC | [minipass](https://github.com/isaacs/minipass#readme) | 
| minipass-collect | 1.0.2 | ISC | [minipass-collect](https://github.com/isaacs/minipass-collect#readme) | 
| minipass-fetch | 1.4.1 | MIT | [minipass-fetch](https://github.com/npm/minipass-fetch#readme) | 
| minipass-flush | 1.0.5 | ISC | [minipass-flush](https://github.com/isaacs/minipass-flush#readme) | 
| minipass-json-stream | 1.0.1 | MIT | [minipass-json-stream](https://github.com/npm/minipass-json-stream#readme) | 
| minipass-pipeline | 1.2.4 | ISC | [minipass-pipeline]() | 
| minipass-sized | 1.0.3 | ISC | [minipass-sized](https://github.com/isaacs/minipass-sized#readme) | 
| minizlib | 2.1.2 | MIT | [minizlib](https://github.com/isaacs/minizlib#readme) | 
| mkdirp | 1.0.4 | MIT | [mkdirp](https://github.com/isaacs/node-mkdirp#readme) | 
| mkdirp-classic | 0.5.3 | MIT | [mkdirp-classic](https://github.com/mafintosh/mkdirp-classic) | 
| ms | 2.1.2 | MIT | [ms](https://github.com/zeit/ms#readme) | 
| mustache | 2.3.0 | MIT | [mustache](https://github.com/janl/mustache.js) | 
| mute-stream | 0.0.8 | ISC | [mute-stream](https://github.com/isaacs/mute-stream#readme) | 
| nan | 2.17.0 | MIT | [nan](https://github.com/nodejs/nan#readme) | 
| napi-build-utils | 1.0.2 | MIT | [napi-build-utils](https://github.com/inspiredware/napi-build-utils#readme) | 
| node-abi | 3.7.0 | MIT | [node-abi](https://github.com/lgeiger/node-abi#readme) | 
| node-addon-api | 4.3.0 | MIT | [node-addon-api](https://github.com/nodejs/node-addon-api) | 
| npm-bundled | 1.1.2 | ISC | [npm-bundled](https://github.com/npm/npm-bundled#readme) | 
| npm-install-checks | 4.0.0 | BSD-2-Clause | [npm-install-checks](https://github.com/npm/npm-install-checks#readme) | 
| npm-normalize-package-bin | 1.0.1 | ISC | [npm-normalize-package-bin](https://github.com/npm/npm-normalize-package-bin#readme) | 
| npm-package-arg | 8.1.1 | ISC | [npm-package-arg](https://github.com/npm/npm-package-arg) | 
| npm-package-arg | 8.1.5 | ISC | [npm-package-arg](https://github.com/npm/npm-package-arg) | 
| npm-package-arg | 9.1.0 | ISC | [npm-package-arg](https://github.com/npm/npm-package-arg) | 
| npm-packlist | 2.2.2 | ISC | [npm-packlist](https://github.com/npm/npm-packlist#readme) | 
| npm-pick-manifest | 6.1.1 | ISC | [npm-pick-manifest](https://github.com/npm/npm-pick-manifest#readme) | 
| npm-registry-fetch | 8.1.5 | ISC | [npm-registry-fetch](https://github.com/npm/registry-fetch#readme) | 
| npmlog | 4.1.2 | ISC | [npmlog](https://github.com/npm/npmlog#readme) | 
| number-is-nan | 1.0.1 | MIT | [number-is-nan](https://github.com/sindresorhus/number-is-nan#readme) | 
| object-assign | 4.1.1 | MIT | [object-assign](https://github.com/sindresorhus/object-assign#readme) | 
| once | 1.4.0 | ISC | [once](https://github.com/isaacs/once#readme) | 
| opener | 1.5.2 | (WTFPL OR MIT) | [opener](https://github.com/domenic/opener#readme) | 
| p-limit | 1.3.0 | MIT | [p-limit](https://github.com/sindresorhus/p-limit#readme) | 
| p-limit | 2.3.0 | MIT | [p-limit](https://github.com/sindresorhus/p-limit#readme) | 
| p-limit | 3.1.0 | MIT | [p-limit](https://github.com/sindresorhus/p-limit#readme) | 
| p-locate | 2.0.0 | MIT | [p-locate](https://github.com/sindresorhus/p-locate#readme) | 
| p-locate | 4.1.0 | MIT | [p-locate](https://github.com/sindresorhus/p-locate#readme) | 
| p-locate | 5.0.0 | MIT | [p-locate](https://github.com/sindresorhus/p-locate#readme) | 
| p-map | 4.0.0 | MIT | [p-map](https://github.com/sindresorhus/p-map#readme) | 
| p-try | 1.0.0 | MIT | [p-try](https://github.com/sindresorhus/p-try#readme) | 
| p-try | 2.2.0 | MIT | [p-try](https://github.com/sindresorhus/p-try#readme) | 
| pacote | 11.1.4 | ISC | [pacote](https://github.com/npm/pacote#readme) | 
| path-exists | 3.0.0 | MIT | [path-exists](https://github.com/sindresorhus/path-exists#readme) | 
| path-exists | 4.0.0 | MIT | [path-exists](https://github.com/sindresorhus/path-exists#readme) | 
| path-is-absolute | 1.0.1 | MIT | [path-is-absolute](https://github.com/sindresorhus/path-is-absolute#readme) | 
| path-key | 3.1.1 | MIT | [path-key](https://github.com/sindresorhus/path-key#readme) | 
| picomatch | 2.3.1 | MIT | [picomatch](https://github.com/micromatch/picomatch) | 
| pkg-up | 2.0.0 | MIT | [pkg-up](https://github.com/sindresorhus/pkg-up#readme) | 
| prebuild-install | 7.0.1 | MIT | [prebuild-install](https://github.com/prebuild/prebuild-install) | 
| pretty-format | 27.4.6 | MIT | [pretty-format](https://github.com/facebook/jest#readme) | 
| prettyjson | 1.2.2 | MIT | [prettyjson](http://rafeca.com/prettyjson) | 
| proc-log | 2.0.1 | ISC | [proc-log](https://github.com/npm/proc-log#readme) | 
| process-nextick-args | 2.0.1 | MIT | [process-nextick-args](https://github.com/calvinmetcalf/process-nextick-args) | 
| progress | 2.0.3 | MIT | [progress](https://github.com/visionmedia/node-progress#readme) | 
| promise-inflight | 1.0.1 | ISC | [promise-inflight](https://github.com/iarna/promise-inflight#readme) | 
| promise-retry | 1.1.1 | MIT | [promise-retry](https://github.com/IndigoUnited/node-promise-retry#readme) | 
| promise-retry | 2.0.1 | MIT | [promise-retry](https://github.com/IndigoUnited/node-promise-retry#readme) | 
| pump | 3.0.0 | MIT | [pump](https://github.com/mafintosh/pump#readme) | 
| queue-microtask | 1.2.3 | MIT | [queue-microtask](https://github.com/feross/queue-microtask) | 
| rc | 1.2.8 | (BSD-2-Clause OR MIT OR Apache-2.0) | [rc](https://github.com/dominictarr/rc#readme) | 
| react-is | 17.0.2 | MIT | [react-is](https://reactjs.org/) | 
| read | 1.0.7 | ISC | [read](https://github.com/isaacs/read#readme) | 
| read-package-json-fast | 1.2.2 | ISC | [read-package-json-fast](https://github.com/npm/read-package-json-fast#readme) | 
| readable-stream | 2.3.7 | MIT | [readable-stream](https://github.com/nodejs/readable-stream#readme) | 
| readable-stream | 3.6.0 | MIT | [readable-stream](https://github.com/nodejs/readable-stream#readme) | 
| readline-sync | 1.4.10 | MIT | [readline-sync](https://github.com/anseki/readline-sync) | 
| repeat-string | 1.6.1 | MIT | [repeat-string](https://github.com/jonschlinkert/repeat-string) | 
| require-directory | 2.1.1 | MIT | [require-directory](https://github.com/troygoode/node-require-directory/) | 
| require-main-filename | 2.0.0 | ISC | [require-main-filename](https://github.com/yargs/require-main-filename#readme) | 
| retry | 0.10.1 | MIT | [retry](https://github.com/tim-kos/node-retry) | 
| retry | 0.12.0 | MIT | [retry](https://github.com/tim-kos/node-retry) | 
| reusify | 1.0.4 | MIT | [reusify](https://github.com/mcollina/reusify#readme) | 
| rfdc | 1.3.0 | MIT | [rfdc](https://github.com/davidmarkclements/rfdc#readme) | 
| rimraf | 2.7.1 | ISC | [rimraf](https://github.com/isaacs/rimraf#readme) | 
| rimraf | 3.0.2 | ISC | [rimraf](https://github.com/isaacs/rimraf#readme) | 
| run-parallel | 1.2.0 | MIT | [run-parallel](https://github.com/feross/run-parallel) | 
| safe-buffer | 5.1.2 | MIT | [safe-buffer](https://github.com/feross/safe-buffer) | 
| safer-buffer | 2.1.2 | MIT | [safer-buffer](https://github.com/ChALkeR/safer-buffer#readme) | 
| semver | 7.5.2 | ISC | [semver](https://github.com/npm/node-semver#readme) | 
| set-blocking | 2.0.0 | ISC | [set-blocking](https://github.com/yargs/set-blocking#readme) | 
| shebang-command | 2.0.0 | MIT | [shebang-command](https://github.com/kevva/shebang-command#readme) | 
| shebang-regex | 3.0.0 | MIT | [shebang-regex](https://github.com/sindresorhus/shebang-regex#readme) | 
| signal-exit | 3.0.7 | ISC | [signal-exit](https://github.com/tapjs/signal-exit) | 
| simple-concat | 1.0.1 | MIT | [simple-concat](https://github.com/feross/simple-concat) | 
| simple-get | 4.0.1 | MIT | [simple-get](https://github.com/feross/simple-get) | 
| smart-buffer | 4.2.0 | MIT | [smart-buffer](https://github.com/JoshGlazebrook/smart-buffer/) | 
| socks | 2.7.1 | MIT | [socks](https://github.com/JoshGlazebrook/socks/) | 
| socks-proxy-agent | 5.0.1 | MIT | [socks-proxy-agent](https://github.com/TooTallNate/node-socks-proxy-agent#readme) | 
| sprintf-js | 1.0.3 | BSD-3-Clause | [sprintf-js](https://github.com/alexei/sprintf.js#readme) | 
| ssh2 | 1.11.0 | MIT | [ssh2](https://github.com/mscdex/ssh2#readme) | 
| ssri | 8.0.1 | ISC | [ssri](https://github.com/npm/ssri#readme) | 
| stack-trace | 0.0.10 | MIT | [stack-trace](https://github.com/felixge/node-stack-trace) | 
| streamroller | 3.0.8 | MIT | [streamroller](https://github.com/nomiddlename/streamroller#readme) | 
| string-width | 1.0.2 | MIT | [string-width](https://github.com/sindresorhus/string-width#readme) | 
| string-width | 4.2.3 | MIT | [string-width](https://github.com/sindresorhus/string-width#readme) | 
| string_decoder | 1.1.1 | MIT | [string_decoder](https://github.com/nodejs/string_decoder) | 
| strip-ansi | 3.0.1 | MIT | [strip-ansi](https://github.com/chalk/strip-ansi) | 
| strip-ansi | 6.0.1 | MIT | [strip-ansi](https://github.com/chalk/strip-ansi#readme) | 
| strip-json-comments | 2.0.1 | MIT | [strip-json-comments](https://github.com/sindresorhus/strip-json-comments#readme) | 
| supports-color | 5.5.0 | MIT | [supports-color](https://github.com/chalk/supports-color#readme) | 
| supports-color | 7.2.0 | MIT | [supports-color](https://github.com/chalk/supports-color#readme) | 
| tar | 6.1.14 | ISC | [tar](https://github.com/isaacs/node-tar#readme) | 
| tar-fs | 2.1.1 | MIT | [tar-fs](https://github.com/mafintosh/tar-fs) | 
| tar-stream | 2.2.0 | MIT | [tar-stream](https://github.com/mafintosh/tar-stream) | 
| to-regex-range | 5.0.1 | MIT | [to-regex-range](https://github.com/micromatch/to-regex-range) | 
| tunnel-agent | 0.6.0 | Apache-2.0 | [tunnel-agent](https://github.com/mikeal/tunnel-agent#readme) | 
| tweetnacl | 0.14.5 | Unlicense | [tweetnacl](https://tweetnacl.js.org) | 
| uc.micro | 1.0.6 | MIT | [uc.micro](https://github.com/markdown-it/uc.micro#readme) | 
| underscore | 1.13.6 | MIT | [underscore](https://underscorejs.org) | 
| unique-filename | 1.1.1 | ISC | [unique-filename](https://github.com/iarna/unique-filename) | 
| unique-slug | 2.0.2 | ISC | [unique-slug](https://github.com/iarna/unique-slug#readme) | 
| universalify | 0.1.2 | MIT | [universalify](https://github.com/RyanZim/universalify#readme) | 
| universalify | 2.0.0 | MIT | [universalify](https://github.com/RyanZim/universalify#readme) | 
| util-deprecate | 1.0.2 | MIT | [util-deprecate](https://github.com/TooTallNate/util-deprecate) | 
| uuid | 8.3.2 | MIT | [uuid](https://github.com/uuidjs/uuid#readme) | 
| validate-npm-package-name | 3.0.0 | ISC | [validate-npm-package-name](https://github.com/npm/validate-npm-package-name) | 
| validate-npm-package-name | 4.0.0 | ISC | [validate-npm-package-name](https://github.com/npm/validate-npm-package-name) | 
| which | 2.0.2 | ISC | [which](https://github.com/isaacs/node-which#readme) | 
| which | 3.0.0 | ISC | [which](https://github.com/npm/node-which#readme) | 
| which-module | 2.0.0 | ISC | [which-module](https://github.com/nexdrew/which-module#readme) | 
| wide-align | 1.1.5 | ISC | [wide-align](https://github.com/iarna/wide-align#readme) | 
| wontache | 0.1.0 | BSD-3-Clause | [wontache](https://jgonggrijp.gitlab.io/wontache/) | 
| wrap-ansi | 6.2.0 | MIT | [wrap-ansi](https://github.com/chalk/wrap-ansi#readme) | 
| wrap-ansi | 7.0.0 | MIT | [wrap-ansi](https://github.com/chalk/wrap-ansi#readme) | 
| wrappy | 1.0.2 | ISC | [wrappy](https://github.com/npm/wrappy) | 
| y18n | 4.0.3 | ISC | [y18n](https://github.com/yargs/y18n) | 
| yallist | 3.1.1 | ISC | [yallist](https://github.com/isaacs/yallist#readme) | 
| yallist | 4.0.0 | ISC | [yallist](https://github.com/isaacs/yallist#readme) | 
| yamljs | 0.3.0 | MIT | [yamljs](https://github.com/jeremyfa/yaml.js#readme) | 
| yargs | 15.3.1 | MIT | [yargs](https://yargs.js.org/) | 
| yargs-parser | 18.1.3 | ISC | [yargs-parser](https://github.com/yargs/yargs-parser#readme) | 
| yocto-queue | 0.1.0 | MIT | [yocto-queue](https://github.com/sindresorhus/yocto-queue#readme) | 
| @colors/colors | 1.5.0 | MIT | [colors](https://github.com/DABH/colors.js) | 
| @gar/promisify | 1.1.3 | MIT | [promisify](https://github.com/wraithgar/gar-promisify#readme) | 
| @nodelib/fs.scandir | 2.1.5 | MIT | [fs.scandir](https://github.com/nodelib/nodelib/tree/master#readme) | 
| @nodelib/fs.stat | 2.0.5 | MIT | [fs.stat](https://github.com/nodelib/nodelib/tree/master#readme) | 
| @nodelib/fs.walk | 1.2.8 | MIT | [fs.walk](https://github.com/nodelib/nodelib/tree/master#readme) | 
| @npmcli/ci-detect | 1.4.0 | ISC | [ci-detect](https://github.com/npm/ci-detect#readme) | 
| @npmcli/fs | 1.1.0 | ISC | [fs](https://github.com/npm/fs#readme) | 
| @npmcli/git | 2.1.0 | ISC | [git](https://github.com/npm/git#readme) | 
| @npmcli/installed-package-contents | 1.0.7 | ISC | [installed-package-contents](https://github.com/npm/installed-package-contents#readme) | 
| @npmcli/move-file | 1.1.2 | MIT | [move-file](https://github.com/npm/move-file#readme) | 
| @npmcli/promise-spawn | 1.3.2 | ISC | [promise-spawn](https://github.com/npm/promise-spawn#readme) | 
| @tootallnate/once | 1.1.2 | MIT | [once](https://github.com/TooTallNate/once#readme) | 
| @types/yargs | 13.0.4 | MIT | [yargs](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/yargs) | 
| @types/yargs-parser | 20.2.1 | MIT | [yargs-parser](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/yargs-parser) | 
| @zowe/core-for-zowe-sdk | 7.16.5 | EPL-2.0 | [core-for-zowe-sdk](https://github.com/zowe/zowe-cli/tree/master/packages/core#readme) | 
| @zowe/imperative | 5.15.1 | EPL-2.0 | [imperative](https://github.com/zowe/imperative#readme) | 
| @zowe/perf-timing | 1.0.7 | EPL-2.0 | [perf-timing](https://github.com/zowe/perf-timing.git) | 
| @zowe/provisioning-for-zowe-sdk | 7.16.5 | EPL-2.0 | [provisioning-for-zowe-sdk](https://github.com/zowe/zowe-cli/tree/master/packages/provisioning#readme) | 
| @zowe/zos-console-for-zowe-sdk | 7.16.5 | EPL-2.0 | [zos-console-for-zowe-sdk](https://github.com/zowe/zowe-cli/tree/master/packages/zosconsole#readme) | 
| @zowe/zos-files-for-zowe-sdk | 7.16.6 | EPL-2.0 | [zos-files-for-zowe-sdk](https://github.com/zowe/zowe-cli/tree/master/packages/zosfiles#readme) | 
| @zowe/zos-jobs-for-zowe-sdk | 7.16.6 | EPL-2.0 | [zos-jobs-for-zowe-sdk](https://github.com/zowe/zowe-cli/tree/master/packages/zosjobs#readme) | 
| @zowe/zos-logs-for-zowe-sdk | 7.16.5 | EPL-2.0 | [zos-logs-for-zowe-sdk](https://github.com/zowe/zowe-cli/tree/master/packages/zoslogs#readme) | 
| @zowe/zos-tso-for-zowe-sdk | 7.16.5 | EPL-2.0 | [zos-tso-for-zowe-sdk](https://github.com/zowe/zowe-cli/tree/master/packages/zostso#readme) | 
| @zowe/zos-uss-for-zowe-sdk | 7.16.5 | EPL-2.0 | [zos-uss-for-zowe-sdk](https://github.com/zowe/zowe-cli/tree/master/packages/zosuss#readme) | 
| @zowe/zos-workflows-for-zowe-sdk | 7.16.6 | EPL-2.0 | [zos-workflows-for-zowe-sdk](https://github.com/zowe/zowe-cli/tree/master/packages/workflows#readme) | 
| @zowe/zosmf-for-zowe-sdk | 7.16.5 | EPL-2.0 | [zosmf-for-zowe-sdk](https://github.com/zowe/zowe-cli/tree/master/packages/zosmf#readme) | 

### IBM&reg CICS&reg Plug-in for Zowe CLI Dependency Attributions
| Third-party Software | Version | License | GitHub |
| -------------------- | --------| ------- | ------ |
| sax | 1.2.4 | ISC | [sax](https://github.com/isaacs/sax-js#readme) | 
| xml2js | 0.5.0 | MIT | [xml2js](https://github.com/Leonidas-from-XIV/node-xml2js) | 
| xmlbuilder | 11.0.1 | MIT | [xmlbuilder](http://github.com/oozcitak/xmlbuilder-js) | 

### IBM&reg Db2&reg Plug-in for Zowe CLI Dependency Attributions
| Third-party Software | Version | License | GitHub |
| -------------------- | --------| ------- | ------ |
| adm-zip | 0.5.10 | MIT | [adm-zip](https://github.com/cthackers/adm-zip) | 
| axios | 0.26.1 | MIT | [axios](https://axios-http.com) | 
| big-integer | 1.6.51 | Unlicense | [big-integer](https://github.com/peterolson/BigInteger.js#readme) | 
| bindings | 1.5.0 | MIT | [bindings](https://github.com/TooTallNate/node-bindings) | 
| bl | 1.2.3 | MIT | [bl](https://github.com/rvagg/bl) | 
| buffer-alloc | 1.2.0 | MIT | [buffer-alloc](https://github.com/LinusU/buffer-alloc#readme) | 
| buffer-alloc-unsafe | 1.1.0 | MIT | [buffer-alloc-unsafe](https://github.com/LinusU/buffer-alloc-unsafe#readme) | 
| buffer-fill | 1.0.0 | MIT | [buffer-fill](https://github.com/linusu/buffer-fill#readme) | 
| chownr | 1.1.4 | ISC | [chownr](https://github.com/isaacs/chownr#readme) | 
| core-util-is | 1.0.3 | MIT | [core-util-is](https://github.com/isaacs/core-util-is#readme) | 
| end-of-stream | 1.4.4 | MIT | [end-of-stream](https://github.com/mafintosh/end-of-stream) | 
| file-uri-to-path | 1.0.0 | MIT | [file-uri-to-path](https://github.com/TooTallNate/file-uri-to-path) | 
| follow-redirects | 1.15.1 | MIT | [follow-redirects](https://github.com/follow-redirects/follow-redirects) | 
| fs-constants | 1.0.0 | MIT | [fs-constants](https://github.com/mafintosh/fs-constants) | 
| fs-extra | 8.1.0 | MIT | [fs-extra](https://github.com/jprichardson/node-fs-extra) | 
| graceful-fs | 4.2.9 | ISC | [graceful-fs](https://github.com/isaacs/node-graceful-fs#readme) | 
| ibm_db | 3.2.0 | MIT | [ibm_db](https://github.com/ibmdb/node-ibm_db/) | 
| inherits | 2.0.4 | ISC | [inherits](https://github.com/isaacs/inherits#readme) | 
| isarray | 1.0.0 | MIT | [isarray](https://github.com/juliangruber/isarray) | 
| jsonfile | 4.0.0 | MIT | [jsonfile](https://github.com/jprichardson/node-jsonfile#readme) | 
| lodash | 4.17.21 | MIT | [lodash](https://lodash.com/) | 
| minimist | 1.2.6 | MIT | [minimist](https://github.com/substack/minimist) | 
| mkdirp | 0.5.5 | MIT | [mkdirp](https://github.com/substack/node-mkdirp#readme) | 
| nan | 2.17.0 | MIT | [nan](https://github.com/nodejs/nan#readme) | 
| once | 1.4.0 | ISC | [once](https://github.com/isaacs/once#readme) | 
| process-nextick-args | 2.0.1 | MIT | [process-nextick-args](https://github.com/calvinmetcalf/process-nextick-args) | 
| pump | 1.0.3 | MIT | [pump](https://github.com/mafintosh/pump#readme) | 
| q | 1.5.1 | MIT | [q](https://github.com/kriskowal/q) | 
| readable-stream | 2.3.7 | MIT | [readable-stream](https://github.com/nodejs/readable-stream#readme) | 
| safe-buffer | 5.1.2 | MIT | [safe-buffer](https://github.com/feross/safe-buffer) | 
| string_decoder | 1.1.1 | MIT | [string_decoder](https://github.com/nodejs/string_decoder) | 
| tar-fs | 1.16.3 | MIT | [tar-fs](https://github.com/mafintosh/tar-fs) | 
| tar-stream | 1.6.2 | MIT | [tar-stream](https://github.com/mafintosh/tar-stream) | 
| targz | 1.0.1 | MIT | [targz](https://github.com/miskun/targz#readme) | 
| to-buffer | 1.1.1 | MIT | [to-buffer](https://github.com/mafintosh/to-buffer) | 
| universalify | 0.1.2 | MIT | [universalify](https://github.com/RyanZim/universalify#readme) | 
| util-deprecate | 1.0.2 | MIT | [util-deprecate](https://github.com/TooTallNate/util-deprecate) | 
| wrappy | 1.0.2 | ISC | [wrappy](https://github.com/npm/wrappy) | 
| xtend | 4.0.2 | MIT | [xtend](https://github.com/Raynos/xtend) | 

### Performance Timing Utility Dependency Attributions
| Third-party Software | Version | License | GitHub |
| -------------------- | --------| ------- | ------ |
| find-up | 2.1.0 | MIT | [find-up](https://github.com/sindresorhus/find-up#readme) | 
| fs-extra | 8.1.0 | MIT | [fs-extra](https://github.com/jprichardson/node-fs-extra) | 
| graceful-fs | 4.2.3 | ISC | [graceful-fs](https://github.com/isaacs/node-graceful-fs#readme) | 
| jsonfile | 4.0.0 | MIT | [jsonfile](https://github.com/jprichardson/node-jsonfile#readme) | 
| locate-path | 2.0.0 | MIT | [locate-path](https://github.com/sindresorhus/locate-path#readme) | 
| p-limit | 1.3.0 | MIT | [p-limit](https://github.com/sindresorhus/p-limit#readme) | 
| p-locate | 2.0.0 | MIT | [p-locate](https://github.com/sindresorhus/p-locate#readme) | 
| p-try | 1.0.0 | MIT | [p-try](https://github.com/sindresorhus/p-try#readme) | 
| path-exists | 3.0.0 | MIT | [path-exists](https://github.com/sindresorhus/path-exists#readme) | 
| pkg-up | 2.0.0 | MIT | [pkg-up](https://github.com/sindresorhus/pkg-up#readme) | 
| universalify | 0.1.2 | MIT | [universalify](https://github.com/RyanZim/universalify#readme) | 

### z/OS&reg FTP Plug-in for Zowe CLI Dependency Attributions
| Third-party Software | Version | License | GitHub |
| -------------------- | --------| ------- | ------ |
| core-util-is | 1.0.3 | MIT | [core-util-is](https://github.com/isaacs/core-util-is#readme) | 
| debug | 3.1.0 | MIT | [debug](https://github.com/visionmedia/debug#readme) | 
| ftp4 | 0.3.13 | MIT | [ftp4](https://github.com/std4lqi/node-ftp#readme) | 
| inherits | 2.0.4 | ISC | [inherits](https://github.com/isaacs/inherits#readme) | 
| isarray | 0.0.1 | MIT | [isarray](https://github.com/juliangruber/isarray) | 
| ms | 2.0.0 | MIT | [ms](https://github.com/zeit/ms#readme) | 
| q | 1.4.1 | MIT | [q](https://github.com/kriskowal/q) | 
| readable-stream | 1.1.14 | MIT | [readable-stream](https://github.com/nodejs/readable-stream) | 
| string_decoder | 0.10.31 | MIT | [string_decoder](https://github.com/rvagg/string_decoder) | 
| xregexp | 2.0.0 | MIT | [xregexp](http://xregexp.com/) | 
| zos-node-accessor | 1.0.14 | EPL-1.0 | [zos-node-accessor](https://github.com/IBM/zos-node-accessor#readme) | 

