# Zowe CLI Third Party Library Usage

* [Imperative CLI Framework for Zowe](#imperative-cli-framework-for-zowe-dependency-attributions)
* [Zowe CLI](#zowe-cli-dependency-attributions)
* [IBM&reg CICS&reg Plug-in for Zowe CLI](#ibm&reg-cics&reg-plug-in-for-zowe-cli-dependency-attributions)
* [IBM&reg Db2&reg Plug-in for Zowe CLI](#ibm&reg-db2&reg-plug-in-for-zowe-cli-dependency-attributions)
* [Performance Timing Utility](#performance-timing-utility-dependency-attributions)
* [IBM&reg MQ Plug-in for Zowe CLI](#ibm&reg-mq-plug-in-for-zowe-cli-dependency-attributions)
* [Secure Credential Store Plug-in for Zowe CLI](#secure-credential-store-plug-in-for-zowe-cli-dependency-attributions)
* [z/OS&reg FTP Plug-in for Zowe CLI](#z/os&reg-ftp-plug-in-for-zowe-cli-dependency-attributions)
* [IBM&reg IMS&reg Plug-in for Zowe CLI](#ibm&reg-ims&reg-plug-in-for-zowe-cli-dependency-attributions)

### Imperative CLI Framework for Zowe Dependency Attributions
| Third-party Software | Version | License | GitHub |
| -------------------- | --------| ------- | ------ |
| agent-base | 6.0.2 | MIT | [agent-base](https://github.com/TooTallNate/node-agent-base#readme) | 
| agentkeepalive | 4.1.4 | MIT | [agentkeepalive](https://github.com/node-modules/agentkeepalive#readme) | 
| aggregate-error | 3.1.0 | MIT | [aggregate-error](https://github.com/sindresorhus/aggregate-error#readme) | 
| ansi-regex | 5.0.1 | MIT | [ansi-regex](https://github.com/chalk/ansi-regex#readme) | 
| ansi-styles | 3.2.1 | MIT | [ansi-styles](https://github.com/chalk/ansi-styles#readme) | 
| ansi-styles | 4.3.0 | MIT | [ansi-styles](https://github.com/chalk/ansi-styles#readme) | 
| argparse | 1.0.10 | MIT | [argparse](https://github.com/nodeca/argparse#readme) | 
| argparse | 2.0.1 | Python-2.0 | [argparse](https://github.com/nodeca/argparse#readme) | 
| balanced-match | 1.0.2 | MIT | [balanced-match](https://github.com/juliangruber/balanced-match) | 
| balloon-css | 1.2.0 | MIT | [balloon-css](http://kazzkiq.github.io/balloon.css/) | 
| bootstrap | 4.6.0 | MIT | [bootstrap](https://getbootstrap.com/) | 
| brace-expansion | 1.1.11 | MIT | [brace-expansion](https://github.com/juliangruber/brace-expansion) | 
| builtins | 1.0.3 | MIT | [builtins](https://github.com/juliangruber/builtins#readme) | 
| cacache | 15.3.0 | ISC | [cacache](https://github.com/npm/cacache#readme) | 
| camelcase | 5.3.1 | MIT | [camelcase](https://github.com/sindresorhus/camelcase#readme) | 
| chalk | 2.4.2 | MIT | [chalk](https://github.com/chalk/chalk#readme) | 
| chownr | 1.1.4 | ISC | [chownr](https://github.com/isaacs/chownr#readme) | 
| chownr | 2.0.0 | ISC | [chownr](https://github.com/isaacs/chownr#readme) | 
| clean-stack | 2.2.0 | MIT | [clean-stack](https://github.com/sindresorhus/clean-stack#readme) | 
| cli-table3 | 0.6.2 | MIT | [cli-table3](https://github.com/cli-table/cli-table3) | 
| clipboard | 2.0.8 | MIT | [clipboard](https://clipboardjs.com) | 
| cliui | 6.0.0 | ISC | [cliui](https://github.com/yargs/cliui#readme) | 
| color-convert | 1.9.3 | MIT | [color-convert](https://github.com/Qix-/color-convert#readme) | 
| color-convert | 2.0.1 | MIT | [color-convert](https://github.com/Qix-/color-convert#readme) | 
| color-name | 1.1.3 | MIT | [color-name](https://github.com/dfcreative/color-name) | 
| color-name | 1.1.4 | MIT | [color-name](https://github.com/colorjs/color-name) | 
| colors | 1.4.0 | MIT | [colors](https://github.com/Marak/colors.js) | 
| compute-scroll-into-view | 1.0.17 | MIT | [compute-scroll-into-view](https://scroll-into-view-if-needed.netlify.com) | 
| concat-map | 0.0.1 | MIT | [concat-map](https://github.com/substack/node-concat-map) | 
| cross-spawn | 7.0.3 | MIT | [cross-spawn](https://github.com/moxystudio/node-cross-spawn) | 
| dataobject-parser | 1.2.1 | MIT | [dataobject-parser](https://github.com/Gigzolo/dataobject-parser) | 
| date-format | 4.0.3 | MIT | [date-format](https://github.com/nomiddlename/date-format#readme) | 
| debug | 4.3.3 | MIT | [debug](https://github.com/debug-js/debug#readme) | 
| decamelize | 1.2.0 | MIT | [decamelize](https://github.com/sindresorhus/decamelize#readme) | 
| deepmerge | 3.0.0 | MIT | [deepmerge](https://github.com/KyleAMathews/deepmerge) | 
| delegate | 3.2.0 | MIT | [delegate](https://github.com/zenorocha/delegate#readme) | 
| depd | 1.1.2 | MIT | [depd](https://github.com/dougwilson/nodejs-depd#readme) | 
| emoji-regex | 8.0.0 | MIT | [emoji-regex](https://mths.be/emoji-regex) | 
| encoding | 0.1.13 | MIT | [encoding](https://github.com/andris9/encoding#readme) | 
| entities | 2.1.0 | BSD-2-Clause | [entities](https://github.com/fb55/entities#readme) | 
| err-code | 1.1.2 | MIT | [err-code](https://github.com/IndigoUnited/js-err-code#readme) | 
| err-code | 2.0.3 | MIT | [err-code](https://github.com/IndigoUnited/js-err-code#readme) | 
| escape-string-regexp | 1.0.5 | MIT | [escape-string-regexp](https://github.com/sindresorhus/escape-string-regexp) | 
| esprima | 4.0.1 | BSD-2-Clause | [esprima](http://esprima.org) | 
| fastest-levenshtein | 1.0.12 | MIT | [fastest-levenshtein](https://github.com/ka-weihe/fastest-levenshtein#README) | 
| find-up | 2.1.0 | MIT | [find-up](https://github.com/sindresorhus/find-up#readme) | 
| find-up | 4.1.0 | MIT | [find-up](https://github.com/sindresorhus/find-up#readme) | 
| flatted | 3.2.4 | ISC | [flatted](https://github.com/WebReflection/flatted#readme) | 
| fs-extra | 8.1.0 | MIT | [fs-extra](https://github.com/jprichardson/node-fs-extra) | 
| fs-extra | 10.0.0 | MIT | [fs-extra](https://github.com/jprichardson/node-fs-extra) | 
| fs-minipass | 2.1.0 | ISC | [fs-minipass](https://github.com/npm/fs-minipass#readme) | 
| fs.realpath | 1.0.0 | ISC | [fs.realpath](https://github.com/isaacs/fs.realpath#readme) | 
| get-caller-file | 2.0.5 | ISC | [get-caller-file](https://github.com/stefanpenner/get-caller-file#readme) | 
| github-markdown-css | 3.0.1 | MIT | [github-markdown-css](https://github.com/sindresorhus/github-markdown-css#readme) | 
| glob | 7.1.6 | ISC | [glob](https://github.com/isaacs/node-glob#readme) | 
| good-listener | 1.2.2 | MIT | [good-listener](https://github.com/zenorocha/good-listener#readme) | 
| graceful-fs | 4.2.8 | ISC | [graceful-fs](https://github.com/isaacs/node-graceful-fs#readme) | 
| has-flag | 3.0.0 | MIT | [has-flag](https://github.com/sindresorhus/has-flag#readme) | 
| hosted-git-info | 3.0.8 | ISC | [hosted-git-info](https://github.com/npm/hosted-git-info) | 
| hosted-git-info | 4.0.2 | ISC | [hosted-git-info](https://github.com/npm/hosted-git-info) | 
| http-cache-semantics | 4.1.1 | BSD-2-Clause | [http-cache-semantics](https://github.com/kornelski/http-cache-semantics#readme) | 
| http-proxy-agent | 4.0.1 | MIT | [http-proxy-agent](https://github.com/TooTallNate/node-http-proxy-agent#readme) | 
| https-proxy-agent | 5.0.0 | MIT | [https-proxy-agent](https://github.com/TooTallNate/node-https-proxy-agent#readme) | 
| humanize-ms | 1.2.1 | MIT | [humanize-ms](https://github.com/node-modules/humanize-ms#readme) | 
| iconv-lite | 0.6.3 | MIT | [iconv-lite](https://github.com/ashtuchkin/iconv-lite) | 
| ignore-walk | 3.0.4 | ISC | [ignore-walk](https://github.com/isaacs/ignore-walk#readme) | 
| imurmurhash | 0.1.4 | MIT | [imurmurhash](https://github.com/jensyt/imurmurhash-js) | 
| indent-string | 4.0.0 | MIT | [indent-string](https://github.com/sindresorhus/indent-string#readme) | 
| infer-owner | 1.0.4 | ISC | [infer-owner](https://github.com/npm/infer-owner#readme) | 
| inflight | 1.0.6 | ISC | [inflight](https://github.com/isaacs/inflight) | 
| inherits | 2.0.4 | ISC | [inherits](https://github.com/isaacs/inherits#readme) | 
| ip | 1.1.5 | MIT | [ip](https://github.com/indutny/node-ip) | 
| is-fullwidth-code-point | 3.0.0 | MIT | [is-fullwidth-code-point](https://github.com/sindresorhus/is-fullwidth-code-point#readme) | 
| is-lambda | 1.0.1 | MIT | [is-lambda](https://github.com/watson/is-lambda) | 
| isexe | 2.0.0 | ISC | [isexe](https://github.com/isaacs/isexe#readme) | 
| jquery | 3.6.0 | MIT | [jquery](https://jquery.com) | 
| js-yaml | 3.14.1 | MIT | [js-yaml](https://github.com/nodeca/js-yaml) | 
| json-parse-even-better-errors | 2.3.1 | MIT | [json-parse-even-better-errors](https://github.com/npm/json-parse-even-better-errors#readme) | 
| jsonfile | 4.0.0 | MIT | [jsonfile](https://github.com/jprichardson/node-jsonfile#readme) | 
| jsonfile | 6.1.0 | MIT | [jsonfile](https://github.com/jprichardson/node-jsonfile#readme) | 
| jsonparse | 1.3.1 | MIT | [jsonparse](https://github.com/creationix/jsonparse#readme) | 
| jsonschema | 1.1.1 | MIT | [jsonschema](https://github.com/tdegrunt/jsonschema#readme) | 
| jstree | 3.3.12 | MIT | [jstree](http://jstree.com) | 
| linkify-it | 3.0.2 | MIT | [linkify-it](https://github.com/markdown-it/linkify-it#readme) | 
| locate-path | 2.0.0 | MIT | [locate-path](https://github.com/sindresorhus/locate-path#readme) | 
| locate-path | 5.0.0 | MIT | [locate-path](https://github.com/sindresorhus/locate-path#readme) | 
| lodash | 4.17.21 | MIT | [lodash](https://lodash.com/) | 
| lodash-deep | 2.0.0 | MIT | [lodash-deep](https://github.com/marklagendijk/lodash-deep) | 
| log4js | 6.4.0 | Apache-2.0 | [log4js](https://log4js-node.github.io/log4js-node/) | 
| lru-cache | 5.1.1 | ISC | [lru-cache](https://github.com/isaacs/node-lru-cache#readme) | 
| lru-cache | 6.0.0 | ISC | [lru-cache](https://github.com/isaacs/node-lru-cache#readme) | 
| make-fetch-happen | 8.0.14 | ISC | [make-fetch-happen](https://github.com/npm/make-fetch-happen#readme) | 
| markdown-it | 12.3.2 | MIT | [markdown-it](https://github.com/markdown-it/markdown-it#readme) | 
| mdurl | 1.0.1 | MIT | [mdurl](https://github.com/markdown-it/mdurl#readme) | 
| minimatch | 3.0.8 | ISC | [minimatch](https://github.com/isaacs/minimatch#readme) | 
| minimist | 1.2.6 | MIT | [minimist](https://github.com/substack/minimist) | 
| minipass | 3.1.5 | ISC | [minipass](https://github.com/isaacs/minipass#readme) | 
| minipass-collect | 1.0.2 | ISC | [minipass-collect](https://github.com/isaacs/minipass-collect#readme) | 
| minipass-fetch | 1.4.1 | MIT | [minipass-fetch](https://github.com/npm/minipass-fetch#readme) | 
| minipass-flush | 1.0.5 | ISC | [minipass-flush](https://github.com/isaacs/minipass-flush#readme) | 
| minipass-json-stream | 1.0.1 | MIT | [minipass-json-stream](https://github.com/npm/minipass-json-stream#readme) | 
| minipass-pipeline | 1.2.4 | ISC | [minipass-pipeline]() | 
| minipass-sized | 1.0.3 | ISC | [minipass-sized](https://github.com/isaacs/minipass-sized#readme) | 
| minizlib | 2.1.2 | MIT | [minizlib](https://github.com/isaacs/minizlib#readme) | 
| mkdirp | 1.0.4 | MIT | [mkdirp](https://github.com/isaacs/node-mkdirp#readme) | 
| ms | 2.1.2 | MIT | [ms](https://github.com/zeit/ms#readme) | 
| mustache | 2.3.0 | MIT | [mustache](https://github.com/janl/mustache.js) | 
| npm-bundled | 1.1.2 | ISC | [npm-bundled](https://github.com/npm/npm-bundled#readme) | 
| npm-install-checks | 4.0.0 | BSD-2-Clause | [npm-install-checks](https://github.com/npm/npm-install-checks#readme) | 
| npm-normalize-package-bin | 1.0.1 | ISC | [npm-normalize-package-bin](https://github.com/npm/npm-normalize-package-bin#readme) | 
| npm-package-arg | 8.1.1 | ISC | [npm-package-arg](https://github.com/npm/npm-package-arg) | 
| npm-package-arg | 8.1.5 | ISC | [npm-package-arg](https://github.com/npm/npm-package-arg) | 
| npm-packlist | 2.2.2 | ISC | [npm-packlist](https://github.com/npm/npm-packlist#readme) | 
| npm-pick-manifest | 6.1.1 | ISC | [npm-pick-manifest](https://github.com/npm/npm-pick-manifest#readme) | 
| npm-registry-fetch | 8.1.5 | ISC | [npm-registry-fetch](https://github.com/npm/registry-fetch#readme) | 
| once | 1.4.0 | ISC | [once](https://github.com/isaacs/once#readme) | 
| opener | 1.5.2 | (WTFPL OR MIT) | [opener](https://github.com/domenic/opener#readme) | 
| p-limit | 1.3.0 | MIT | [p-limit](https://github.com/sindresorhus/p-limit#readme) | 
| p-limit | 2.3.0 | MIT | [p-limit](https://github.com/sindresorhus/p-limit#readme) | 
| p-locate | 2.0.0 | MIT | [p-locate](https://github.com/sindresorhus/p-locate#readme) | 
| p-locate | 4.1.0 | MIT | [p-locate](https://github.com/sindresorhus/p-locate#readme) | 
| p-map | 4.0.0 | MIT | [p-map](https://github.com/sindresorhus/p-map#readme) | 
| p-try | 1.0.0 | MIT | [p-try](https://github.com/sindresorhus/p-try#readme) | 
| p-try | 2.2.0 | MIT | [p-try](https://github.com/sindresorhus/p-try#readme) | 
| pacote | 11.1.4 | ISC | [pacote](https://github.com/npm/pacote#readme) | 
| path-exists | 3.0.0 | MIT | [path-exists](https://github.com/sindresorhus/path-exists#readme) | 
| path-exists | 4.0.0 | MIT | [path-exists](https://github.com/sindresorhus/path-exists#readme) | 
| path-is-absolute | 1.0.1 | MIT | [path-is-absolute](https://github.com/sindresorhus/path-is-absolute#readme) | 
| path-key | 3.1.1 | MIT | [path-key](https://github.com/sindresorhus/path-key#readme) | 
| pkg-up | 2.0.0 | MIT | [pkg-up](https://github.com/sindresorhus/pkg-up#readme) | 
| prettyjson | 1.2.2 | MIT | [prettyjson](http://rafeca.com/prettyjson) | 
| progress | 2.0.3 | MIT | [progress](https://github.com/visionmedia/node-progress#readme) | 
| promise-inflight | 1.0.1 | ISC | [promise-inflight](https://github.com/iarna/promise-inflight#readme) | 
| promise-retry | 1.1.1 | MIT | [promise-retry](https://github.com/IndigoUnited/node-promise-retry#readme) | 
| promise-retry | 2.0.1 | MIT | [promise-retry](https://github.com/IndigoUnited/node-promise-retry#readme) | 
| read-package-json-fast | 1.2.2 | ISC | [read-package-json-fast](https://github.com/npm/read-package-json-fast#readme) | 
| readline-sync | 1.4.10 | MIT | [readline-sync](https://github.com/anseki/readline-sync) | 
| require-directory | 2.1.1 | MIT | [require-directory](https://github.com/troygoode/node-require-directory/) | 
| require-main-filename | 2.0.0 | ISC | [require-main-filename](https://github.com/yargs/require-main-filename#readme) | 
| retry | 0.10.1 | MIT | [retry](https://github.com/tim-kos/node-retry) | 
| retry | 0.12.0 | MIT | [retry](https://github.com/tim-kos/node-retry) | 
| rfdc | 1.3.0 | MIT | [rfdc](https://github.com/davidmarkclements/rfdc#readme) | 
| rimraf | 2.7.1 | ISC | [rimraf](https://github.com/isaacs/rimraf#readme) | 
| rimraf | 3.0.2 | ISC | [rimraf](https://github.com/isaacs/rimraf#readme) | 
| safer-buffer | 2.1.2 | MIT | [safer-buffer](https://github.com/ChALkeR/safer-buffer#readme) | 
| scroll-into-view-if-needed | 2.2.28 | MIT | [scroll-into-view-if-needed](https://scroll-into-view-if-needed.netlify.com) | 
| select | 1.1.2 | MIT | [select](https://github.com/zenorocha/select#readme) | 
| semver | 5.7.2 | ISC | [semver](https://github.com/npm/node-semver#readme) | 
| semver | 7.5.4 | ISC | [semver](https://github.com/npm/node-semver#readme) | 
| set-blocking | 2.0.0 | ISC | [set-blocking](https://github.com/yargs/set-blocking#readme) | 
| shebang-command | 2.0.0 | MIT | [shebang-command](https://github.com/kevva/shebang-command#readme) | 
| shebang-regex | 3.0.0 | MIT | [shebang-regex](https://github.com/sindresorhus/shebang-regex#readme) | 
| smart-buffer | 4.2.0 | MIT | [smart-buffer](https://github.com/JoshGlazebrook/smart-buffer/) | 
| socks | 2.6.1 | MIT | [socks](https://github.com/JoshGlazebrook/socks/) | 
| socks-proxy-agent | 5.0.1 | MIT | [socks-proxy-agent](https://github.com/TooTallNate/node-socks-proxy-agent#readme) | 
| split.js | 1.6.4 | MIT | [split.js](https://split.js.org/) | 
| sprintf-js | 1.0.3 | BSD-3-Clause | [sprintf-js](https://github.com/alexei/sprintf.js#readme) | 
| ssri | 8.0.1 | ISC | [ssri](https://github.com/npm/ssri#readme) | 
| stack-trace | 0.0.10 | MIT | [stack-trace](https://github.com/felixge/node-stack-trace) | 
| streamroller | 3.0.2 | MIT | [streamroller](https://github.com/nomiddlename/streamroller#readme) | 
| string-width | 4.2.3 | MIT | [string-width](https://github.com/sindresorhus/string-width#readme) | 
| strip-ansi | 6.0.1 | MIT | [strip-ansi](https://github.com/chalk/strip-ansi#readme) | 
| supports-color | 5.5.0 | MIT | [supports-color](https://github.com/chalk/supports-color#readme) | 
| tar | 6.1.11 | ISC | [tar](https://github.com/npm/node-tar#readme) | 
| tiny-emitter | 2.1.0 | MIT | [tiny-emitter](https://github.com/scottcorgan/tiny-emitter#readme) | 
| uc.micro | 1.0.6 | MIT | [uc.micro](https://github.com/markdown-it/uc.micro#readme) | 
| unique-filename | 1.1.1 | ISC | [unique-filename](https://github.com/iarna/unique-filename) | 
| unique-slug | 2.0.2 | ISC | [unique-slug](https://github.com/iarna/unique-slug#readme) | 
| universalify | 0.1.2 | MIT | [universalify](https://github.com/RyanZim/universalify#readme) | 
| universalify | 2.0.0 | MIT | [universalify](https://github.com/RyanZim/universalify#readme) | 
| url-search-params-polyfill | 8.1.1 | MIT | [url-search-params-polyfill](https://github.com/jerrybendy/url-search-params-polyfill) | 
| validate-npm-package-name | 3.0.0 | ISC | [validate-npm-package-name](https://github.com/npm/validate-npm-package-name) | 
| which | 2.0.2 | ISC | [which](https://github.com/isaacs/node-which#readme) | 
| which | 3.0.0 | ISC | [which](https://github.com/npm/node-which#readme) | 
| which-module | 2.0.0 | ISC | [which-module](https://github.com/nexdrew/which-module#readme) | 
| wrap-ansi | 6.2.0 | MIT | [wrap-ansi](https://github.com/chalk/wrap-ansi#readme) | 
| wrap-ansi | 7.0.0 | MIT | [wrap-ansi](https://github.com/chalk/wrap-ansi#readme) | 
| wrappy | 1.0.2 | ISC | [wrappy](https://github.com/npm/wrappy) | 
| y18n | 4.0.3 | ISC | [y18n](https://github.com/yargs/y18n) | 
| yallist | 3.1.1 | ISC | [yallist](https://github.com/isaacs/yallist#readme) | 
| yallist | 4.0.0 | ISC | [yallist](https://github.com/isaacs/yallist#readme) | 
| yamljs | 0.3.0 | MIT | [yamljs](https://github.com/jeremyfa/yaml.js#readme) | 
| yargs | 15.3.1 | MIT | [yargs](https://yargs.js.org/) | 
| yargs-parser | 18.1.3 | ISC | [yargs-parser](https://github.com/yargs/yargs-parser#readme) | 
| @colors/colors | 1.5.0 | MIT | [colors](https://github.com/DABH/colors.js) | 
| @gar/promisify | 1.1.2 | MIT | [promisify](https://github.com/wraithgar/gar-promisify#readme) | 
| @npmcli/ci-detect | 1.3.0 | ISC | [ci-detect](https://github.com/npm/ci-detect#readme) | 
| @npmcli/fs | 1.0.0 | ISC | [fs](https://github.com/npm/fs#readme) | 
| @npmcli/git | 2.1.0 | ISC | [git](https://github.com/npm/git#readme) | 
| @npmcli/installed-package-contents | 1.0.7 | ISC | [installed-package-contents](https://github.com/npm/installed-package-contents#readme) | 
| @npmcli/move-file | 1.1.2 | MIT | [move-file](https://github.com/npm/move-file#readme) | 
| @npmcli/promise-spawn | 1.3.2 | ISC | [promise-spawn](https://github.com/npm/promise-spawn#readme) | 
| @tootallnate/once | 1.1.2 | MIT | [once](https://github.com/TooTallNate/once#readme) | 
| @types/yargs | 13.0.4 | MIT | [yargs](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/yargs) | 
| @types/yargs-parser | 20.2.1 | MIT | [yargs-parser](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/yargs-parser) | 
| @zowe/perf-timing | 1.0.7 | EPL-2.0 | [perf-timing](https://github.com/zowe/perf-timing.git) | 

### Zowe CLI Dependency Attributions
| Third-party Software | Version | License | GitHub |
| -------------------- | --------| ------- | ------ |
| agent-base | 6.0.2 | MIT | [agent-base](https://github.com/TooTallNate/node-agent-base#readme) | 
| agentkeepalive | 4.5.0 | MIT | [agentkeepalive](https://github.com/node-modules/agentkeepalive#readme) | 
| aggregate-error | 3.1.0 | MIT | [aggregate-error](https://github.com/sindresorhus/aggregate-error#readme) | 
| ansi-regex | 5.0.1 | MIT | [ansi-regex](https://github.com/chalk/ansi-regex#readme) | 
| ansi-styles | 3.2.1 | MIT | [ansi-styles](https://github.com/chalk/ansi-styles#readme) | 
| ansi-styles | 4.3.0 | MIT | [ansi-styles](https://github.com/chalk/ansi-styles#readme) | 
| argparse | 1.0.10 | MIT | [argparse](https://github.com/nodeca/argparse#readme) | 
| argparse | 2.0.1 | Python-2.0 | [argparse](https://github.com/nodeca/argparse#readme) | 
| asn1 | 0.2.6 | MIT | [asn1](https://github.com/joyent/node-asn1#readme) | 
| balanced-match | 1.0.2 | MIT | [balanced-match](https://github.com/juliangruber/balanced-match) | 
| balloon-css | 1.2.0 | MIT | [balloon-css](http://kazzkiq.github.io/balloon.css/) | 
| bcrypt-pbkdf | 1.0.2 | BSD-3-Clause | [bcrypt-pbkdf](https://github.com/joyent/node-bcrypt-pbkdf#readme) | 
| bootstrap | 5.3.1 | MIT | [bootstrap](https://getbootstrap.com/) | 
| brace-expansion | 1.1.11 | MIT | [brace-expansion](https://github.com/juliangruber/brace-expansion) | 
| buildcheck | 0.0.6 | MIT | [buildcheck](https://github.com/mscdex/buildcheck#readme) | 
| builtins | 1.0.3 | MIT | [builtins](https://github.com/juliangruber/builtins#readme) | 
| cacache | 15.3.0 | ISC | [cacache](https://github.com/npm/cacache#readme) | 
| camelcase | 5.3.1 | MIT | [camelcase](https://github.com/sindresorhus/camelcase#readme) | 
| chalk | 2.4.2 | MIT | [chalk](https://github.com/chalk/chalk#readme) | 
| chownr | 1.1.4 | ISC | [chownr](https://github.com/isaacs/chownr#readme) | 
| chownr | 2.0.0 | ISC | [chownr](https://github.com/isaacs/chownr#readme) | 
| clean-stack | 2.2.0 | MIT | [clean-stack](https://github.com/sindresorhus/clean-stack#readme) | 
| cli-table3 | 0.6.2 | MIT | [cli-table3](https://github.com/cli-table/cli-table3) | 
| clipboard | 2.0.11 | MIT | [clipboard](https://clipboardjs.com) | 
| cliui | 6.0.0 | ISC | [cliui](https://github.com/yargs/cliui#readme) | 
| color-convert | 1.9.3 | MIT | [color-convert](https://github.com/Qix-/color-convert#readme) | 
| color-convert | 2.0.1 | MIT | [color-convert](https://github.com/Qix-/color-convert#readme) | 
| color-name | 1.1.3 | MIT | [color-name](https://github.com/dfcreative/color-name) | 
| color-name | 1.1.4 | MIT | [color-name](https://github.com/colorjs/color-name) | 
| colors | 1.4.0 | MIT | [colors](https://github.com/Marak/colors.js) | 
| compute-scroll-into-view | 1.0.20 | MIT | [compute-scroll-into-view](https://scroll-into-view.dev) | 
| concat-map | 0.0.1 | MIT | [concat-map](https://github.com/substack/node-concat-map) | 
| cpu-features | 0.0.9 | MIT | [cpu-features](https://github.com/mscdex/cpu-features#readme) | 
| cross-spawn | 7.0.3 | MIT | [cross-spawn](https://github.com/moxystudio/node-cross-spawn) | 
| dataobject-parser | 1.2.1 | MIT | [dataobject-parser](https://github.com/Gigzolo/dataobject-parser) | 
| date-format | 4.0.14 | MIT | [date-format](https://github.com/nomiddlename/date-format#readme) | 
| debug | 4.3.4 | MIT | [debug](https://github.com/debug-js/debug#readme) | 
| decamelize | 1.2.0 | MIT | [decamelize](https://github.com/sindresorhus/decamelize#readme) | 
| deepmerge | 3.0.0 | MIT | [deepmerge](https://github.com/KyleAMathews/deepmerge) | 
| delegate | 3.2.0 | MIT | [delegate](https://github.com/zenorocha/delegate#readme) | 
| emoji-regex | 8.0.0 | MIT | [emoji-regex](https://mths.be/emoji-regex) | 
| encoding | 0.1.13 | MIT | [encoding](https://github.com/andris9/encoding#readme) | 
| entities | 4.5.0 | BSD-2-Clause | [entities](https://github.com/fb55/entities#readme) | 
| err-code | 1.1.2 | MIT | [err-code](https://github.com/IndigoUnited/js-err-code#readme) | 
| err-code | 2.0.3 | MIT | [err-code](https://github.com/IndigoUnited/js-err-code#readme) | 
| escape-string-regexp | 1.0.5 | MIT | [escape-string-regexp](https://github.com/sindresorhus/escape-string-regexp) | 
| esprima | 4.0.1 | BSD-2-Clause | [esprima](http://esprima.org) | 
| fastest-levenshtein | 1.0.12 | MIT | [fastest-levenshtein](https://github.com/ka-weihe/fastest-levenshtein#README) | 
| find-up | 4.1.0 | MIT | [find-up](https://github.com/sindresorhus/find-up#readme) | 
| flatted | 3.2.7 | ISC | [flatted](https://github.com/WebReflection/flatted#readme) | 
| fs-extra | 8.1.0 | MIT | [fs-extra](https://github.com/jprichardson/node-fs-extra) | 
| fs-minipass | 2.1.0 | ISC | [fs-minipass](https://github.com/npm/fs-minipass#readme) | 
| fs.realpath | 1.0.0 | ISC | [fs.realpath](https://github.com/isaacs/fs.realpath#readme) | 
| get-caller-file | 2.0.5 | ISC | [get-caller-file](https://github.com/stefanpenner/get-caller-file#readme) | 
| get-stdin | 7.0.0 | MIT | [get-stdin](https://github.com/sindresorhus/get-stdin#readme) | 
| github-markdown-css | 3.0.1 | MIT | [github-markdown-css](https://github.com/sindresorhus/github-markdown-css#readme) | 
| glob | 7.1.6 | ISC | [glob](https://github.com/isaacs/node-glob#readme) | 
| glob | 7.2.3 | ISC | [glob](https://github.com/isaacs/node-glob#readme) | 
| good-listener | 1.2.2 | MIT | [good-listener](https://github.com/zenorocha/good-listener#readme) | 
| graceful-fs | 4.2.11 | ISC | [graceful-fs](https://github.com/isaacs/node-graceful-fs#readme) | 
| has-flag | 3.0.0 | MIT | [has-flag](https://github.com/sindresorhus/has-flag#readme) | 
| hosted-git-info | 3.0.8 | ISC | [hosted-git-info](https://github.com/npm/hosted-git-info) | 
| hosted-git-info | 4.1.0 | ISC | [hosted-git-info](https://github.com/npm/hosted-git-info) | 
| http-cache-semantics | 4.1.1 | BSD-2-Clause | [http-cache-semantics](https://github.com/kornelski/http-cache-semantics#readme) | 
| http-proxy-agent | 4.0.1 | MIT | [http-proxy-agent](https://github.com/TooTallNate/node-http-proxy-agent#readme) | 
| https-proxy-agent | 5.0.1 | MIT | [https-proxy-agent](https://github.com/TooTallNate/node-https-proxy-agent#readme) | 
| humanize-ms | 1.2.1 | MIT | [humanize-ms](https://github.com/node-modules/humanize-ms#readme) | 
| iconv-lite | 0.6.3 | MIT | [iconv-lite](https://github.com/ashtuchkin/iconv-lite) | 
| ignore-walk | 3.0.4 | ISC | [ignore-walk](https://github.com/isaacs/ignore-walk#readme) | 
| imurmurhash | 0.1.4 | MIT | [imurmurhash](https://github.com/jensyt/imurmurhash-js) | 
| indent-string | 4.0.0 | MIT | [indent-string](https://github.com/sindresorhus/indent-string#readme) | 
| infer-owner | 1.0.4 | ISC | [infer-owner](https://github.com/npm/infer-owner#readme) | 
| inflight | 1.0.6 | ISC | [inflight](https://github.com/isaacs/inflight) | 
| inherits | 2.0.4 | ISC | [inherits](https://github.com/isaacs/inherits#readme) | 
| ip-address | 9.0.5 | MIT | [ip-address](https://github.com/beaugunderson/ip-address#readme) | 
| is-fullwidth-code-point | 3.0.0 | MIT | [is-fullwidth-code-point](https://github.com/sindresorhus/is-fullwidth-code-point#readme) | 
| is-lambda | 1.0.1 | MIT | [is-lambda](https://github.com/watson/is-lambda) | 
| isexe | 2.0.0 | ISC | [isexe](https://github.com/isaacs/isexe#readme) | 
| jquery | 3.7.1 | MIT | [jquery](https://jquery.com) | 
| js-yaml | 3.14.1 | MIT | [js-yaml](https://github.com/nodeca/js-yaml) | 
| jsbn | 1.1.0 | MIT | [jsbn](https://github.com/andyperlitch/jsbn#readme) | 
| json-parse-even-better-errors | 2.3.1 | MIT | [json-parse-even-better-errors](https://github.com/npm/json-parse-even-better-errors#readme) | 
| jsonfile | 4.0.0 | MIT | [jsonfile](https://github.com/jprichardson/node-jsonfile#readme) | 
| jsonparse | 1.3.1 | MIT | [jsonparse](https://github.com/creationix/jsonparse#readme) | 
| jsonschema | 1.4.1 | MIT | [jsonschema](https://github.com/tdegrunt/jsonschema#readme) | 
| jstree | 3.3.15 | MIT | [jstree](http://jstree.com) | 
| linkify-it | 5.0.0 | MIT | [linkify-it](https://github.com/markdown-it/linkify-it#readme) | 
| locate-path | 5.0.0 | MIT | [locate-path](https://github.com/sindresorhus/locate-path#readme) | 
| lodash | 4.17.21 | MIT | [lodash](https://lodash.com/) | 
| lodash-deep | 2.0.0 | MIT | [lodash-deep](https://github.com/marklagendijk/lodash-deep) | 
| log4js | 6.4.0 | Apache-2.0 | [log4js](https://log4js-node.github.io/log4js-node/) | 
| lru-cache | 5.1.1 | ISC | [lru-cache](https://github.com/isaacs/node-lru-cache#readme) | 
| lru-cache | 6.0.0 | ISC | [lru-cache](https://github.com/isaacs/node-lru-cache#readme) | 
| make-fetch-happen | 8.0.14 | ISC | [make-fetch-happen](https://github.com/npm/make-fetch-happen#readme) | 
| markdown-it | 14.1.0 | MIT | [markdown-it](https://github.com/markdown-it/markdown-it#readme) | 
| mdurl | 2.0.0 | MIT | [mdurl](https://github.com/markdown-it/mdurl#readme) | 
| minimatch | 3.1.2 | ISC | [minimatch](https://github.com/isaacs/minimatch#readme) | 
| minimist | 1.2.8 | MIT | [minimist](https://github.com/minimistjs/minimist) | 
| minipass | 3.3.6 | ISC | [minipass](https://github.com/isaacs/minipass#readme) | 
| minipass | 5.0.0 | ISC | [minipass](https://github.com/isaacs/minipass#readme) | 
| minipass-collect | 1.0.2 | ISC | [minipass-collect](https://github.com/isaacs/minipass-collect#readme) | 
| minipass-fetch | 1.4.1 | MIT | [minipass-fetch](https://github.com/npm/minipass-fetch#readme) | 
| minipass-flush | 1.0.5 | ISC | [minipass-flush](https://github.com/isaacs/minipass-flush#readme) | 
| minipass-json-stream | 1.0.1 | MIT | [minipass-json-stream](https://github.com/npm/minipass-json-stream#readme) | 
| minipass-pipeline | 1.2.4 | ISC | [minipass-pipeline]() | 
| minipass-sized | 1.0.3 | ISC | [minipass-sized](https://github.com/isaacs/minipass-sized#readme) | 
| minizlib | 2.1.2 | MIT | [minizlib](https://github.com/isaacs/minizlib#readme) | 
| mkdirp | 1.0.4 | MIT | [mkdirp](https://github.com/isaacs/node-mkdirp#readme) | 
| ms | 2.1.2 | MIT | [ms](https://github.com/zeit/ms#readme) | 
| mustache | 2.3.2 | MIT | [mustache](https://github.com/janl/mustache.js) | 
| nan | 2.18.0 | MIT | [nan](https://github.com/nodejs/nan#readme) | 
| npm-bundled | 1.1.2 | ISC | [npm-bundled](https://github.com/npm/npm-bundled#readme) | 
| npm-install-checks | 4.0.0 | BSD-2-Clause | [npm-install-checks](https://github.com/npm/npm-install-checks#readme) | 
| npm-normalize-package-bin | 1.0.1 | ISC | [npm-normalize-package-bin](https://github.com/npm/npm-normalize-package-bin#readme) | 
| npm-package-arg | 8.1.1 | ISC | [npm-package-arg](https://github.com/npm/npm-package-arg) | 
| npm-package-arg | 8.1.5 | ISC | [npm-package-arg](https://github.com/npm/npm-package-arg) | 
| npm-packlist | 2.2.2 | ISC | [npm-packlist](https://github.com/npm/npm-packlist#readme) | 
| npm-pick-manifest | 6.1.1 | ISC | [npm-pick-manifest](https://github.com/npm/npm-pick-manifest#readme) | 
| npm-registry-fetch | 8.1.5 | ISC | [npm-registry-fetch](https://github.com/npm/registry-fetch#readme) | 
| once | 1.4.0 | ISC | [once](https://github.com/isaacs/once#readme) | 
| opener | 1.5.2 | (WTFPL OR MIT) | [opener](https://github.com/domenic/opener#readme) | 
| p-limit | 2.3.0 | MIT | [p-limit](https://github.com/sindresorhus/p-limit#readme) | 
| p-locate | 4.1.0 | MIT | [p-locate](https://github.com/sindresorhus/p-locate#readme) | 
| p-map | 4.0.0 | MIT | [p-map](https://github.com/sindresorhus/p-map#readme) | 
| p-try | 2.2.0 | MIT | [p-try](https://github.com/sindresorhus/p-try#readme) | 
| pacote | 11.1.4 | ISC | [pacote](https://github.com/npm/pacote#readme) | 
| path-exists | 4.0.0 | MIT | [path-exists](https://github.com/sindresorhus/path-exists#readme) | 
| path-is-absolute | 1.0.1 | MIT | [path-is-absolute](https://github.com/sindresorhus/path-is-absolute#readme) | 
| path-key | 3.1.1 | MIT | [path-key](https://github.com/sindresorhus/path-key#readme) | 
| prettyjson | 1.2.2 | MIT | [prettyjson](http://rafeca.com/prettyjson) | 
| progress | 2.0.3 | MIT | [progress](https://github.com/visionmedia/node-progress#readme) | 
| promise-inflight | 1.0.1 | ISC | [promise-inflight](https://github.com/iarna/promise-inflight#readme) | 
| promise-retry | 1.1.1 | MIT | [promise-retry](https://github.com/IndigoUnited/node-promise-retry#readme) | 
| promise-retry | 2.0.1 | MIT | [promise-retry](https://github.com/IndigoUnited/node-promise-retry#readme) | 
| punycode.js | 2.3.1 | MIT | [punycode.js](https://mths.be/punycode) | 
| read-package-json-fast | 1.2.2 | ISC | [read-package-json-fast](https://github.com/npm/read-package-json-fast#readme) | 
| readline-sync | 1.4.10 | MIT | [readline-sync](https://github.com/anseki/readline-sync) | 
| require-directory | 2.1.1 | MIT | [require-directory](https://github.com/troygoode/node-require-directory/) | 
| require-main-filename | 2.0.0 | ISC | [require-main-filename](https://github.com/yargs/require-main-filename#readme) | 
| retry | 0.10.1 | MIT | [retry](https://github.com/tim-kos/node-retry) | 
| retry | 0.12.0 | MIT | [retry](https://github.com/tim-kos/node-retry) | 
| rfdc | 1.3.0 | MIT | [rfdc](https://github.com/davidmarkclements/rfdc#readme) | 
| rimraf | 2.7.1 | ISC | [rimraf](https://github.com/isaacs/rimraf#readme) | 
| rimraf | 3.0.2 | ISC | [rimraf](https://github.com/isaacs/rimraf#readme) | 
| safer-buffer | 2.1.2 | MIT | [safer-buffer](https://github.com/ChALkeR/safer-buffer#readme) | 
| scroll-into-view-if-needed | 2.2.31 | MIT | [scroll-into-view-if-needed](https://scroll-into-view.dev) | 
| select | 1.1.2 | MIT | [select](https://github.com/zenorocha/select#readme) | 
| semver | 5.7.2 | ISC | [semver](https://github.com/npm/node-semver#readme) | 
| semver | 7.5.4 | ISC | [semver](https://github.com/npm/node-semver#readme) | 
| set-blocking | 2.0.0 | ISC | [set-blocking](https://github.com/yargs/set-blocking#readme) | 
| shebang-command | 2.0.0 | MIT | [shebang-command](https://github.com/kevva/shebang-command#readme) | 
| shebang-regex | 3.0.0 | MIT | [shebang-regex](https://github.com/sindresorhus/shebang-regex#readme) | 
| smart-buffer | 4.2.0 | MIT | [smart-buffer](https://github.com/JoshGlazebrook/smart-buffer/) | 
| socks | 2.7.3 | MIT | [socks](https://github.com/JoshGlazebrook/socks/) | 
| socks-proxy-agent | 5.0.1 | MIT | [socks-proxy-agent](https://github.com/TooTallNate/node-socks-proxy-agent#readme) | 
| split.js | 1.6.5 | MIT | [split.js](https://split.js.org/) | 
| sprintf-js | 1.0.3 | BSD-3-Clause | [sprintf-js](https://github.com/alexei/sprintf.js#readme) | 
| sprintf-js | 1.1.3 | BSD-3-Clause | [sprintf-js](https://github.com/alexei/sprintf.js#readme) | 
| ssh2 | 1.15.0 | MIT | [ssh2](https://github.com/mscdex/ssh2#readme) | 
| ssri | 8.0.1 | ISC | [ssri](https://github.com/npm/ssri#readme) | 
| stack-trace | 0.0.10 | MIT | [stack-trace](https://github.com/felixge/node-stack-trace) | 
| streamroller | 3.1.5 | MIT | [streamroller](https://github.com/log4js-node/streamroller#readme) | 
| string-width | 4.2.3 | MIT | [string-width](https://github.com/sindresorhus/string-width#readme) | 
| strip-ansi | 6.0.1 | MIT | [strip-ansi](https://github.com/chalk/strip-ansi#readme) | 
| supports-color | 5.5.0 | MIT | [supports-color](https://github.com/chalk/supports-color#readme) | 
| tar | 6.2.1 | ISC | [tar](https://github.com/isaacs/node-tar#readme) | 
| tiny-emitter | 2.1.0 | MIT | [tiny-emitter](https://github.com/scottcorgan/tiny-emitter#readme) | 
| tweetnacl | 0.14.5 | Unlicense | [tweetnacl](https://tweetnacl.js.org) | 
| uc.micro | 2.1.0 | MIT | [uc.micro](https://github.com/markdown-it/uc.micro#readme) | 
| unique-filename | 1.1.1 | ISC | [unique-filename](https://github.com/iarna/unique-filename) | 
| unique-slug | 2.0.2 | ISC | [unique-slug](https://github.com/iarna/unique-slug#readme) | 
| universalify | 0.1.2 | MIT | [universalify](https://github.com/RyanZim/universalify#readme) | 
| url-search-params-polyfill | 8.2.5 | MIT | [url-search-params-polyfill](https://github.com/jerrybendy/url-search-params-polyfill) | 
| validate-npm-package-name | 3.0.0 | ISC | [validate-npm-package-name](https://github.com/npm/validate-npm-package-name) | 
| which | 2.0.2 | ISC | [which](https://github.com/isaacs/node-which#readme) | 
| which | 3.0.0 | ISC | [which](https://github.com/npm/node-which#readme) | 
| which-module | 2.0.1 | ISC | [which-module](https://github.com/nexdrew/which-module#readme) | 
| wrap-ansi | 6.2.0 | MIT | [wrap-ansi](https://github.com/chalk/wrap-ansi#readme) | 
| wrap-ansi | 7.0.0 | MIT | [wrap-ansi](https://github.com/chalk/wrap-ansi#readme) | 
| wrappy | 1.0.2 | ISC | [wrappy](https://github.com/npm/wrappy) | 
| y18n | 4.0.3 | ISC | [y18n](https://github.com/yargs/y18n) | 
| yallist | 3.1.1 | ISC | [yallist](https://github.com/isaacs/yallist#readme) | 
| yallist | 4.0.0 | ISC | [yallist](https://github.com/isaacs/yallist#readme) | 
| yamljs | 0.3.0 | MIT | [yamljs](https://github.com/jeremyfa/yaml.js#readme) | 
| yargs | 15.3.1 | MIT | [yargs](https://yargs.js.org/) | 
| yargs-parser | 18.1.3 | ISC | [yargs-parser](https://github.com/yargs/yargs-parser#readme) | 
| @colors/colors | 1.5.0 | MIT | [colors](https://github.com/DABH/colors.js) | 
| @gar/promisify | 1.1.3 | MIT | [promisify](https://github.com/wraithgar/gar-promisify#readme) | 
| @npmcli/ci-detect | 1.4.0 | ISC | [ci-detect](https://github.com/npm/ci-detect#readme) | 
| @npmcli/fs | 1.1.1 | ISC | [fs](https://github.com/npm/fs#readme) | 
| @npmcli/git | 2.1.0 | ISC | [git](https://github.com/npm/git#readme) | 
| @npmcli/installed-package-contents | 1.0.7 | ISC | [installed-package-contents](https://github.com/npm/installed-package-contents#readme) | 
| @npmcli/move-file | 1.1.2 | MIT | [move-file](https://github.com/npm/move-file#readme) | 
| @npmcli/promise-spawn | 1.3.2 | ISC | [promise-spawn](https://github.com/npm/promise-spawn#readme) | 
| @tootallnate/once | 1.1.2 | MIT | [once](https://github.com/TooTallNate/once#readme) | 
| @types/yargs | 13.0.4 | MIT | [yargs](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/yargs) | 
| @types/yargs-parser | 21.0.0 | MIT | [yargs-parser](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/yargs-parser) | 
| @zowe/core-for-zowe-sdk | 6.40.28 | EPL-2.0 | [core-for-zowe-sdk](https://github.com/zowe/zowe-cli/tree/master/packages/core#readme) | 
| @zowe/imperative | 4.18.24 | EPL-2.0 | [imperative](https://github.com/zowe/imperative#readme) | 
| @zowe/provisioning-for-zowe-sdk | 6.40.28 | EPL-2.0 | [provisioning-for-zowe-sdk](https://github.com/zowe/zowe-cli/tree/master/packages/provisioning#readme) | 
| @zowe/zos-console-for-zowe-sdk | 6.40.28 | EPL-2.0 | [zos-console-for-zowe-sdk](https://github.com/zowe/zowe-cli/tree/master/packages/zosconsole#readme) | 
| @zowe/zos-files-for-zowe-sdk | 6.40.28 | EPL-2.0 | [zos-files-for-zowe-sdk](https://github.com/zowe/zowe-cli/tree/master/packages/zosfiles#readme) | 
| @zowe/zos-jobs-for-zowe-sdk | 6.40.28 | EPL-2.0 | [zos-jobs-for-zowe-sdk](https://github.com/zowe/zowe-cli/tree/master/packages/zosjobs#readme) | 
| @zowe/zos-logs-for-zowe-sdk | 6.40.28 | EPL-2.0 | [zos-logs-for-zowe-sdk](https://github.com/zowe/zowe-cli/tree/master/packages/zoslogs#readme) | 
| @zowe/zos-tso-for-zowe-sdk | 6.40.28 | EPL-2.0 | [zos-tso-for-zowe-sdk](https://github.com/zowe/zowe-cli/tree/master/packages/zostso#readme) | 
| @zowe/zos-uss-for-zowe-sdk | 6.40.28 | EPL-2.0 | [zos-uss-for-zowe-sdk](https://github.com/zowe/zowe-cli/tree/master/packages/zosuss#readme) | 
| @zowe/zos-workflows-for-zowe-sdk | 6.40.28 | EPL-2.0 | [zos-workflows-for-zowe-sdk](https://github.com/zowe/zowe-cli/tree/master/packages/workflows#readme) | 
| @zowe/zosmf-for-zowe-sdk | 6.40.28 | EPL-2.0 | [zosmf-for-zowe-sdk](https://github.com/zowe/zowe-cli/tree/master/packages/zosmf#readme) | 

### IBM&reg Db2&reg Plug-in for Zowe CLI Dependency Attributions
| Third-party Software | Version | License | GitHub |
| -------------------- | --------| ------- | ------ |
| adm-zip | 0.5.10 | MIT | [adm-zip](https://github.com/cthackers/adm-zip) | 
| asynckit | 0.4.0 | MIT | [asynckit](https://github.com/alexindigo/asynckit#readme) | 
| axios | 1.6.1 | MIT | [axios](https://axios-http.com) | 
| big-integer | 1.6.51 | Unlicense | [big-integer](https://github.com/peterolson/BigInteger.js#readme) | 
| bindings | 1.5.0 | MIT | [bindings](https://github.com/TooTallNate/node-bindings) | 
| bl | 1.2.3 | MIT | [bl](https://github.com/rvagg/bl) | 
| buffer-alloc | 1.2.0 | MIT | [buffer-alloc](https://github.com/LinusU/buffer-alloc#readme) | 
| buffer-alloc-unsafe | 1.1.0 | MIT | [buffer-alloc-unsafe](https://github.com/LinusU/buffer-alloc-unsafe#readme) | 
| buffer-fill | 1.0.0 | MIT | [buffer-fill](https://github.com/linusu/buffer-fill#readme) | 
| chownr | 1.1.4 | ISC | [chownr](https://github.com/isaacs/chownr#readme) | 
| combined-stream | 1.0.8 | MIT | [combined-stream](https://github.com/felixge/node-combined-stream) | 
| core-util-is | 1.0.3 | MIT | [core-util-is](https://github.com/isaacs/core-util-is#readme) | 
| delayed-stream | 1.0.0 | MIT | [delayed-stream](https://github.com/felixge/node-delayed-stream) | 
| end-of-stream | 1.4.4 | MIT | [end-of-stream](https://github.com/mafintosh/end-of-stream) | 
| file-uri-to-path | 1.0.0 | MIT | [file-uri-to-path](https://github.com/TooTallNate/file-uri-to-path) | 
| follow-redirects | 1.15.6 | MIT | [follow-redirects](https://github.com/follow-redirects/follow-redirects) | 
| form-data | 4.0.0 | MIT | [form-data](https://github.com/form-data/form-data#readme) | 
| fs-constants | 1.0.0 | MIT | [fs-constants](https://github.com/mafintosh/fs-constants) | 
| fs-extra | 11.1.1 | MIT | [fs-extra](https://github.com/jprichardson/node-fs-extra) | 
| graceful-fs | 4.2.9 | ISC | [graceful-fs](https://github.com/isaacs/node-graceful-fs#readme) | 
| ibm_db | 3.2.2 | MIT | [ibm_db](https://github.com/ibmdb/node-ibm_db/) | 
| inherits | 2.0.4 | ISC | [inherits](https://github.com/isaacs/inherits#readme) | 
| isarray | 1.0.0 | MIT | [isarray](https://github.com/juliangruber/isarray) | 
| jsonfile | 6.1.0 | MIT | [jsonfile](https://github.com/jprichardson/node-jsonfile#readme) | 
| lodash | 4.17.21 | MIT | [lodash](https://lodash.com/) | 
| mime-db | 1.51.0 | MIT | [mime-db](https://github.com/jshttp/mime-db#readme) | 
| mime-types | 2.1.34 | MIT | [mime-types](https://github.com/jshttp/mime-types#readme) | 
| minimist | 1.2.6 | MIT | [minimist](https://github.com/substack/minimist) | 
| mkdirp | 0.5.5 | MIT | [mkdirp](https://github.com/substack/node-mkdirp#readme) | 
| nan | 2.18.0 | MIT | [nan](https://github.com/nodejs/nan#readme) | 
| once | 1.4.0 | ISC | [once](https://github.com/isaacs/once#readme) | 
| process-nextick-args | 2.0.1 | MIT | [process-nextick-args](https://github.com/calvinmetcalf/process-nextick-args) | 
| proxy-from-env | 1.1.0 | MIT | [proxy-from-env](https://github.com/Rob--W/proxy-from-env#readme) | 
| pump | 1.0.3 | MIT | [pump](https://github.com/mafintosh/pump#readme) | 
| q | 1.5.1 | MIT | [q](https://github.com/kriskowal/q) | 
| readable-stream | 2.3.7 | MIT | [readable-stream](https://github.com/nodejs/readable-stream#readme) | 
| safe-buffer | 5.1.2 | MIT | [safe-buffer](https://github.com/feross/safe-buffer) | 
| string_decoder | 1.1.1 | MIT | [string_decoder](https://github.com/nodejs/string_decoder) | 
| tar-fs | 1.16.3 | MIT | [tar-fs](https://github.com/mafintosh/tar-fs) | 
| tar-stream | 1.6.2 | MIT | [tar-stream](https://github.com/mafintosh/tar-stream) | 
| targz | 1.0.1 | MIT | [targz](https://github.com/miskun/targz#readme) | 
| to-buffer | 1.1.1 | MIT | [to-buffer](https://github.com/mafintosh/to-buffer) | 
| universalify | 2.0.1 | MIT | [universalify](https://github.com/RyanZim/universalify#readme) | 
| util-deprecate | 1.0.2 | MIT | [util-deprecate](https://github.com/TooTallNate/util-deprecate) | 
| wrappy | 1.0.2 | ISC | [wrappy](https://github.com/npm/wrappy) | 
| xtend | 4.0.2 | MIT | [xtend](https://github.com/Raynos/xtend) | 

### Performance Timing Utility Dependency Attributions
| Third-party Software | Version | License | GitHub |
| -------------------- | --------| ------- | ------ |
| find-up | 2.1.0 | MIT | [find-up](https://github.com/sindresorhus/find-up#readme) | 
| fs-extra | 8.1.0 | MIT | [fs-extra](https://github.com/jprichardson/node-fs-extra) | 
| graceful-fs | 4.2.10 | ISC | [graceful-fs](https://github.com/isaacs/node-graceful-fs#readme) | 
| jsonfile | 4.0.0 | MIT | [jsonfile](https://github.com/jprichardson/node-jsonfile#readme) | 
| locate-path | 2.0.0 | MIT | [locate-path](https://github.com/sindresorhus/locate-path#readme) | 
| p-limit | 1.3.0 | MIT | [p-limit](https://github.com/sindresorhus/p-limit#readme) | 
| p-locate | 2.0.0 | MIT | [p-locate](https://github.com/sindresorhus/p-locate#readme) | 
| p-try | 1.0.0 | MIT | [p-try](https://github.com/sindresorhus/p-try#readme) | 
| path-exists | 3.0.0 | MIT | [path-exists](https://github.com/sindresorhus/path-exists#readme) | 
| pkg-up | 2.0.0 | MIT | [pkg-up](https://github.com/sindresorhus/pkg-up#readme) | 
| universalify | 0.1.2 | MIT | [universalify](https://github.com/RyanZim/universalify#readme) | 

### Secure Credential Store Plug-in for Zowe CLI Dependency Attributions
| Third-party Software | Version | License | GitHub |
| -------------------- | --------| ------- | ------ |
| @zowe/secrets-for-zowe-sdk | 7.18.4 | EPL-2.0 | [secrets-for-zowe-sdk](https://github.com/zowe/zowe-cli/tree/master/packages/secrets#readme) | 

### z/OS&reg FTP Plug-in for Zowe CLI Dependency Attributions
| Third-party Software | Version | License | GitHub |
| -------------------- | --------| ------- | ------ |
| core-util-is | 1.0.3 | MIT | [core-util-is](https://github.com/isaacs/core-util-is#readme) | 
| debug | 3.1.0 | MIT | [debug](https://github.com/visionmedia/debug#readme) | 
| ftp4 | 0.3.13 | MIT | [ftp4](https://github.com/std4lqi/node-ftp#readme) | 
| inherits | 2.0.4 | ISC | [inherits](https://github.com/isaacs/inherits#readme) | 
| isarray | 0.0.1 | MIT | [isarray](https://github.com/juliangruber/isarray) | 
| ms | 2.0.0 | MIT | [ms](https://github.com/zeit/ms#readme) | 
| q | 1.4.1 | MIT | [q](https://github.com/kriskowal/q) | 
| readable-stream | 1.1.14 | MIT | [readable-stream](https://github.com/nodejs/readable-stream) | 
| string_decoder | 0.10.31 | MIT | [string_decoder](https://github.com/rvagg/string_decoder) | 
| xregexp | 2.0.0 | MIT | [xregexp](http://xregexp.com/) | 
| zos-node-accessor | 1.0.14 | EPL-1.0 | [zos-node-accessor](https://github.com/IBM/zos-node-accessor#readme) | 

