/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.jobs.services.zosmf;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.utils.ResponseCache;
import org.zowe.jobs.services.zosmf.AbstractZosmfJobsRequestRunner;

public class ModifyJobZosmfRequestRunner
extends AbstractZosmfJobsRequestRunner<Void> {
    private String jobName;
    private String jobId;
    private String command;

    public ModifyJobZosmfRequestRunner(String jobName, String jobId, String command, List<Header> headers) {
        super(headers);
        this.jobName = jobName;
        this.jobId = jobId;
        this.command = command;
    }

    protected int[] getSuccessStatus() {
        return new int[]{200, 202};
    }

    protected RequestBuilder prepareQuery(ZosmfConnector zosmfConnector) throws URISyntaxException {
        String urlPath = String.format("restjobs/jobs/%s/%s", this.jobName, this.jobId);
        URI requestUrl = zosmfConnector.getFullUrl(urlPath);
        JsonObject body = new JsonObject();
        body.addProperty("request", this.command);
        StringEntity requestEntity = new StringEntity(body.toString(), ContentType.APPLICATION_JSON);
        return RequestBuilder.put((URI)requestUrl).setEntity((HttpEntity)requestEntity);
    }

    protected Void getResult(ResponseCache responseCache) throws IOException {
        return null;
    }

    protected ZoweApiRestException createException(JsonObject jsonResponse, int statusCode) {
        return this.createJobNotFoundExceptions(jsonResponse, statusCode, this.jobName, this.jobId);
    }
}

