/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.jobs.services;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.zowe.api.common.exceptions.ZoweApiException;
import org.zowe.api.common.model.ItemsWrapper;
import org.zowe.jobs.model.Job;
import org.zowe.jobs.model.JobFile;
import org.zowe.jobs.model.JobFileContent;
import org.zowe.jobs.model.JobStatus;

public abstract class JobsService {
    private HttpServletRequest request;

    public List<Header> getIbmHeadersFromRequest() {
        ArrayList<Header> ibmHeaders = new ArrayList<Header>();
        if (this.request != null) {
            Enumeration headerNames = this.request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = ((String)headerNames.nextElement()).toUpperCase();
                if (!headerName.contains("X-IBM")) continue;
                BasicHeader newHeader = new BasicHeader(headerName, this.request.getHeader(headerName));
                ibmHeaders.add((Header)newHeader);
            }
        }
        return ibmHeaders;
    }

    public abstract ItemsWrapper<Job> getJobs(String var1, String var2, JobStatus var3) throws ZoweApiException;

    public abstract Job getJob(String var1, String var2);

    public abstract void purgeJob(String var1, String var2);

    public abstract void modifyJob(String var1, String var2, String var3);

    public abstract Job submitJobString(String var1);

    public abstract Job submitJobFile(String var1);

    public abstract ItemsWrapper<JobFile> getJobFiles(String var1, String var2);

    public abstract JobFileContent getJobFileContent(String var1, String var2, String var3);

    public abstract JobFileContent getJobJcl(String var1, String var2);

    @Generated
    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }
}

