/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.jobs.spring;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.responses.ApiResponse;
import org.springdoc.core.customizers.OpenApiCustomiser;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SwaggerConfig {
    private static final ApiResponse response401 = new ApiResponse().description("Unauthorized");
    private static final ApiResponse response403 = new ApiResponse().description("Forbidden");
    private static final ApiResponse response404 = new ApiResponse().description("Not Found");

    @Bean
    public OpenAPI openAPI() {
        return new OpenAPI().info(new Info().title("JES Jobs API").description("REST API for the JES Jobs Service").version("1.0.0"));
    }

    @Bean
    public OpenApiCustomiser genericApiResponsesCustomizer() {
        return openApi -> openApi.getPaths().forEach((key, pathEntry) -> pathEntry.readOperations().forEach(op -> {
            op.getResponses().addApiResponse("401", response401);
            op.getResponses().addApiResponse("403", response403);
            op.getResponses().addApiResponse("404", response404);
        }));
    }
}

