/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.jobs.services.zosmf;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.exceptions.ZoweApiException;
import org.zowe.api.common.model.ItemsWrapper;
import org.zowe.jobs.exceptions.JobFileIdNotFoundException;
import org.zowe.jobs.exceptions.JobJesjclNotFoundException;
import org.zowe.jobs.model.Job;
import org.zowe.jobs.model.JobFile;
import org.zowe.jobs.model.JobFileContent;
import org.zowe.jobs.model.JobStatus;
import org.zowe.jobs.services.JobsService;
import org.zowe.jobs.services.zosmf.GetJobFileContentZosmfRequestRunner;
import org.zowe.jobs.services.zosmf.GetJobFilesZosmfRequestRunner;
import org.zowe.jobs.services.zosmf.GetJobZosmfRequestRunner;
import org.zowe.jobs.services.zosmf.GetJobsZosmfRequestRunner;
import org.zowe.jobs.services.zosmf.ModifyJobZosmfRequestRunner;
import org.zowe.jobs.services.zosmf.PurgeJobZosmfRequestRunner;
import org.zowe.jobs.services.zosmf.SubmitJobFileZosmfRequestRunner;
import org.zowe.jobs.services.zosmf.SubmitJobStringZosmfRequestRunner;

public abstract class AbstractZosmfJobsService
extends JobsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractZosmfJobsService.class);

    abstract ZosmfConnector getZosmfConnector();

    @Override
    public ItemsWrapper<Job> getJobs(String prefix, String owner, JobStatus status) throws ZoweApiException {
        GetJobsZosmfRequestRunner runner = new GetJobsZosmfRequestRunner(prefix, owner, status, this.getIbmHeadersFromRequest());
        return (ItemsWrapper)runner.run(this.getZosmfConnector());
    }

    @Override
    public Job getJob(String jobName, String jobId) {
        GetJobZosmfRequestRunner runner = new GetJobZosmfRequestRunner(jobName, jobId, this.getIbmHeadersFromRequest());
        return (Job)runner.run(this.getZosmfConnector());
    }

    @Override
    public Job submitJobString(String jcl) {
        SubmitJobStringZosmfRequestRunner runner = new SubmitJobStringZosmfRequestRunner(jcl, this.getIbmHeadersFromRequest());
        return (Job)runner.run(this.getZosmfConnector());
    }

    @Override
    public Job submitJobFile(String fileName) {
        SubmitJobFileZosmfRequestRunner runner = new SubmitJobFileZosmfRequestRunner(fileName, this.getIbmHeadersFromRequest());
        return (Job)runner.run(this.getZosmfConnector());
    }

    @Override
    public void purgeJob(String jobName, String jobId) {
        PurgeJobZosmfRequestRunner runner = new PurgeJobZosmfRequestRunner(jobName, jobId, this.getIbmHeadersFromRequest());
        runner.run(this.getZosmfConnector());
    }

    @Override
    public void modifyJob(String jobName, String jobId, String command) {
        ModifyJobZosmfRequestRunner runner = new ModifyJobZosmfRequestRunner(jobName, jobId, command, this.getIbmHeadersFromRequest());
        runner.run(this.getZosmfConnector());
    }

    @Override
    public ItemsWrapper<JobFile> getJobFiles(String jobName, String jobId) {
        GetJobFilesZosmfRequestRunner runner = new GetJobFilesZosmfRequestRunner(jobName, jobId, this.getIbmHeadersFromRequest());
        return (ItemsWrapper)runner.run(this.getZosmfConnector());
    }

    @Override
    public JobFileContent getJobFileContent(String jobName, String jobId, String fileId) {
        GetJobFileContentZosmfRequestRunner runner = new GetJobFileContentZosmfRequestRunner(jobName, jobId, fileId, this.getIbmHeadersFromRequest());
        return (JobFileContent)runner.run(this.getZosmfConnector());
    }

    @Override
    public JobFileContent getJobJcl(String jobName, String jobId) {
        try {
            return this.getJobFileContent(jobName, jobId, "3");
        }
        catch (JobFileIdNotFoundException e) {
            log.error("getJobJcl", (Throwable)((Object)e));
            throw new JobJesjclNotFoundException(jobName, jobId);
        }
    }
}

