/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.jobs.services.zosmf;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.http.client.methods.RequestBuilder;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.model.ItemsWrapper;
import org.zowe.api.common.utils.ResponseCache;
import org.zowe.jobs.model.JobFile;
import org.zowe.jobs.services.zosmf.AbstractZosmfJobsRequestRunner;

public class GetJobFilesZosmfRequestRunner
extends AbstractZosmfJobsRequestRunner<ItemsWrapper<JobFile>> {
    private String jobName;
    private String jobId;

    public GetJobFilesZosmfRequestRunner(String jobName, String jobId) {
        this.jobName = jobName;
        this.jobId = jobId;
    }

    protected RequestBuilder prepareQuery(ZosmfConnector zosmfConnector) throws URISyntaxException {
        String urlPath = String.format("restjobs/jobs/%s/%s/files", this.jobName, this.jobId);
        URI requestUrl = zosmfConnector.getFullUrl(urlPath);
        return RequestBuilder.get((URI)requestUrl);
    }

    protected int[] getSuccessStatus() {
        return new int[]{200};
    }

    protected ItemsWrapper<JobFile> getResult(ResponseCache responseCache) throws IOException {
        JsonElement jsonResponse = responseCache.getEntityAsJson();
        ArrayList<JobFile> jobFiles = new ArrayList<JobFile>();
        for (JsonElement jsonElement : jsonResponse.getAsJsonArray()) {
            jobFiles.add(GetJobFilesZosmfRequestRunner.getJobFileFromJson(jsonElement.getAsJsonObject()));
        }
        return new ItemsWrapper(jobFiles);
    }

    protected ZoweApiRestException createException(JsonObject jsonResponse, int statusCode) {
        return this.createJobNotFoundExceptions(jsonResponse, statusCode, this.jobName, this.jobId);
    }

    private static JobFile getJobFileFromJson(JsonObject returned) {
        return JobFile.builder().id(Long.valueOf(returned.get("id").getAsLong())).ddName(returned.get("ddname").getAsString()).recordFormat(returned.get("recfm").getAsString()).recordLength(Long.valueOf(returned.get("lrecl").getAsLong())).byteCount(Long.valueOf(returned.get("byte-count").getAsLong())).recordCount(Long.valueOf(returned.get("record-count").getAsLong())).build();
    }
}

