/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.jobs.services.zosmf;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.utils.ResponseCache;
import org.zowe.jobs.model.Job;
import org.zowe.jobs.services.zosmf.AbstractZosmfJobsRequestRunner;

public class SubmitJobStringZosmfRequestRunner
extends AbstractZosmfJobsRequestRunner<Job> {
    private String jcl;

    public SubmitJobStringZosmfRequestRunner(String jcl) {
        this.jcl = jcl;
    }

    protected RequestBuilder prepareQuery(ZosmfConnector zosmfConnector) throws URISyntaxException, IOException {
        String urlPath = String.format("restjobs/jobs", new Object[0]);
        URI requestUrl = zosmfConnector.getFullUrl(urlPath);
        StringEntity stringEntity = new StringEntity(this.jcl);
        RequestBuilder requestBuilder = RequestBuilder.put((URI)requestUrl).setEntity((HttpEntity)stringEntity);
        requestBuilder.addHeader("X-IBM-Intrdr-Class", "A");
        requestBuilder.addHeader("X-IBM-Intrdr-Recfm", "F");
        requestBuilder.addHeader("X-IBM-Intrdr-Lrecl", "80");
        requestBuilder.addHeader("X-IBM-Intrdr-Mode", "TEXT");
        requestBuilder.addHeader("Content-type", ContentType.TEXT_PLAIN.getMimeType());
        return requestBuilder;
    }

    protected int[] getSuccessStatus() {
        return new int[]{201};
    }

    protected Job getResult(ResponseCache responseCache) throws IOException {
        return this.getJobFromJson(responseCache.getEntityAsJsonObject());
    }
}

