/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.jobs.services.zosmf;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.http.client.methods.RequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.model.ItemsWrapper;
import org.zowe.api.common.utils.ResponseCache;
import org.zowe.jobs.exceptions.InvalidOwnerException;
import org.zowe.jobs.exceptions.InvalidPrefixException;
import org.zowe.jobs.model.Job;
import org.zowe.jobs.model.JobStatus;
import org.zowe.jobs.services.zosmf.AbstractZosmfJobsRequestRunner;

public class GetJobsZosmfRequestRunner
extends AbstractZosmfJobsRequestRunner<ItemsWrapper<Job>> {
    private static final Logger log = LoggerFactory.getLogger(GetJobsZosmfRequestRunner.class);
    private JobStatus status;
    private String prefix;
    private String owner;

    public GetJobsZosmfRequestRunner(String prefix, String owner, JobStatus status) {
        this.status = status;
        this.prefix = prefix;
        this.owner = owner;
    }

    protected int[] getSuccessStatus() {
        return new int[]{200};
    }

    protected RequestBuilder prepareQuery(ZosmfConnector zosmfConnector) throws URISyntaxException {
        if (this.prefix == null) {
            this.prefix = "*";
        }
        if (this.owner == null) {
            this.owner = "*";
        }
        String query = String.format("owner=%s&prefix=%s", this.owner, this.prefix);
        URI requestUrl = zosmfConnector.getFullUrl("restjobs/jobs", query);
        return RequestBuilder.get((URI)requestUrl);
    }

    protected ItemsWrapper<Job> getResult(ResponseCache responseCache) throws IOException {
        JsonElement jsonResponse = responseCache.getEntityAsJson();
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (JsonElement jsonElement : jsonResponse.getAsJsonArray()) {
            try {
                Job job = this.getJobFromJson(jsonElement.getAsJsonObject());
                if (!this.status.matches(job.getStatus())) continue;
                jobs.add(job);
            }
            catch (IllegalArgumentException e) {
                log.error("getJobs", (Throwable)e);
            }
        }
        return new ItemsWrapper(jobs);
    }

    protected ZoweApiRestException createException(JsonObject jsonResponse, int statusCode) throws IOException {
        if (statusCode == 400 && jsonResponse.has("message")) {
            String zosmfMessage = jsonResponse.get("message").getAsString();
            if ("Value of prefix query parameter is not valid".equals(zosmfMessage)) {
                return new InvalidPrefixException(this.prefix);
            }
            if ("Value of owner query parameter is not valid".equals(zosmfMessage)) {
                return new InvalidOwnerException(this.owner);
            }
        }
        return null;
    }
}

