/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.jobs.services.zosmf;

import com.google.gson.JsonObject;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.zosmf.services.AbstractZosmfRequestRunner;
import org.zowe.jobs.exceptions.JobIdNotFoundException;
import org.zowe.jobs.exceptions.JobNameNotFoundException;
import org.zowe.jobs.model.Job;
import org.zowe.jobs.model.JobStatus;

public abstract class AbstractZosmfJobsRequestRunner<T>
extends AbstractZosmfRequestRunner<T> {
    ZoweApiRestException createJobNotFoundExceptions(JsonObject jsonResponse, int statusCode, String jobName, String jobId) {
        if (jsonResponse.has("message")) {
            String zosmfMessage = jsonResponse.get("message").getAsString();
            if (statusCode == 400) {
                if (String.format("No job found for reference: '%s(%s)'", jobName, jobId).equals(zosmfMessage)) {
                    return new JobNameNotFoundException(jobName, jobId);
                }
            } else if (statusCode == 500 && String.format("Failed to lookup job %s(%s)", jobName, jobId).equals(zosmfMessage)) {
                return new JobIdNotFoundException(jobName, jobId);
            }
        }
        return null;
    }

    Job getJobFromJson(JsonObject returned) {
        return Job.builder().jobId(returned.get("jobid").getAsString()).jobName(returned.get("jobname").getAsString()).owner(returned.get("owner").getAsString()).type(returned.get("type").getAsString()).status(JobStatus.valueOf((String)returned.get("status").getAsString())).returnCode(this.getStringOrNull(returned, "retcode")).subsystem(returned.get("subsystem").getAsString()).executionClass(returned.get("class").getAsString()).phaseName(returned.get("phase-name").getAsString()).build();
    }
}

