/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.jobs.services.zosmf;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.exceptions.ZoweApiException;
import org.zowe.api.common.model.ItemsWrapper;
import org.zowe.jobs.exceptions.JobFileIdNotFoundException;
import org.zowe.jobs.exceptions.JobJesjclNotFoundException;
import org.zowe.jobs.model.Job;
import org.zowe.jobs.model.JobFile;
import org.zowe.jobs.model.JobFileContent;
import org.zowe.jobs.model.JobStatus;
import org.zowe.jobs.services.JobsService;
import org.zowe.jobs.services.zosmf.GetJobFileContentZosmfRequestRunner;
import org.zowe.jobs.services.zosmf.GetJobFilesZosmfRequestRunner;
import org.zowe.jobs.services.zosmf.GetJobZosmfRequestRunner;
import org.zowe.jobs.services.zosmf.GetJobsZosmfRequestRunner;
import org.zowe.jobs.services.zosmf.PurgeJobZosmfRequestRunner;
import org.zowe.jobs.services.zosmf.SubmitJobFileZosmfRequestRunner;
import org.zowe.jobs.services.zosmf.SubmitJobStringZosmfRequestRunner;

@Service
public class ZosmfJobsService
implements JobsService {
    private static final Logger log = LoggerFactory.getLogger(ZosmfJobsService.class);
    @Autowired
    ZosmfConnector zosmfConnector;

    @Override
    public ItemsWrapper<Job> getJobs(String prefix, String owner, JobStatus status) throws ZoweApiException {
        GetJobsZosmfRequestRunner runner = new GetJobsZosmfRequestRunner(prefix, owner, status);
        return (ItemsWrapper)runner.run(this.zosmfConnector);
    }

    @Override
    public Job getJob(String jobName, String jobId) {
        GetJobZosmfRequestRunner runner = new GetJobZosmfRequestRunner(jobName, jobId);
        return (Job)runner.run(this.zosmfConnector);
    }

    @Override
    public Job submitJobString(String jcl) {
        SubmitJobStringZosmfRequestRunner runner = new SubmitJobStringZosmfRequestRunner(jcl);
        return (Job)runner.run(this.zosmfConnector);
    }

    @Override
    public Job submitJobFile(String fileName) {
        SubmitJobFileZosmfRequestRunner runner = new SubmitJobFileZosmfRequestRunner(fileName);
        return (Job)runner.run(this.zosmfConnector);
    }

    @Override
    public void purgeJob(String jobName, String jobId) {
        PurgeJobZosmfRequestRunner runner = new PurgeJobZosmfRequestRunner(jobName, jobId);
        runner.run(this.zosmfConnector);
    }

    @Override
    public ItemsWrapper<JobFile> getJobFiles(String jobName, String jobId) {
        GetJobFilesZosmfRequestRunner runner = new GetJobFilesZosmfRequestRunner(jobName, jobId);
        return (ItemsWrapper)runner.run(this.zosmfConnector);
    }

    @Override
    public JobFileContent getJobFileContent(String jobName, String jobId, String fileId) {
        GetJobFileContentZosmfRequestRunner runner = new GetJobFileContentZosmfRequestRunner(jobName, jobId, fileId);
        return (JobFileContent)runner.run(this.zosmfConnector);
    }

    @Override
    public JobFileContent getJobJcl(String jobName, String jobId) {
        try {
            return this.getJobFileContent(jobName, jobId, "3");
        }
        catch (JobFileIdNotFoundException e) {
            log.error("getJobJcl", (Throwable)((Object)e));
            throw new JobJesjclNotFoundException(jobName, jobId);
        }
    }
}

