/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.jobs.services.zosmf;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.connectors.zosmf.exceptions.DataSetNotFoundException;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.utils.ResponseCache;
import org.zowe.jobs.model.Job;
import org.zowe.jobs.services.zosmf.AbstractZosmfJobsRequestRunner;

public class SubmitJobFileZosmfRequestRunner
extends AbstractZosmfJobsRequestRunner<Job> {
    private String fileName;

    public SubmitJobFileZosmfRequestRunner(String fileName) {
        this.fileName = fileName;
    }

    protected int[] getSuccessStatus() {
        return new int[]{201};
    }

    protected RequestBuilder prepareQuery(ZosmfConnector zosmfConnector) throws URISyntaxException {
        String urlPath = String.format("restjobs/jobs", new Object[0]);
        URI requestUrl = zosmfConnector.getFullUrl(urlPath);
        JsonObject body = new JsonObject();
        body.addProperty("file", "//'" + this.fileName + "'");
        StringEntity requestEntity = new StringEntity(body.toString(), ContentType.APPLICATION_JSON);
        RequestBuilder requestBuilder = RequestBuilder.put((URI)requestUrl).setEntity((HttpEntity)requestEntity);
        return requestBuilder;
    }

    protected Job getResult(ResponseCache responseCache) throws IOException {
        return this.getJobFromJson(responseCache.getEntityAsJsonObject());
    }

    protected ZoweApiRestException createException(JsonObject jsonResponse, int statusCode) {
        if (statusCode == 400) {
            if (jsonResponse.has("message")) {
                String zosmfMessage = jsonResponse.get("message").getAsString();
                if (String.format("Data set not found: %s", this.fileName).equals(zosmfMessage)) {
                    throw new DataSetNotFoundException(this.fileName);
                }
            }
        } else if (statusCode == 500 && jsonResponse.has("message")) {
            String zosmfMessage = jsonResponse.get("message").getAsString();
            if (String.format("Error opening input data set: //'%s'", this.fileName).equals(zosmfMessage)) {
                throw new DataSetNotFoundException(this.fileName);
            }
        }
        return null;
    }
}

