/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.jobs.services;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.connectors.zosmf.exceptions.DataSetNotFoundException;
import org.zowe.api.common.exceptions.NoZosmfResponseEntityException;
import org.zowe.api.common.exceptions.ServerErrorException;
import org.zowe.api.common.exceptions.ZoweApiException;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.utils.ResponseUtils;
import org.zowe.jobs.exceptions.BadRequestException;
import org.zowe.jobs.exceptions.InvalidOwnerException;
import org.zowe.jobs.exceptions.InvalidPrefixException;
import org.zowe.jobs.exceptions.JobFileIdNotFoundException;
import org.zowe.jobs.exceptions.JobIdNotFoundException;
import org.zowe.jobs.exceptions.JobJesjclNotFoundException;
import org.zowe.jobs.exceptions.JobNameNotFoundException;
import org.zowe.jobs.model.Job;
import org.zowe.jobs.model.JobFile;
import org.zowe.jobs.model.JobFileContent;
import org.zowe.jobs.model.JobStatus;
import org.zowe.jobs.services.JobsService;

@Service
public class ZosmfJobsService
implements JobsService {
    private static final Logger log = LoggerFactory.getLogger(ZosmfJobsService.class);
    @Autowired
    ZosmfConnector zosmfconnector;

    @Override
    public List<Job> getJobs(String prefix, String owner, JobStatus status) throws ZoweApiException {
        String queryPrefix = "*";
        String queryOwner = "*";
        if (prefix != null) {
            queryPrefix = prefix;
        }
        if (owner != null) {
            queryOwner = owner;
        }
        String query = String.format("owner=%s&prefix=%s", queryOwner, queryPrefix);
        try {
            URI requestUrl = this.zosmfconnector.getFullUrl("restjobs/jobs", query);
            ArrayList<Job> jobs = new ArrayList<Job>();
            HttpResponse response = this.zosmfconnector.request(RequestBuilder.get((URI)requestUrl));
            int statusCode = ResponseUtils.getStatus((HttpResponse)response);
            if (statusCode == 200) {
                JsonElement jsonResponse = ResponseUtils.getEntityAsJson((HttpResponse)response);
                for (JsonElement jsonElement : jsonResponse.getAsJsonArray()) {
                    try {
                        Job job = ZosmfJobsService.getJobFromJson(jsonElement.getAsJsonObject());
                        if (!status.matches(job.getStatus())) continue;
                        jobs.add(job);
                    }
                    catch (IllegalArgumentException e) {
                        log.error("getJobs", (Throwable)e);
                    }
                }
                return jobs;
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                ContentType contentType = ContentType.get((HttpEntity)entity);
                String mimeType = contentType.getMimeType();
                if (mimeType.equals(ContentType.APPLICATION_JSON.getMimeType())) {
                    JsonObject jsonResponse = ResponseUtils.getEntityAsJsonObject((HttpResponse)response);
                    if (statusCode == 400) {
                        if (jsonResponse.has("message")) {
                            String zosmfMessage = jsonResponse.get("message").getAsString();
                            if ("Value of prefix query parameter is not valid".equals(zosmfMessage)) {
                                throw new InvalidPrefixException(queryPrefix);
                            }
                            if ("Value of owner query parameter is not valid".equals(zosmfMessage)) {
                                throw new InvalidOwnerException(queryOwner);
                            }
                            throw new BadRequestException(zosmfMessage);
                        }
                        throw new BadRequestException(jsonResponse.toString());
                    }
                    if (jsonResponse.has("message")) {
                        String zosmfMessage = jsonResponse.get("message").getAsString();
                        throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), zosmfMessage, new Object[0]);
                    }
                    throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), jsonResponse.toString(), new Object[0]);
                }
                throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), entity.toString(), new Object[0]);
            }
            throw new NoZosmfResponseEntityException(this.getSpringHttpStatusFromCode(statusCode), requestUrl.toString());
        }
        catch (IOException | URISyntaxException e) {
            log.error("getJobs", (Throwable)e);
            throw new ServerErrorException((Throwable)e);
        }
    }

    @Override
    public Job getJob(String jobName, String jobId) {
        String urlPath = String.format("restjobs/jobs/%s/%s", jobName, jobId);
        try {
            URI requestUrl = this.zosmfconnector.getFullUrl(urlPath);
            HttpResponse response = this.zosmfconnector.request(RequestBuilder.get((URI)requestUrl));
            int statusCode = ResponseUtils.getStatus((HttpResponse)response);
            if (statusCode == 200) {
                JsonElement jsonResponse = ResponseUtils.getEntityAsJson((HttpResponse)response);
                return ZosmfJobsService.getJobFromJson(jsonResponse.getAsJsonObject());
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                ContentType contentType = ContentType.get((HttpEntity)entity);
                String mimeType = contentType.getMimeType();
                if (mimeType.equals(ContentType.APPLICATION_JSON.getMimeType())) {
                    JsonObject jsonResponse = ResponseUtils.getEntityAsJsonObject((HttpResponse)response);
                    if (statusCode == 400) {
                        if (jsonResponse.has("message")) {
                            String zosmfMessage = jsonResponse.get("message").getAsString();
                            if (String.format("No job found for reference: '%s(%s)'", jobName, jobId).equals(zosmfMessage)) {
                                throw new JobNameNotFoundException(jobName, jobId);
                            }
                            throw new BadRequestException(zosmfMessage);
                        }
                        throw new BadRequestException(jsonResponse.toString());
                    }
                    if (statusCode == 500) {
                        if (jsonResponse.has("message")) {
                            String zosmfMessage = jsonResponse.get("message").getAsString();
                            if (String.format("Failed to lookup job %s(%s)", jobName, jobId).equals(zosmfMessage)) {
                                throw new JobIdNotFoundException(jobName, jobId);
                            }
                            throw new BadRequestException(zosmfMessage);
                        }
                        throw new BadRequestException(jsonResponse.toString());
                    }
                    if (jsonResponse.has("message")) {
                        String zosmfMessage = jsonResponse.get("message").getAsString();
                        throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), zosmfMessage, new Object[0]);
                    }
                    throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), jsonResponse.toString(), new Object[0]);
                }
                throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), entity.toString(), new Object[0]);
            }
            throw new NoZosmfResponseEntityException(this.getSpringHttpStatusFromCode(statusCode), urlPath);
        }
        catch (IOException | URISyntaxException e) {
            log.error("getJob", (Throwable)e);
            throw new ServerErrorException((Throwable)e);
        }
    }

    @Override
    public Job submitJobString(String jcl) {
        String urlPath = String.format("restjobs/jobs", new Object[0]);
        try {
            URI requestUrl = this.zosmfconnector.getFullUrl(urlPath);
            RequestBuilder requestBuilder = RequestBuilder.put((URI)requestUrl).setEntity((HttpEntity)new StringEntity(jcl));
            requestBuilder.addHeader("X-IBM-Intrdr-Class", "A");
            requestBuilder.addHeader("X-IBM-Intrdr-Recfm", "F");
            requestBuilder.addHeader("X-IBM-Intrdr-Lrecl", "80");
            requestBuilder.addHeader("X-IBM-Intrdr-Mode", "TEXT");
            requestBuilder.addHeader("Content-type", ContentType.TEXT_PLAIN.getMimeType());
            HttpResponse response = this.zosmfconnector.request(requestBuilder);
            int statusCode = ResponseUtils.getStatus((HttpResponse)response);
            if (statusCode == 201) {
                JsonElement jsonResponse = ResponseUtils.getEntityAsJson((HttpResponse)response);
                return ZosmfJobsService.getJobFromJson(jsonResponse.getAsJsonObject());
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                ContentType contentType = ContentType.get((HttpEntity)entity);
                String mimeType = contentType.getMimeType();
                if (mimeType.equals(ContentType.APPLICATION_JSON.getMimeType())) {
                    JsonObject jsonResponse = ResponseUtils.getEntityAsJsonObject((HttpResponse)response);
                    if (jsonResponse.has("message")) {
                        String zosmfMessage = jsonResponse.get("message").getAsString();
                        throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), zosmfMessage, new Object[0]);
                    }
                    throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), jsonResponse.toString(), new Object[0]);
                }
                throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), entity.toString(), new Object[0]);
            }
            throw new NoZosmfResponseEntityException(this.getSpringHttpStatusFromCode(statusCode), urlPath);
        }
        catch (IOException | URISyntaxException e) {
            log.error("submitJobString", (Throwable)e);
            throw new ServerErrorException((Throwable)e);
        }
    }

    @Override
    public Job submitJobFile(String dataSet) {
        String urlPath = String.format("restjobs/jobs", new Object[0]);
        try {
            URI requestUrl = this.zosmfconnector.getFullUrl(urlPath);
            JsonObject body = new JsonObject();
            body.addProperty("file", "//'" + dataSet + "'");
            StringEntity requestEntity = new StringEntity(body.toString(), ContentType.APPLICATION_JSON);
            RequestBuilder requestBuilder = RequestBuilder.put((URI)requestUrl).setEntity((HttpEntity)requestEntity);
            HttpResponse response = this.zosmfconnector.request(requestBuilder);
            int statusCode = ResponseUtils.getStatus((HttpResponse)response);
            if (statusCode == 201) {
                JsonElement jsonResponse = ResponseUtils.getEntityAsJson((HttpResponse)response);
                return ZosmfJobsService.getJobFromJson(jsonResponse.getAsJsonObject());
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                ContentType contentType = ContentType.get((HttpEntity)entity);
                String mimeType = contentType.getMimeType();
                if (mimeType.equals(ContentType.APPLICATION_JSON.getMimeType())) {
                    JsonObject jsonResponse = ResponseUtils.getEntityAsJsonObject((HttpResponse)response);
                    if (statusCode == 400) {
                        if (jsonResponse.has("message")) {
                            String zosmfMessage = jsonResponse.get("message").getAsString();
                            if (String.format("Data set not found: %s", dataSet).equals(zosmfMessage)) {
                                throw new DataSetNotFoundException(dataSet);
                            }
                            throw new BadRequestException(zosmfMessage);
                        }
                        throw new BadRequestException(jsonResponse.toString());
                    }
                    if (statusCode == 500) {
                        if (jsonResponse.has("message")) {
                            String zosmfMessage = jsonResponse.get("message").getAsString();
                            if (String.format("Error opening input data set: //'%s'", dataSet).equals(zosmfMessage)) {
                                throw new DataSetNotFoundException(dataSet);
                            }
                            throw new BadRequestException(zosmfMessage);
                        }
                        throw new BadRequestException(jsonResponse.toString());
                    }
                    if (jsonResponse.has("message")) {
                        String zosmfMessage = jsonResponse.get("message").getAsString();
                        throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), zosmfMessage, new Object[0]);
                    }
                    throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), jsonResponse.toString(), new Object[0]);
                }
                throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), entity.toString(), new Object[0]);
            }
            throw new NoZosmfResponseEntityException(this.getSpringHttpStatusFromCode(statusCode), urlPath);
        }
        catch (IOException | URISyntaxException e) {
            log.error("submitJobFile", (Throwable)e);
            throw new ServerErrorException((Throwable)e);
        }
    }

    @Override
    public void purgeJob(String jobName, String jobId) {
        String urlPath = String.format("restjobs/jobs/%s/%s", jobName, jobId);
        try {
            URI requestUrl = this.zosmfconnector.getFullUrl(urlPath);
            HttpResponse response = this.zosmfconnector.request(RequestBuilder.delete((URI)requestUrl));
            int statusCode = ResponseUtils.getStatus((HttpResponse)response);
            if (statusCode != 202) {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    ContentType contentType = ContentType.get((HttpEntity)entity);
                    String mimeType = contentType.getMimeType();
                    if (mimeType.equals(ContentType.APPLICATION_JSON.getMimeType())) {
                        JsonObject jsonResponse = ResponseUtils.getEntityAsJsonObject((HttpResponse)response);
                        if (statusCode == 400) {
                            if (jsonResponse.has("message")) {
                                String zosmfMessage = jsonResponse.get("message").getAsString();
                                if (String.format("No job found for reference: '%s(%s)'", jobName, jobId).equals(zosmfMessage)) {
                                    throw new JobNameNotFoundException(jobName, jobId);
                                }
                                throw new BadRequestException(zosmfMessage);
                            }
                            throw new BadRequestException(jsonResponse.toString());
                        }
                        if (jsonResponse.has("message")) {
                            String zosmfMessage = jsonResponse.get("message").getAsString();
                            throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), zosmfMessage, new Object[0]);
                        }
                        throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), jsonResponse.toString(), new Object[0]);
                    }
                    throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), entity.toString(), new Object[0]);
                }
                throw new NoZosmfResponseEntityException(this.getSpringHttpStatusFromCode(statusCode), urlPath);
            }
        }
        catch (IOException | URISyntaxException e) {
            log.error("purgeJob", (Throwable)e);
            throw new ServerErrorException((Throwable)e);
        }
    }

    @Override
    public List<JobFile> getJobFiles(String jobName, String jobId) {
        String urlPath = String.format("restjobs/jobs/%s/%s/files", jobName, jobId);
        try {
            URI requestUrl = this.zosmfconnector.getFullUrl(urlPath);
            HttpResponse response = this.zosmfconnector.request(RequestBuilder.get((URI)requestUrl));
            int statusCode = ResponseUtils.getStatus((HttpResponse)response);
            if (statusCode == 200) {
                JsonElement jsonResponse = ResponseUtils.getEntityAsJson((HttpResponse)response);
                ArrayList<JobFile> jobFiles = new ArrayList<JobFile>();
                for (JsonElement jsonElement : jsonResponse.getAsJsonArray()) {
                    jobFiles.add(ZosmfJobsService.getJobFileFromJson(jsonElement.getAsJsonObject()));
                }
                return jobFiles;
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                ContentType contentType = ContentType.get((HttpEntity)entity);
                String mimeType = contentType.getMimeType();
                if (mimeType.equals(ContentType.APPLICATION_JSON.getMimeType())) {
                    JsonObject jsonResponse = ResponseUtils.getEntityAsJsonObject((HttpResponse)response);
                    if (statusCode == 400) {
                        if (jsonResponse.has("message")) {
                            String zosmfMessage = jsonResponse.get("message").getAsString();
                            if (String.format("No job found for reference: '%s(%s)'", jobName, jobId).equals(zosmfMessage)) {
                                throw new JobNameNotFoundException(jobName, jobId);
                            }
                            throw new BadRequestException(zosmfMessage);
                        }
                        throw new BadRequestException(jsonResponse.toString());
                    }
                    if (statusCode == 500) {
                        if (jsonResponse.has("message")) {
                            String zosmfMessage = jsonResponse.get("message").getAsString();
                            if (String.format("Failed to lookup job %s(%s)", jobName, jobId).equals(zosmfMessage)) {
                                throw new JobIdNotFoundException(jobName, jobId);
                            }
                            throw new BadRequestException(zosmfMessage);
                        }
                        throw new BadRequestException(jsonResponse.toString());
                    }
                    if (jsonResponse.has("message")) {
                        String zosmfMessage = jsonResponse.get("message").getAsString();
                        throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), zosmfMessage, new Object[0]);
                    }
                    throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), jsonResponse.toString(), new Object[0]);
                }
                throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), entity.toString(), new Object[0]);
            }
            throw new NoZosmfResponseEntityException(this.getSpringHttpStatusFromCode(statusCode), urlPath);
        }
        catch (IOException | URISyntaxException e) {
            log.error("getJob", (Throwable)e);
            throw new ServerErrorException((Throwable)e);
        }
    }

    @Override
    public JobFileContent getJobFileContent(String jobName, String jobId, String fileId) {
        String urlPath = String.format("restjobs/jobs/%s/%s/files/%s/records", jobName, jobId, fileId);
        try {
            URI requestUrl = this.zosmfconnector.getFullUrl(urlPath);
            HttpResponse response = this.zosmfconnector.request(RequestBuilder.get((URI)requestUrl));
            int statusCode = ResponseUtils.getStatus((HttpResponse)response);
            if (statusCode == 200) {
                return new JobFileContent(ResponseUtils.getEntity((HttpResponse)response));
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                ContentType contentType = ContentType.get((HttpEntity)entity);
                String mimeType = contentType.getMimeType();
                if (mimeType.equals(ContentType.APPLICATION_JSON.getMimeType())) {
                    JsonObject jsonResponse = ResponseUtils.getEntityAsJsonObject((HttpResponse)response);
                    if (statusCode == 400) {
                        if (jsonResponse.has("message")) {
                            String zosmfMessage = jsonResponse.get("message").getAsString();
                            if (String.format("No job found for reference: '%s(%s)'", jobName, jobId).equals(zosmfMessage)) {
                                throw new JobNameNotFoundException(jobName, jobId);
                            }
                            if (String.format("Job '%s(%s)' does not contain spool file id %s", jobName, jobId, fileId).equals(zosmfMessage)) {
                                throw new JobFileIdNotFoundException(jobName, jobId, fileId);
                            }
                            throw new BadRequestException(zosmfMessage);
                        }
                        throw new BadRequestException(jsonResponse.toString());
                    }
                    if (statusCode == 500) {
                        if (jsonResponse.has("message")) {
                            String zosmfMessage = jsonResponse.get("message").getAsString();
                            if (String.format("Failed to lookup job %s(%s)", jobName, jobId).equals(zosmfMessage)) {
                                throw new JobIdNotFoundException(jobName, jobId);
                            }
                            throw new BadRequestException(zosmfMessage);
                        }
                        throw new BadRequestException(jsonResponse.toString());
                    }
                    if (jsonResponse.has("message")) {
                        String zosmfMessage = jsonResponse.get("message").getAsString();
                        throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), zosmfMessage, new Object[0]);
                    }
                    throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), jsonResponse.toString(), new Object[0]);
                }
                throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), entity.toString(), new Object[0]);
            }
            throw new NoZosmfResponseEntityException(this.getSpringHttpStatusFromCode(statusCode), urlPath);
        }
        catch (IOException | URISyntaxException e) {
            log.error("getJobFileContent", (Throwable)e);
            throw new ServerErrorException((Throwable)e);
        }
    }

    @Override
    public JobFileContent getJobJcl(String jobName, String jobId) {
        try {
            return this.getJobFileContent(jobName, jobId, "3");
        }
        catch (JobFileIdNotFoundException e) {
            log.error("getJobJcl", (Throwable)((Object)e));
            throw new JobJesjclNotFoundException(jobName, jobId);
        }
    }

    private static Job getJobFromJson(JsonObject returned) {
        return Job.builder().jobId(returned.get("jobid").getAsString()).jobName(returned.get("jobname").getAsString()).owner(returned.get("owner").getAsString()).type(returned.get("type").getAsString()).status(JobStatus.valueOf((String)returned.get("status").getAsString())).returnCode(ZosmfJobsService.getStringOrNull(returned, "retcode")).subsystem(returned.get("subsystem").getAsString()).executionClass(returned.get("class").getAsString()).phaseName(returned.get("phase-name").getAsString()).build();
    }

    private static JobFile getJobFileFromJson(JsonObject returned) {
        return JobFile.builder().id(Long.valueOf(returned.get("id").getAsLong())).ddName(returned.get("ddname").getAsString()).recordFormat(returned.get("recfm").getAsString()).recordLength(Long.valueOf(returned.get("lrecl").getAsLong())).byteCount(Long.valueOf(returned.get("byte-count").getAsLong())).recordCount(Long.valueOf(returned.get("record-count").getAsLong())).build();
    }

    private static String getStringOrNull(JsonObject json, String key) {
        String value = null;
        JsonElement jsonElement = json.get(key);
        if (!jsonElement.isJsonNull()) {
            value = jsonElement.getAsString();
        }
        return value;
    }

    private HttpStatus getSpringHttpStatusFromCode(int statusCode) {
        return HttpStatus.resolve((int)statusCode);
    }
}

