/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.data.sets.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.zowe.data.sets.model.AllocationUnitType;
import org.zowe.data.sets.model.DataSetOrganisationType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Schema(title="DataSetCreateRequest", description="Attributes of a data set to be created")
public class DataSetCreateRequest {
    @Schema(description="Data set name", required=true, example="HLQ.ZOWE")
    private String name;
    @Schema(description="Volume serial", required=false, example="zmf046")
    private String volumeSerial;
    @Schema(description="Device type, unit", required=false, example="3390")
    private String deviceType;
    @Schema(description="Data set organization", required=true, example="PO")
    private DataSetOrganisationType dataSetOrganization;
    @Schema(description="Unit of space allocation, alcunit, spaceu", required=true, example="TRACK")
    private AllocationUnitType allocationUnit;
    @Schema(description="Primary space allocation", required=true, example="10")
    private Integer primary;
    @Schema(description="Secondary space allocation", required=true, example="5")
    private Integer secondary;
    @Schema(description="Number of directory blocks, dirblk. Only valid for partitioned data sets", required=false, example="5")
    private Integer directoryBlocks;
    @Schema(description="Average block", required=false, example="500")
    private Integer averageBlock;
    @Schema(description="Record format, recfm", required=true, example="FB")
    private String recordFormat;
    @Schema(description="Block size, blksize", example="400")
    private Integer blockSize;
    @Schema(description="Record length, lrecl", required=true, example="80")
    private Integer recordLength;

    @Generated
    public static DataSetCreateRequestBuilder builder() {
        return new DataSetCreateRequestBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getVolumeSerial() {
        return this.volumeSerial;
    }

    @Generated
    public String getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public DataSetOrganisationType getDataSetOrganization() {
        return this.dataSetOrganization;
    }

    @Generated
    public AllocationUnitType getAllocationUnit() {
        return this.allocationUnit;
    }

    @Generated
    public Integer getPrimary() {
        return this.primary;
    }

    @Generated
    public Integer getSecondary() {
        return this.secondary;
    }

    @Generated
    public Integer getDirectoryBlocks() {
        return this.directoryBlocks;
    }

    @Generated
    public Integer getAverageBlock() {
        return this.averageBlock;
    }

    @Generated
    public String getRecordFormat() {
        return this.recordFormat;
    }

    @Generated
    public Integer getBlockSize() {
        return this.blockSize;
    }

    @Generated
    public Integer getRecordLength() {
        return this.recordLength;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setVolumeSerial(String volumeSerial) {
        this.volumeSerial = volumeSerial;
    }

    @Generated
    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    @Generated
    public void setDataSetOrganization(DataSetOrganisationType dataSetOrganization) {
        this.dataSetOrganization = dataSetOrganization;
    }

    @Generated
    public void setAllocationUnit(AllocationUnitType allocationUnit) {
        this.allocationUnit = allocationUnit;
    }

    @Generated
    public void setPrimary(Integer primary) {
        this.primary = primary;
    }

    @Generated
    public void setSecondary(Integer secondary) {
        this.secondary = secondary;
    }

    @Generated
    public void setDirectoryBlocks(Integer directoryBlocks) {
        this.directoryBlocks = directoryBlocks;
    }

    @Generated
    public void setAverageBlock(Integer averageBlock) {
        this.averageBlock = averageBlock;
    }

    @Generated
    public void setRecordFormat(String recordFormat) {
        this.recordFormat = recordFormat;
    }

    @Generated
    public void setBlockSize(Integer blockSize) {
        this.blockSize = blockSize;
    }

    @Generated
    public void setRecordLength(Integer recordLength) {
        this.recordLength = recordLength;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSetCreateRequest)) {
            return false;
        }
        DataSetCreateRequest other = (DataSetCreateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$primary = this.getPrimary();
        Integer other$primary = other.getPrimary();
        if (this$primary == null ? other$primary != null : !((Object)this$primary).equals(other$primary)) {
            return false;
        }
        Integer this$secondary = this.getSecondary();
        Integer other$secondary = other.getSecondary();
        if (this$secondary == null ? other$secondary != null : !((Object)this$secondary).equals(other$secondary)) {
            return false;
        }
        Integer this$directoryBlocks = this.getDirectoryBlocks();
        Integer other$directoryBlocks = other.getDirectoryBlocks();
        if (this$directoryBlocks == null ? other$directoryBlocks != null : !((Object)this$directoryBlocks).equals(other$directoryBlocks)) {
            return false;
        }
        Integer this$averageBlock = this.getAverageBlock();
        Integer other$averageBlock = other.getAverageBlock();
        if (this$averageBlock == null ? other$averageBlock != null : !((Object)this$averageBlock).equals(other$averageBlock)) {
            return false;
        }
        Integer this$blockSize = this.getBlockSize();
        Integer other$blockSize = other.getBlockSize();
        if (this$blockSize == null ? other$blockSize != null : !((Object)this$blockSize).equals(other$blockSize)) {
            return false;
        }
        Integer this$recordLength = this.getRecordLength();
        Integer other$recordLength = other.getRecordLength();
        if (this$recordLength == null ? other$recordLength != null : !((Object)this$recordLength).equals(other$recordLength)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$volumeSerial = this.getVolumeSerial();
        String other$volumeSerial = other.getVolumeSerial();
        if (this$volumeSerial == null ? other$volumeSerial != null : !this$volumeSerial.equals(other$volumeSerial)) {
            return false;
        }
        String this$deviceType = this.getDeviceType();
        String other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType)) {
            return false;
        }
        DataSetOrganisationType this$dataSetOrganization = this.getDataSetOrganization();
        DataSetOrganisationType other$dataSetOrganization = other.getDataSetOrganization();
        if (this$dataSetOrganization == null ? other$dataSetOrganization != null : !((Object)((Object)this$dataSetOrganization)).equals((Object)other$dataSetOrganization)) {
            return false;
        }
        AllocationUnitType this$allocationUnit = this.getAllocationUnit();
        AllocationUnitType other$allocationUnit = other.getAllocationUnit();
        if (this$allocationUnit == null ? other$allocationUnit != null : !((Object)((Object)this$allocationUnit)).equals((Object)other$allocationUnit)) {
            return false;
        }
        String this$recordFormat = this.getRecordFormat();
        String other$recordFormat = other.getRecordFormat();
        return !(this$recordFormat == null ? other$recordFormat != null : !this$recordFormat.equals(other$recordFormat));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataSetCreateRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $primary = this.getPrimary();
        result = result * 59 + ($primary == null ? 43 : ((Object)$primary).hashCode());
        Integer $secondary = this.getSecondary();
        result = result * 59 + ($secondary == null ? 43 : ((Object)$secondary).hashCode());
        Integer $directoryBlocks = this.getDirectoryBlocks();
        result = result * 59 + ($directoryBlocks == null ? 43 : ((Object)$directoryBlocks).hashCode());
        Integer $averageBlock = this.getAverageBlock();
        result = result * 59 + ($averageBlock == null ? 43 : ((Object)$averageBlock).hashCode());
        Integer $blockSize = this.getBlockSize();
        result = result * 59 + ($blockSize == null ? 43 : ((Object)$blockSize).hashCode());
        Integer $recordLength = this.getRecordLength();
        result = result * 59 + ($recordLength == null ? 43 : ((Object)$recordLength).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $volumeSerial = this.getVolumeSerial();
        result = result * 59 + ($volumeSerial == null ? 43 : $volumeSerial.hashCode());
        String $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
        DataSetOrganisationType $dataSetOrganization = this.getDataSetOrganization();
        result = result * 59 + ($dataSetOrganization == null ? 43 : ((Object)((Object)$dataSetOrganization)).hashCode());
        AllocationUnitType $allocationUnit = this.getAllocationUnit();
        result = result * 59 + ($allocationUnit == null ? 43 : ((Object)((Object)$allocationUnit)).hashCode());
        String $recordFormat = this.getRecordFormat();
        result = result * 59 + ($recordFormat == null ? 43 : $recordFormat.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DataSetCreateRequest(name=" + this.getName() + ", volumeSerial=" + this.getVolumeSerial() + ", deviceType=" + this.getDeviceType() + ", dataSetOrganization=" + (Object)((Object)this.getDataSetOrganization()) + ", allocationUnit=" + (Object)((Object)this.getAllocationUnit()) + ", primary=" + this.getPrimary() + ", secondary=" + this.getSecondary() + ", directoryBlocks=" + this.getDirectoryBlocks() + ", averageBlock=" + this.getAverageBlock() + ", recordFormat=" + this.getRecordFormat() + ", blockSize=" + this.getBlockSize() + ", recordLength=" + this.getRecordLength() + ")";
    }

    @Generated
    public DataSetCreateRequest() {
    }

    @Generated
    public DataSetCreateRequest(String name, String volumeSerial, String deviceType, DataSetOrganisationType dataSetOrganization, AllocationUnitType allocationUnit, Integer primary, Integer secondary, Integer directoryBlocks, Integer averageBlock, String recordFormat, Integer blockSize, Integer recordLength) {
        this.name = name;
        this.volumeSerial = volumeSerial;
        this.deviceType = deviceType;
        this.dataSetOrganization = dataSetOrganization;
        this.allocationUnit = allocationUnit;
        this.primary = primary;
        this.secondary = secondary;
        this.directoryBlocks = directoryBlocks;
        this.averageBlock = averageBlock;
        this.recordFormat = recordFormat;
        this.blockSize = blockSize;
        this.recordLength = recordLength;
    }

    @Generated
    public static class DataSetCreateRequestBuilder {
        @Generated
        private String name;
        @Generated
        private String volumeSerial;
        @Generated
        private String deviceType;
        @Generated
        private DataSetOrganisationType dataSetOrganization;
        @Generated
        private AllocationUnitType allocationUnit;
        @Generated
        private Integer primary;
        @Generated
        private Integer secondary;
        @Generated
        private Integer directoryBlocks;
        @Generated
        private Integer averageBlock;
        @Generated
        private String recordFormat;
        @Generated
        private Integer blockSize;
        @Generated
        private Integer recordLength;

        @Generated
        DataSetCreateRequestBuilder() {
        }

        @Generated
        public DataSetCreateRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public DataSetCreateRequestBuilder volumeSerial(String volumeSerial) {
            this.volumeSerial = volumeSerial;
            return this;
        }

        @Generated
        public DataSetCreateRequestBuilder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        @Generated
        public DataSetCreateRequestBuilder dataSetOrganization(DataSetOrganisationType dataSetOrganization) {
            this.dataSetOrganization = dataSetOrganization;
            return this;
        }

        @Generated
        public DataSetCreateRequestBuilder allocationUnit(AllocationUnitType allocationUnit) {
            this.allocationUnit = allocationUnit;
            return this;
        }

        @Generated
        public DataSetCreateRequestBuilder primary(Integer primary) {
            this.primary = primary;
            return this;
        }

        @Generated
        public DataSetCreateRequestBuilder secondary(Integer secondary) {
            this.secondary = secondary;
            return this;
        }

        @Generated
        public DataSetCreateRequestBuilder directoryBlocks(Integer directoryBlocks) {
            this.directoryBlocks = directoryBlocks;
            return this;
        }

        @Generated
        public DataSetCreateRequestBuilder averageBlock(Integer averageBlock) {
            this.averageBlock = averageBlock;
            return this;
        }

        @Generated
        public DataSetCreateRequestBuilder recordFormat(String recordFormat) {
            this.recordFormat = recordFormat;
            return this;
        }

        @Generated
        public DataSetCreateRequestBuilder blockSize(Integer blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        @Generated
        public DataSetCreateRequestBuilder recordLength(Integer recordLength) {
            this.recordLength = recordLength;
            return this;
        }

        @Generated
        public DataSetCreateRequest build() {
            return new DataSetCreateRequest(this.name, this.volumeSerial, this.deviceType, this.dataSetOrganization, this.allocationUnit, this.primary, this.secondary, this.directoryBlocks, this.averageBlock, this.recordFormat, this.blockSize, this.recordLength);
        }

        @Generated
        public String toString() {
            return "DataSetCreateRequest.DataSetCreateRequestBuilder(name=" + this.name + ", volumeSerial=" + this.volumeSerial + ", deviceType=" + this.deviceType + ", dataSetOrganization=" + (Object)((Object)this.dataSetOrganization) + ", allocationUnit=" + (Object)((Object)this.allocationUnit) + ", primary=" + this.primary + ", secondary=" + this.secondary + ", directoryBlocks=" + this.directoryBlocks + ", averageBlock=" + this.averageBlock + ", recordFormat=" + this.recordFormat + ", blockSize=" + this.blockSize + ", recordLength=" + this.recordLength + ")";
        }
    }
}

