/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.unix.files.services;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.zowe.unix.files.model.UnixCreateAssetRequest;
import org.zowe.unix.files.model.UnixDirectoryAttributesWithChildren;
import org.zowe.unix.files.model.UnixFileContentWithETag;

public abstract class UnixFilesService {
    private HttpServletRequest request;

    public List<Header> getIbmHeadersFromRequest() {
        ArrayList<Header> ibmHeaders = new ArrayList<Header>();
        if (this.request != null) {
            Enumeration headerNames = this.request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = ((String)headerNames.nextElement()).toUpperCase();
                if (!headerName.contains("X-IBM")) continue;
                BasicHeader newHeader = new BasicHeader(headerName, this.request.getHeader(headerName));
                ibmHeaders.add((Header)newHeader);
            }
        }
        return ibmHeaders;
    }

    public abstract UnixDirectoryAttributesWithChildren listUnixDirectory(String var1, String var2);

    public abstract UnixFileContentWithETag getUnixFileContentWithETag(String var1, boolean var2, boolean var3);

    public abstract String putUnixFileContent(String var1, UnixFileContentWithETag var2, boolean var3);

    public abstract boolean shouldUnixFileConvert(String var1);

    public abstract String getUnixFileChtag(String var1);

    public abstract void deleteUnixFileContent(String var1, boolean var2);

    public abstract void createUnixAsset(String var1, UnixCreateAssetRequest var2);

    @Generated
    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }
}

