/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.data.sets.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.net.URI;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.zowe.api.common.model.ItemsWrapper;
import org.zowe.data.sets.model.DataSet;
import org.zowe.data.sets.model.DataSetAttributes;
import org.zowe.data.sets.model.DataSetContent;
import org.zowe.data.sets.model.DataSetContentWithEtag;
import org.zowe.data.sets.model.DataSetCreateRequest;
import org.zowe.data.sets.model.DataSetRenameRequest;
import org.zowe.data.sets.services.DataSetService;

public abstract class AbstractDataSetsController {
    abstract DataSetService getDataSetService();

    @GetMapping(value={"{dataSetName}/members"}, produces={"application/json"})
    @Operation(summary="Get a list of members for a partitioned data set", operationId="getMembers", description="This API returns a list of members for a given partitioned data set.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok")})
    public ItemsWrapper<String> getMembers(@Parameter(description="Partitioned data set name", required=true) @PathVariable String dataSetName) {
        return this.getDataSetService().listDataSetMembers(dataSetName);
    }

    @GetMapping(value={"{filter:.+}"}, produces={"application/json"})
    @Operation(summary="Get a list of data sets matching the filter", operationId="getDataSetAttributes", description="This API returns the attributes of data sets matching the filter")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok")})
    public ItemsWrapper<DataSetAttributes> getDataSetAttributes(@Parameter(description="Dataset filter string, e.g. HLQ.\\*\\*, \\*\\*.SUF, etc.", required=true) @PathVariable String filter) {
        return this.getDataSetService().listDataSetAttributes(filter);
    }

    @GetMapping(value={"{filter:.+}/list"}, produces={"application/json"})
    @Operation(summary="Get a list of data sets without attributes matching the filter", operationId="getDataSets", description="This API returns the list of data sets matching the filter")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok")})
    public ItemsWrapper<DataSet> getDataSets(@Parameter(description="Dataset filter string, e.g. HLQ.\\*\\*, \\*\\*.SUF, etc.", required=true) @PathVariable String filter) {
        return this.getDataSetService().listDataSets(filter);
    }

    @GetMapping(value={"{dataSetName}/content"}, produces={"application/json"})
    @Operation(summary="Get the content of a sequential data set, or PDS member", operationId="getContent", description="This API reads content from a sequential data set or member of a partitioned data set.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok")})
    public ResponseEntity<DataSetContent> getContent(@Parameter(description="Data set name, e.g. HLQ.PS or HLQ.PO(MEMBER)", required=true) @PathVariable String dataSetName, @RequestHeader(value="X-Return-Etag", required=false) String etagHeader) {
        DataSetContentWithEtag content = this.getDataSetService().getContent(dataSetName);
        HttpHeaders headers = new HttpHeaders();
        if ("true".equalsIgnoreCase(etagHeader)) {
            headers.add("Access-Control-Expose-Headers", "ETag");
            headers.add("ETag", content.getEtag());
        }
        return new ResponseEntity((Object)content.getContent(), (MultiValueMap)headers, HttpStatus.OK);
    }

    @PostMapping(value={"/"}, consumes={"application/json"})
    @Operation(summary="Create a data set", description="This creates a data set based on the attributes passed in")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Data set successfully created")})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<?> createDataSet(@RequestBody DataSetCreateRequest input) {
        String dataSetName = this.getDataSetService().createDataSet(input);
        URI location = ServletUriComponentsBuilder.fromCurrentRequest().path("/{dataSetName}").buildAndExpand(new Object[]{dataSetName}).toUri();
        return ResponseEntity.created((URI)location).build();
    }

    @PutMapping(value={"{dataSetName}/content"}, produces={"application/json"})
    @Operation(summary="Sets the content of a sequential data set, or PDS member", operationId="putContent", description="This API writes content to a sequential data set or partitioned data set member.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok")})
    public ResponseEntity<?> putContent(@Parameter(description="Data set name, e.g. HLQ.PS or HLQ.PO(MEMBER)", required=true) @PathVariable String dataSetName, @RequestBody DataSetContent input, @RequestHeader(value="If-Match", required=false) String ifMatch, @RequestHeader(value="X-Return-Etag", required=false) String etagHeader) {
        DataSetContentWithEtag request = new DataSetContentWithEtag(input, ifMatch);
        String putEtag = this.getDataSetService().putContent(dataSetName, request);
        HttpHeaders headers = new HttpHeaders();
        if ("true".equalsIgnoreCase(etagHeader)) {
            headers.add("Access-Control-Expose-Headers", "ETag");
            headers.add("ETag", "\"" + putEtag + "\"");
        }
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.NO_CONTENT);
    }

    @PutMapping(value={"{oldDataSetName}/rename"}, produces={"application/json"})
    @Operation(summary="Rename of a sequential data set, or PDS member", operationId="renameContent", description="This API renames data set or partitioned data set member.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ok")})
    public ResponseEntity<Void> putRename(@Parameter(description="Data set name, e.g. HLQ.PS or HLQ.PO(MEMBER)", required=true) @PathVariable String oldDataSetName, @RequestBody DataSetRenameRequest input) {
        this.getDataSetService().renameDataSet(oldDataSetName, input);
        return ResponseEntity.noContent().build();
    }

    @DeleteMapping(value={"{dataSetName:.+}"})
    @Operation(summary="Delete a data set or member", description="This API deletes a data set or data set member.")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Data set or member successfully deleted")})
    public ResponseEntity<?> deleteDatasetMember(@Parameter(description="Data set name", required=true) @PathVariable String dataSetName) {
        this.getDataSetService().deleteDataSet(dataSetName);
        return ResponseEntity.noContent().build();
    }
}

