/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.unix.files.services.zosmf;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.apache.http.Header;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.zosmf.services.AbstractZosmfRequestRunner;
import org.zowe.unix.files.exceptions.FileNotFoundException;
import org.zowe.unix.files.exceptions.UnauthorisedFileException;

public abstract class AbstractZosmfUnixFilesRequestRunner<T>
extends AbstractZosmfRequestRunner<T> {
    public AbstractZosmfUnixFilesRequestRunner(List<Header> headers) {
        super(headers);
    }

    protected ZoweApiRestException createUnixFileException(JsonObject jsonResponse, int statusCode, String path) {
        JsonElement details = jsonResponse.get("details");
        if (null != details) {
            if (statusCode == 500) {
                if (details.toString().contains("EDC5111I Permission denied.")) {
                    throw new UnauthorisedFileException(path);
                }
            } else if (statusCode == 404 && details.toString().contains("EDC5129I No such file or directory.")) {
                throw new FileNotFoundException(path);
            }
        }
        return null;
    }
}

