/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.data.sets.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.zowe.data.sets.model.DataSetCreateRequest;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ZosmfCreateRequest {
    private String volser;
    private String unit;
    private String dsorg;
    private String alcunit;
    private Integer primary;
    private Integer secondary;
    private Integer dirblk;
    private Integer avgblk;
    private String recfm;
    private Integer blksize;
    private Integer lrecl;

    public static ZosmfCreateRequest createFromDataSetCreateRequest(DataSetCreateRequest request) {
        ZosmfCreateRequestBuilder builder = ZosmfCreateRequest.builder().volser(request.getVolumeSerial()).unit(request.getDeviceType()).dsorg(request.getDataSetOrganization().getZosmfName()).primary(request.getPrimary()).secondary(request.getSecondary()).dirblk(request.getDirectoryBlocks()).avgblk(request.getAverageBlock()).recfm(request.getRecordFormat()).blksize(request.getBlockSize()).lrecl(request.getRecordLength());
        switch (request.getAllocationUnit()) {
            case TRACK: {
                builder.alcunit("TRK");
                break;
            }
            case CYLINDER: {
                builder.alcunit("CYL");
                break;
            }
            default: {
                throw new IllegalArgumentException("Creating data sets with a z/OS MF connector only supports allocation unit type of track and cylinder");
            }
        }
        return builder.build();
    }

    public static ZosmfCreateRequestBuilder builder() {
        return new ZosmfCreateRequestBuilder();
    }

    public String getVolser() {
        return this.volser;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getDsorg() {
        return this.dsorg;
    }

    public String getAlcunit() {
        return this.alcunit;
    }

    public Integer getPrimary() {
        return this.primary;
    }

    public Integer getSecondary() {
        return this.secondary;
    }

    public Integer getDirblk() {
        return this.dirblk;
    }

    public Integer getAvgblk() {
        return this.avgblk;
    }

    public String getRecfm() {
        return this.recfm;
    }

    public Integer getBlksize() {
        return this.blksize;
    }

    public Integer getLrecl() {
        return this.lrecl;
    }

    public void setVolser(String volser) {
        this.volser = volser;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setDsorg(String dsorg) {
        this.dsorg = dsorg;
    }

    public void setAlcunit(String alcunit) {
        this.alcunit = alcunit;
    }

    public void setPrimary(Integer primary) {
        this.primary = primary;
    }

    public void setSecondary(Integer secondary) {
        this.secondary = secondary;
    }

    public void setDirblk(Integer dirblk) {
        this.dirblk = dirblk;
    }

    public void setAvgblk(Integer avgblk) {
        this.avgblk = avgblk;
    }

    public void setRecfm(String recfm) {
        this.recfm = recfm;
    }

    public void setBlksize(Integer blksize) {
        this.blksize = blksize;
    }

    public void setLrecl(Integer lrecl) {
        this.lrecl = lrecl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZosmfCreateRequest)) {
            return false;
        }
        ZosmfCreateRequest other = (ZosmfCreateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$volser = this.getVolser();
        String other$volser = other.getVolser();
        if (this$volser == null ? other$volser != null : !this$volser.equals(other$volser)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        String this$dsorg = this.getDsorg();
        String other$dsorg = other.getDsorg();
        if (this$dsorg == null ? other$dsorg != null : !this$dsorg.equals(other$dsorg)) {
            return false;
        }
        String this$alcunit = this.getAlcunit();
        String other$alcunit = other.getAlcunit();
        if (this$alcunit == null ? other$alcunit != null : !this$alcunit.equals(other$alcunit)) {
            return false;
        }
        Integer this$primary = this.getPrimary();
        Integer other$primary = other.getPrimary();
        if (this$primary == null ? other$primary != null : !((Object)this$primary).equals(other$primary)) {
            return false;
        }
        Integer this$secondary = this.getSecondary();
        Integer other$secondary = other.getSecondary();
        if (this$secondary == null ? other$secondary != null : !((Object)this$secondary).equals(other$secondary)) {
            return false;
        }
        Integer this$dirblk = this.getDirblk();
        Integer other$dirblk = other.getDirblk();
        if (this$dirblk == null ? other$dirblk != null : !((Object)this$dirblk).equals(other$dirblk)) {
            return false;
        }
        Integer this$avgblk = this.getAvgblk();
        Integer other$avgblk = other.getAvgblk();
        if (this$avgblk == null ? other$avgblk != null : !((Object)this$avgblk).equals(other$avgblk)) {
            return false;
        }
        String this$recfm = this.getRecfm();
        String other$recfm = other.getRecfm();
        if (this$recfm == null ? other$recfm != null : !this$recfm.equals(other$recfm)) {
            return false;
        }
        Integer this$blksize = this.getBlksize();
        Integer other$blksize = other.getBlksize();
        if (this$blksize == null ? other$blksize != null : !((Object)this$blksize).equals(other$blksize)) {
            return false;
        }
        Integer this$lrecl = this.getLrecl();
        Integer other$lrecl = other.getLrecl();
        return !(this$lrecl == null ? other$lrecl != null : !((Object)this$lrecl).equals(other$lrecl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZosmfCreateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $volser = this.getVolser();
        result = result * 59 + ($volser == null ? 43 : $volser.hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        String $dsorg = this.getDsorg();
        result = result * 59 + ($dsorg == null ? 43 : $dsorg.hashCode());
        String $alcunit = this.getAlcunit();
        result = result * 59 + ($alcunit == null ? 43 : $alcunit.hashCode());
        Integer $primary = this.getPrimary();
        result = result * 59 + ($primary == null ? 43 : ((Object)$primary).hashCode());
        Integer $secondary = this.getSecondary();
        result = result * 59 + ($secondary == null ? 43 : ((Object)$secondary).hashCode());
        Integer $dirblk = this.getDirblk();
        result = result * 59 + ($dirblk == null ? 43 : ((Object)$dirblk).hashCode());
        Integer $avgblk = this.getAvgblk();
        result = result * 59 + ($avgblk == null ? 43 : ((Object)$avgblk).hashCode());
        String $recfm = this.getRecfm();
        result = result * 59 + ($recfm == null ? 43 : $recfm.hashCode());
        Integer $blksize = this.getBlksize();
        result = result * 59 + ($blksize == null ? 43 : ((Object)$blksize).hashCode());
        Integer $lrecl = this.getLrecl();
        result = result * 59 + ($lrecl == null ? 43 : ((Object)$lrecl).hashCode());
        return result;
    }

    public String toString() {
        return "ZosmfCreateRequest(volser=" + this.getVolser() + ", unit=" + this.getUnit() + ", dsorg=" + this.getDsorg() + ", alcunit=" + this.getAlcunit() + ", primary=" + this.getPrimary() + ", secondary=" + this.getSecondary() + ", dirblk=" + this.getDirblk() + ", avgblk=" + this.getAvgblk() + ", recfm=" + this.getRecfm() + ", blksize=" + this.getBlksize() + ", lrecl=" + this.getLrecl() + ")";
    }

    public ZosmfCreateRequest() {
    }

    public ZosmfCreateRequest(String volser, String unit, String dsorg, String alcunit, Integer primary, Integer secondary, Integer dirblk, Integer avgblk, String recfm, Integer blksize, Integer lrecl) {
        this.volser = volser;
        this.unit = unit;
        this.dsorg = dsorg;
        this.alcunit = alcunit;
        this.primary = primary;
        this.secondary = secondary;
        this.dirblk = dirblk;
        this.avgblk = avgblk;
        this.recfm = recfm;
        this.blksize = blksize;
        this.lrecl = lrecl;
    }

    public static class ZosmfCreateRequestBuilder {
        private String volser;
        private String unit;
        private String dsorg;
        private String alcunit;
        private Integer primary;
        private Integer secondary;
        private Integer dirblk;
        private Integer avgblk;
        private String recfm;
        private Integer blksize;
        private Integer lrecl;

        ZosmfCreateRequestBuilder() {
        }

        public ZosmfCreateRequestBuilder volser(String volser) {
            this.volser = volser;
            return this;
        }

        public ZosmfCreateRequestBuilder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public ZosmfCreateRequestBuilder dsorg(String dsorg) {
            this.dsorg = dsorg;
            return this;
        }

        public ZosmfCreateRequestBuilder alcunit(String alcunit) {
            this.alcunit = alcunit;
            return this;
        }

        public ZosmfCreateRequestBuilder primary(Integer primary) {
            this.primary = primary;
            return this;
        }

        public ZosmfCreateRequestBuilder secondary(Integer secondary) {
            this.secondary = secondary;
            return this;
        }

        public ZosmfCreateRequestBuilder dirblk(Integer dirblk) {
            this.dirblk = dirblk;
            return this;
        }

        public ZosmfCreateRequestBuilder avgblk(Integer avgblk) {
            this.avgblk = avgblk;
            return this;
        }

        public ZosmfCreateRequestBuilder recfm(String recfm) {
            this.recfm = recfm;
            return this;
        }

        public ZosmfCreateRequestBuilder blksize(Integer blksize) {
            this.blksize = blksize;
            return this;
        }

        public ZosmfCreateRequestBuilder lrecl(Integer lrecl) {
            this.lrecl = lrecl;
            return this;
        }

        public ZosmfCreateRequest build() {
            return new ZosmfCreateRequest(this.volser, this.unit, this.dsorg, this.alcunit, this.primary, this.secondary, this.dirblk, this.avgblk, this.recfm, this.blksize, this.lrecl);
        }

        public String toString() {
            return "ZosmfCreateRequest.ZosmfCreateRequestBuilder(volser=" + this.volser + ", unit=" + this.unit + ", dsorg=" + this.dsorg + ", alcunit=" + this.alcunit + ", primary=" + this.primary + ", secondary=" + this.secondary + ", dirblk=" + this.dirblk + ", avgblk=" + this.avgblk + ", recfm=" + this.recfm + ", blksize=" + this.blksize + ", lrecl=" + this.lrecl + ")";
        }
    }
}

