/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.data.sets.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.zowe.data.sets.model.AllocationUnitType;
import org.zowe.data.sets.model.DataSetOrganisationType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@ApiModel(value="DataSetAttributes", description="Attributes of a data set")
public class DataSetAttributes {
    @ApiModelProperty(value="Data set name", required=true)
    private String name;
    @ApiModelProperty(value="Volume serial")
    private String volumeSerial;
    @ApiModelProperty(value="Device type")
    private String deviceType;
    @ApiModelProperty(value="Data set organization", dataType="string")
    private DataSetOrganisationType dataSetOrganization;
    @ApiModelProperty(value="Unit of space allocation, alcunit, spaceu", dataType="string")
    private AllocationUnitType allocationUnit;
    @ApiModelProperty(value="Primary space allocation")
    private Integer primary;
    @ApiModelProperty(value="Secondary space allocation")
    private Integer secondary;
    @ApiModelProperty(value="Number of directory blocks, dirblk")
    private Integer directoryBlocks;
    @ApiModelProperty(value="Average block")
    private Integer averageBlock;
    @ApiModelProperty(value="Record format, recfm", required=true)
    private String recordFormat;
    @ApiModelProperty(value="Block size, blksize")
    private Integer blockSize;
    @ApiModelProperty(value="Record length, lrecl", required=true)
    private Integer recordLength;
    @ApiModelProperty(value="Allocate size, sizex")
    private Integer allocatedSize;
    @ApiModelProperty(value="Percentage of allocation used")
    private Integer used;
    @ApiModelProperty(value="Whether the data set is migrated")
    private Boolean migrated;
    @ApiModelProperty(value="Catalog name, catnm")
    private String catalogName;
    @ApiModelProperty(value="Creation date, cdate")
    private String creationDate;
    @ApiModelProperty(value="Expiration date, edate")
    private String expirationDate;

    public static DataSetAttributesBuilder builder() {
        return new DataSetAttributesBuilder();
    }

    public DataSetAttributesBuilder toBuilder() {
        return new DataSetAttributesBuilder().name(this.name).volumeSerial(this.volumeSerial).deviceType(this.deviceType).dataSetOrganization(this.dataSetOrganization).allocationUnit(this.allocationUnit).primary(this.primary).secondary(this.secondary).directoryBlocks(this.directoryBlocks).averageBlock(this.averageBlock).recordFormat(this.recordFormat).blockSize(this.blockSize).recordLength(this.recordLength).allocatedSize(this.allocatedSize).used(this.used).migrated(this.migrated).catalogName(this.catalogName).creationDate(this.creationDate).expirationDate(this.expirationDate);
    }

    public String getName() {
        return this.name;
    }

    public String getVolumeSerial() {
        return this.volumeSerial;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public DataSetOrganisationType getDataSetOrganization() {
        return this.dataSetOrganization;
    }

    public AllocationUnitType getAllocationUnit() {
        return this.allocationUnit;
    }

    public Integer getPrimary() {
        return this.primary;
    }

    public Integer getSecondary() {
        return this.secondary;
    }

    public Integer getDirectoryBlocks() {
        return this.directoryBlocks;
    }

    public Integer getAverageBlock() {
        return this.averageBlock;
    }

    public String getRecordFormat() {
        return this.recordFormat;
    }

    public Integer getBlockSize() {
        return this.blockSize;
    }

    public Integer getRecordLength() {
        return this.recordLength;
    }

    public Integer getAllocatedSize() {
        return this.allocatedSize;
    }

    public Integer getUsed() {
        return this.used;
    }

    public Boolean getMigrated() {
        return this.migrated;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public String getExpirationDate() {
        return this.expirationDate;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVolumeSerial(String volumeSerial) {
        this.volumeSerial = volumeSerial;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setDataSetOrganization(DataSetOrganisationType dataSetOrganization) {
        this.dataSetOrganization = dataSetOrganization;
    }

    public void setAllocationUnit(AllocationUnitType allocationUnit) {
        this.allocationUnit = allocationUnit;
    }

    public void setPrimary(Integer primary) {
        this.primary = primary;
    }

    public void setSecondary(Integer secondary) {
        this.secondary = secondary;
    }

    public void setDirectoryBlocks(Integer directoryBlocks) {
        this.directoryBlocks = directoryBlocks;
    }

    public void setAverageBlock(Integer averageBlock) {
        this.averageBlock = averageBlock;
    }

    public void setRecordFormat(String recordFormat) {
        this.recordFormat = recordFormat;
    }

    public void setBlockSize(Integer blockSize) {
        this.blockSize = blockSize;
    }

    public void setRecordLength(Integer recordLength) {
        this.recordLength = recordLength;
    }

    public void setAllocatedSize(Integer allocatedSize) {
        this.allocatedSize = allocatedSize;
    }

    public void setUsed(Integer used) {
        this.used = used;
    }

    public void setMigrated(Boolean migrated) {
        this.migrated = migrated;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public void setExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSetAttributes)) {
            return false;
        }
        DataSetAttributes other = (DataSetAttributes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$volumeSerial = this.getVolumeSerial();
        String other$volumeSerial = other.getVolumeSerial();
        if (this$volumeSerial == null ? other$volumeSerial != null : !this$volumeSerial.equals(other$volumeSerial)) {
            return false;
        }
        String this$deviceType = this.getDeviceType();
        String other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType)) {
            return false;
        }
        DataSetOrganisationType this$dataSetOrganization = this.getDataSetOrganization();
        DataSetOrganisationType other$dataSetOrganization = other.getDataSetOrganization();
        if (this$dataSetOrganization == null ? other$dataSetOrganization != null : !((Object)((Object)this$dataSetOrganization)).equals((Object)other$dataSetOrganization)) {
            return false;
        }
        AllocationUnitType this$allocationUnit = this.getAllocationUnit();
        AllocationUnitType other$allocationUnit = other.getAllocationUnit();
        if (this$allocationUnit == null ? other$allocationUnit != null : !((Object)((Object)this$allocationUnit)).equals((Object)other$allocationUnit)) {
            return false;
        }
        Integer this$primary = this.getPrimary();
        Integer other$primary = other.getPrimary();
        if (this$primary == null ? other$primary != null : !((Object)this$primary).equals(other$primary)) {
            return false;
        }
        Integer this$secondary = this.getSecondary();
        Integer other$secondary = other.getSecondary();
        if (this$secondary == null ? other$secondary != null : !((Object)this$secondary).equals(other$secondary)) {
            return false;
        }
        Integer this$directoryBlocks = this.getDirectoryBlocks();
        Integer other$directoryBlocks = other.getDirectoryBlocks();
        if (this$directoryBlocks == null ? other$directoryBlocks != null : !((Object)this$directoryBlocks).equals(other$directoryBlocks)) {
            return false;
        }
        Integer this$averageBlock = this.getAverageBlock();
        Integer other$averageBlock = other.getAverageBlock();
        if (this$averageBlock == null ? other$averageBlock != null : !((Object)this$averageBlock).equals(other$averageBlock)) {
            return false;
        }
        String this$recordFormat = this.getRecordFormat();
        String other$recordFormat = other.getRecordFormat();
        if (this$recordFormat == null ? other$recordFormat != null : !this$recordFormat.equals(other$recordFormat)) {
            return false;
        }
        Integer this$blockSize = this.getBlockSize();
        Integer other$blockSize = other.getBlockSize();
        if (this$blockSize == null ? other$blockSize != null : !((Object)this$blockSize).equals(other$blockSize)) {
            return false;
        }
        Integer this$recordLength = this.getRecordLength();
        Integer other$recordLength = other.getRecordLength();
        if (this$recordLength == null ? other$recordLength != null : !((Object)this$recordLength).equals(other$recordLength)) {
            return false;
        }
        Integer this$allocatedSize = this.getAllocatedSize();
        Integer other$allocatedSize = other.getAllocatedSize();
        if (this$allocatedSize == null ? other$allocatedSize != null : !((Object)this$allocatedSize).equals(other$allocatedSize)) {
            return false;
        }
        Integer this$used = this.getUsed();
        Integer other$used = other.getUsed();
        if (this$used == null ? other$used != null : !((Object)this$used).equals(other$used)) {
            return false;
        }
        Boolean this$migrated = this.getMigrated();
        Boolean other$migrated = other.getMigrated();
        if (this$migrated == null ? other$migrated != null : !((Object)this$migrated).equals(other$migrated)) {
            return false;
        }
        String this$catalogName = this.getCatalogName();
        String other$catalogName = other.getCatalogName();
        if (this$catalogName == null ? other$catalogName != null : !this$catalogName.equals(other$catalogName)) {
            return false;
        }
        String this$creationDate = this.getCreationDate();
        String other$creationDate = other.getCreationDate();
        if (this$creationDate == null ? other$creationDate != null : !this$creationDate.equals(other$creationDate)) {
            return false;
        }
        String this$expirationDate = this.getExpirationDate();
        String other$expirationDate = other.getExpirationDate();
        return !(this$expirationDate == null ? other$expirationDate != null : !this$expirationDate.equals(other$expirationDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSetAttributes;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $volumeSerial = this.getVolumeSerial();
        result = result * 59 + ($volumeSerial == null ? 43 : $volumeSerial.hashCode());
        String $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
        DataSetOrganisationType $dataSetOrganization = this.getDataSetOrganization();
        result = result * 59 + ($dataSetOrganization == null ? 43 : ((Object)((Object)$dataSetOrganization)).hashCode());
        AllocationUnitType $allocationUnit = this.getAllocationUnit();
        result = result * 59 + ($allocationUnit == null ? 43 : ((Object)((Object)$allocationUnit)).hashCode());
        Integer $primary = this.getPrimary();
        result = result * 59 + ($primary == null ? 43 : ((Object)$primary).hashCode());
        Integer $secondary = this.getSecondary();
        result = result * 59 + ($secondary == null ? 43 : ((Object)$secondary).hashCode());
        Integer $directoryBlocks = this.getDirectoryBlocks();
        result = result * 59 + ($directoryBlocks == null ? 43 : ((Object)$directoryBlocks).hashCode());
        Integer $averageBlock = this.getAverageBlock();
        result = result * 59 + ($averageBlock == null ? 43 : ((Object)$averageBlock).hashCode());
        String $recordFormat = this.getRecordFormat();
        result = result * 59 + ($recordFormat == null ? 43 : $recordFormat.hashCode());
        Integer $blockSize = this.getBlockSize();
        result = result * 59 + ($blockSize == null ? 43 : ((Object)$blockSize).hashCode());
        Integer $recordLength = this.getRecordLength();
        result = result * 59 + ($recordLength == null ? 43 : ((Object)$recordLength).hashCode());
        Integer $allocatedSize = this.getAllocatedSize();
        result = result * 59 + ($allocatedSize == null ? 43 : ((Object)$allocatedSize).hashCode());
        Integer $used = this.getUsed();
        result = result * 59 + ($used == null ? 43 : ((Object)$used).hashCode());
        Boolean $migrated = this.getMigrated();
        result = result * 59 + ($migrated == null ? 43 : ((Object)$migrated).hashCode());
        String $catalogName = this.getCatalogName();
        result = result * 59 + ($catalogName == null ? 43 : $catalogName.hashCode());
        String $creationDate = this.getCreationDate();
        result = result * 59 + ($creationDate == null ? 43 : $creationDate.hashCode());
        String $expirationDate = this.getExpirationDate();
        result = result * 59 + ($expirationDate == null ? 43 : $expirationDate.hashCode());
        return result;
    }

    public String toString() {
        return "DataSetAttributes(name=" + this.getName() + ", volumeSerial=" + this.getVolumeSerial() + ", deviceType=" + this.getDeviceType() + ", dataSetOrganization=" + (Object)((Object)this.getDataSetOrganization()) + ", allocationUnit=" + (Object)((Object)this.getAllocationUnit()) + ", primary=" + this.getPrimary() + ", secondary=" + this.getSecondary() + ", directoryBlocks=" + this.getDirectoryBlocks() + ", averageBlock=" + this.getAverageBlock() + ", recordFormat=" + this.getRecordFormat() + ", blockSize=" + this.getBlockSize() + ", recordLength=" + this.getRecordLength() + ", allocatedSize=" + this.getAllocatedSize() + ", used=" + this.getUsed() + ", migrated=" + this.getMigrated() + ", catalogName=" + this.getCatalogName() + ", creationDate=" + this.getCreationDate() + ", expirationDate=" + this.getExpirationDate() + ")";
    }

    public DataSetAttributes() {
    }

    public DataSetAttributes(String name, String volumeSerial, String deviceType, DataSetOrganisationType dataSetOrganization, AllocationUnitType allocationUnit, Integer primary, Integer secondary, Integer directoryBlocks, Integer averageBlock, String recordFormat, Integer blockSize, Integer recordLength, Integer allocatedSize, Integer used, Boolean migrated, String catalogName, String creationDate, String expirationDate) {
        this.name = name;
        this.volumeSerial = volumeSerial;
        this.deviceType = deviceType;
        this.dataSetOrganization = dataSetOrganization;
        this.allocationUnit = allocationUnit;
        this.primary = primary;
        this.secondary = secondary;
        this.directoryBlocks = directoryBlocks;
        this.averageBlock = averageBlock;
        this.recordFormat = recordFormat;
        this.blockSize = blockSize;
        this.recordLength = recordLength;
        this.allocatedSize = allocatedSize;
        this.used = used;
        this.migrated = migrated;
        this.catalogName = catalogName;
        this.creationDate = creationDate;
        this.expirationDate = expirationDate;
    }

    public static class DataSetAttributesBuilder {
        private String name;
        private String volumeSerial;
        private String deviceType;
        private DataSetOrganisationType dataSetOrganization;
        private AllocationUnitType allocationUnit;
        private Integer primary;
        private Integer secondary;
        private Integer directoryBlocks;
        private Integer averageBlock;
        private String recordFormat;
        private Integer blockSize;
        private Integer recordLength;
        private Integer allocatedSize;
        private Integer used;
        private Boolean migrated;
        private String catalogName;
        private String creationDate;
        private String expirationDate;

        DataSetAttributesBuilder() {
        }

        public DataSetAttributesBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DataSetAttributesBuilder volumeSerial(String volumeSerial) {
            this.volumeSerial = volumeSerial;
            return this;
        }

        public DataSetAttributesBuilder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public DataSetAttributesBuilder dataSetOrganization(DataSetOrganisationType dataSetOrganization) {
            this.dataSetOrganization = dataSetOrganization;
            return this;
        }

        public DataSetAttributesBuilder allocationUnit(AllocationUnitType allocationUnit) {
            this.allocationUnit = allocationUnit;
            return this;
        }

        public DataSetAttributesBuilder primary(Integer primary) {
            this.primary = primary;
            return this;
        }

        public DataSetAttributesBuilder secondary(Integer secondary) {
            this.secondary = secondary;
            return this;
        }

        public DataSetAttributesBuilder directoryBlocks(Integer directoryBlocks) {
            this.directoryBlocks = directoryBlocks;
            return this;
        }

        public DataSetAttributesBuilder averageBlock(Integer averageBlock) {
            this.averageBlock = averageBlock;
            return this;
        }

        public DataSetAttributesBuilder recordFormat(String recordFormat) {
            this.recordFormat = recordFormat;
            return this;
        }

        public DataSetAttributesBuilder blockSize(Integer blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public DataSetAttributesBuilder recordLength(Integer recordLength) {
            this.recordLength = recordLength;
            return this;
        }

        public DataSetAttributesBuilder allocatedSize(Integer allocatedSize) {
            this.allocatedSize = allocatedSize;
            return this;
        }

        public DataSetAttributesBuilder used(Integer used) {
            this.used = used;
            return this;
        }

        public DataSetAttributesBuilder migrated(Boolean migrated) {
            this.migrated = migrated;
            return this;
        }

        public DataSetAttributesBuilder catalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public DataSetAttributesBuilder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public DataSetAttributesBuilder expirationDate(String expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public DataSetAttributes build() {
            return new DataSetAttributes(this.name, this.volumeSerial, this.deviceType, this.dataSetOrganization, this.allocationUnit, this.primary, this.secondary, this.directoryBlocks, this.averageBlock, this.recordFormat, this.blockSize, this.recordLength, this.allocatedSize, this.used, this.migrated, this.catalogName, this.creationDate, this.expirationDate);
        }

        public String toString() {
            return "DataSetAttributes.DataSetAttributesBuilder(name=" + this.name + ", volumeSerial=" + this.volumeSerial + ", deviceType=" + this.deviceType + ", dataSetOrganization=" + (Object)((Object)this.dataSetOrganization) + ", allocationUnit=" + (Object)((Object)this.allocationUnit) + ", primary=" + this.primary + ", secondary=" + this.secondary + ", directoryBlocks=" + this.directoryBlocks + ", averageBlock=" + this.averageBlock + ", recordFormat=" + this.recordFormat + ", blockSize=" + this.blockSize + ", recordLength=" + this.recordLength + ", allocatedSize=" + this.allocatedSize + ", used=" + this.used + ", migrated=" + this.migrated + ", catalogName=" + this.catalogName + ", creationDate=" + this.creationDate + ", expirationDate=" + this.expirationDate + ")";
        }
    }
}

