/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.unix.files.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.zowe.unix.files.model.UnixDirectoryChild;
import org.zowe.unix.files.model.UnixEntityType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@ApiModel(value="UnixDirectoryAttributesWithChildren", description="Attributes of a Unix Directory with its children")
public class UnixDirectoryAttributesWithChildren {
    @ApiModelProperty(value="Type", required=true)
    private UnixEntityType type;
    @ApiModelProperty(value="Owner", required=true)
    private String owner;
    @ApiModelProperty(value="Group", required=true)
    private String group;
    @ApiModelProperty(value="Symbolic permissions", required=true)
    private String permissionsSymbolic;
    @ApiModelProperty(value="Size on disk", required=true)
    private Integer size;
    @ApiModelProperty(value="Last Modified", required=true)
    private String lastModified;
    @ApiModelProperty(value="Children", required=true)
    private List<UnixDirectoryChild> children;

    public static UnixDirectoryAttributesWithChildrenBuilder builder() {
        return new UnixDirectoryAttributesWithChildrenBuilder();
    }

    public UnixDirectoryAttributesWithChildrenBuilder toBuilder() {
        return new UnixDirectoryAttributesWithChildrenBuilder().type(this.type).owner(this.owner).group(this.group).permissionsSymbolic(this.permissionsSymbolic).size(this.size).lastModified(this.lastModified).children(this.children);
    }

    public UnixEntityType getType() {
        return this.type;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getGroup() {
        return this.group;
    }

    public String getPermissionsSymbolic() {
        return this.permissionsSymbolic;
    }

    public Integer getSize() {
        return this.size;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public List<UnixDirectoryChild> getChildren() {
        return this.children;
    }

    public void setType(UnixEntityType type) {
        this.type = type;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setPermissionsSymbolic(String permissionsSymbolic) {
        this.permissionsSymbolic = permissionsSymbolic;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public void setChildren(List<UnixDirectoryChild> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnixDirectoryAttributesWithChildren)) {
            return false;
        }
        UnixDirectoryAttributesWithChildren other = (UnixDirectoryAttributesWithChildren)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UnixEntityType this$type = this.getType();
        UnixEntityType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$permissionsSymbolic = this.getPermissionsSymbolic();
        String other$permissionsSymbolic = other.getPermissionsSymbolic();
        if (this$permissionsSymbolic == null ? other$permissionsSymbolic != null : !this$permissionsSymbolic.equals(other$permissionsSymbolic)) {
            return false;
        }
        Integer this$size = this.getSize();
        Integer other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        String this$lastModified = this.getLastModified();
        String other$lastModified = other.getLastModified();
        if (this$lastModified == null ? other$lastModified != null : !this$lastModified.equals(other$lastModified)) {
            return false;
        }
        List<UnixDirectoryChild> this$children = this.getChildren();
        List<UnixDirectoryChild> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnixDirectoryAttributesWithChildren;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UnixEntityType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $permissionsSymbolic = this.getPermissionsSymbolic();
        result = result * 59 + ($permissionsSymbolic == null ? 43 : $permissionsSymbolic.hashCode());
        Integer $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        String $lastModified = this.getLastModified();
        result = result * 59 + ($lastModified == null ? 43 : $lastModified.hashCode());
        List<UnixDirectoryChild> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    public String toString() {
        return "UnixDirectoryAttributesWithChildren(type=" + (Object)((Object)this.getType()) + ", owner=" + this.getOwner() + ", group=" + this.getGroup() + ", permissionsSymbolic=" + this.getPermissionsSymbolic() + ", size=" + this.getSize() + ", lastModified=" + this.getLastModified() + ", children=" + this.getChildren() + ")";
    }

    public UnixDirectoryAttributesWithChildren() {
    }

    public UnixDirectoryAttributesWithChildren(UnixEntityType type, String owner, String group, String permissionsSymbolic, Integer size, String lastModified, List<UnixDirectoryChild> children) {
        this.type = type;
        this.owner = owner;
        this.group = group;
        this.permissionsSymbolic = permissionsSymbolic;
        this.size = size;
        this.lastModified = lastModified;
        this.children = children;
    }

    public static class UnixDirectoryAttributesWithChildrenBuilder {
        private UnixEntityType type;
        private String owner;
        private String group;
        private String permissionsSymbolic;
        private Integer size;
        private String lastModified;
        private List<UnixDirectoryChild> children;

        UnixDirectoryAttributesWithChildrenBuilder() {
        }

        public UnixDirectoryAttributesWithChildrenBuilder type(UnixEntityType type) {
            this.type = type;
            return this;
        }

        public UnixDirectoryAttributesWithChildrenBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public UnixDirectoryAttributesWithChildrenBuilder group(String group) {
            this.group = group;
            return this;
        }

        public UnixDirectoryAttributesWithChildrenBuilder permissionsSymbolic(String permissionsSymbolic) {
            this.permissionsSymbolic = permissionsSymbolic;
            return this;
        }

        public UnixDirectoryAttributesWithChildrenBuilder size(Integer size) {
            this.size = size;
            return this;
        }

        public UnixDirectoryAttributesWithChildrenBuilder lastModified(String lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public UnixDirectoryAttributesWithChildrenBuilder children(List<UnixDirectoryChild> children) {
            this.children = children;
            return this;
        }

        public UnixDirectoryAttributesWithChildren build() {
            return new UnixDirectoryAttributesWithChildren(this.type, this.owner, this.group, this.permissionsSymbolic, this.size, this.lastModified, this.children);
        }

        public String toString() {
            return "UnixDirectoryAttributesWithChildren.UnixDirectoryAttributesWithChildrenBuilder(type=" + (Object)((Object)this.type) + ", owner=" + this.owner + ", group=" + this.group + ", permissionsSymbolic=" + this.permissionsSymbolic + ", size=" + this.size + ", lastModified=" + this.lastModified + ", children=" + this.children + ")";
        }
    }
}

