/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.data.sets.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.zowe.data.sets.model.AllocationUnitType;
import org.zowe.data.sets.model.DataSetOrganisationType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@ApiModel(value="DataSetCreateRequest", description="Attributes of a data set to be created")
public class DataSetCreateRequest {
    @ApiModelProperty(value="Data set name", required=true, example="HLQ.ZOWE")
    private String name;
    @ApiModelProperty(value="Volume serial", required=false, example="zmf046")
    private String volumeSerial;
    @ApiModelProperty(value="Device type, unit", required=false, example="3390")
    private String deviceType;
    @ApiModelProperty(value="Data set organization", required=true, dataType="string", example="PO")
    private DataSetOrganisationType dataSetOrganization;
    @ApiModelProperty(value="Unit of space allocation, alcunit, spaceu", required=true, dataType="string", example="TRACK")
    private AllocationUnitType allocationUnit;
    @ApiModelProperty(value="Primary space allocation", required=true, example="10")
    private Integer primary;
    @ApiModelProperty(value="Secondary space allocation", required=true, example="5")
    private Integer secondary;
    @ApiModelProperty(value="Number of directory blocks, dirblk. Only valid for partitioned data sets", required=false, example="5")
    private Integer directoryBlocks;
    @ApiModelProperty(value="Average block", required=false, example="500")
    private Integer averageBlock;
    @ApiModelProperty(value="Record format, recfm", required=true, example="FB")
    private String recordFormat;
    @ApiModelProperty(value="Block size, blksize", example="400")
    private Integer blockSize;
    @ApiModelProperty(value="Record length, lrecl", required=true, example="80")
    private Integer recordLength;

    public static DataSetCreateRequestBuilder builder() {
        return new DataSetCreateRequestBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getVolumeSerial() {
        return this.volumeSerial;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public DataSetOrganisationType getDataSetOrganization() {
        return this.dataSetOrganization;
    }

    public AllocationUnitType getAllocationUnit() {
        return this.allocationUnit;
    }

    public Integer getPrimary() {
        return this.primary;
    }

    public Integer getSecondary() {
        return this.secondary;
    }

    public Integer getDirectoryBlocks() {
        return this.directoryBlocks;
    }

    public Integer getAverageBlock() {
        return this.averageBlock;
    }

    public String getRecordFormat() {
        return this.recordFormat;
    }

    public Integer getBlockSize() {
        return this.blockSize;
    }

    public Integer getRecordLength() {
        return this.recordLength;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVolumeSerial(String volumeSerial) {
        this.volumeSerial = volumeSerial;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setDataSetOrganization(DataSetOrganisationType dataSetOrganization) {
        this.dataSetOrganization = dataSetOrganization;
    }

    public void setAllocationUnit(AllocationUnitType allocationUnit) {
        this.allocationUnit = allocationUnit;
    }

    public void setPrimary(Integer primary) {
        this.primary = primary;
    }

    public void setSecondary(Integer secondary) {
        this.secondary = secondary;
    }

    public void setDirectoryBlocks(Integer directoryBlocks) {
        this.directoryBlocks = directoryBlocks;
    }

    public void setAverageBlock(Integer averageBlock) {
        this.averageBlock = averageBlock;
    }

    public void setRecordFormat(String recordFormat) {
        this.recordFormat = recordFormat;
    }

    public void setBlockSize(Integer blockSize) {
        this.blockSize = blockSize;
    }

    public void setRecordLength(Integer recordLength) {
        this.recordLength = recordLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSetCreateRequest)) {
            return false;
        }
        DataSetCreateRequest other = (DataSetCreateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$volumeSerial = this.getVolumeSerial();
        String other$volumeSerial = other.getVolumeSerial();
        if (this$volumeSerial == null ? other$volumeSerial != null : !this$volumeSerial.equals(other$volumeSerial)) {
            return false;
        }
        String this$deviceType = this.getDeviceType();
        String other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType)) {
            return false;
        }
        DataSetOrganisationType this$dataSetOrganization = this.getDataSetOrganization();
        DataSetOrganisationType other$dataSetOrganization = other.getDataSetOrganization();
        if (this$dataSetOrganization == null ? other$dataSetOrganization != null : !((Object)((Object)this$dataSetOrganization)).equals((Object)other$dataSetOrganization)) {
            return false;
        }
        AllocationUnitType this$allocationUnit = this.getAllocationUnit();
        AllocationUnitType other$allocationUnit = other.getAllocationUnit();
        if (this$allocationUnit == null ? other$allocationUnit != null : !((Object)((Object)this$allocationUnit)).equals((Object)other$allocationUnit)) {
            return false;
        }
        Integer this$primary = this.getPrimary();
        Integer other$primary = other.getPrimary();
        if (this$primary == null ? other$primary != null : !((Object)this$primary).equals(other$primary)) {
            return false;
        }
        Integer this$secondary = this.getSecondary();
        Integer other$secondary = other.getSecondary();
        if (this$secondary == null ? other$secondary != null : !((Object)this$secondary).equals(other$secondary)) {
            return false;
        }
        Integer this$directoryBlocks = this.getDirectoryBlocks();
        Integer other$directoryBlocks = other.getDirectoryBlocks();
        if (this$directoryBlocks == null ? other$directoryBlocks != null : !((Object)this$directoryBlocks).equals(other$directoryBlocks)) {
            return false;
        }
        Integer this$averageBlock = this.getAverageBlock();
        Integer other$averageBlock = other.getAverageBlock();
        if (this$averageBlock == null ? other$averageBlock != null : !((Object)this$averageBlock).equals(other$averageBlock)) {
            return false;
        }
        String this$recordFormat = this.getRecordFormat();
        String other$recordFormat = other.getRecordFormat();
        if (this$recordFormat == null ? other$recordFormat != null : !this$recordFormat.equals(other$recordFormat)) {
            return false;
        }
        Integer this$blockSize = this.getBlockSize();
        Integer other$blockSize = other.getBlockSize();
        if (this$blockSize == null ? other$blockSize != null : !((Object)this$blockSize).equals(other$blockSize)) {
            return false;
        }
        Integer this$recordLength = this.getRecordLength();
        Integer other$recordLength = other.getRecordLength();
        return !(this$recordLength == null ? other$recordLength != null : !((Object)this$recordLength).equals(other$recordLength));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSetCreateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $volumeSerial = this.getVolumeSerial();
        result = result * 59 + ($volumeSerial == null ? 43 : $volumeSerial.hashCode());
        String $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
        DataSetOrganisationType $dataSetOrganization = this.getDataSetOrganization();
        result = result * 59 + ($dataSetOrganization == null ? 43 : ((Object)((Object)$dataSetOrganization)).hashCode());
        AllocationUnitType $allocationUnit = this.getAllocationUnit();
        result = result * 59 + ($allocationUnit == null ? 43 : ((Object)((Object)$allocationUnit)).hashCode());
        Integer $primary = this.getPrimary();
        result = result * 59 + ($primary == null ? 43 : ((Object)$primary).hashCode());
        Integer $secondary = this.getSecondary();
        result = result * 59 + ($secondary == null ? 43 : ((Object)$secondary).hashCode());
        Integer $directoryBlocks = this.getDirectoryBlocks();
        result = result * 59 + ($directoryBlocks == null ? 43 : ((Object)$directoryBlocks).hashCode());
        Integer $averageBlock = this.getAverageBlock();
        result = result * 59 + ($averageBlock == null ? 43 : ((Object)$averageBlock).hashCode());
        String $recordFormat = this.getRecordFormat();
        result = result * 59 + ($recordFormat == null ? 43 : $recordFormat.hashCode());
        Integer $blockSize = this.getBlockSize();
        result = result * 59 + ($blockSize == null ? 43 : ((Object)$blockSize).hashCode());
        Integer $recordLength = this.getRecordLength();
        result = result * 59 + ($recordLength == null ? 43 : ((Object)$recordLength).hashCode());
        return result;
    }

    public String toString() {
        return "DataSetCreateRequest(name=" + this.getName() + ", volumeSerial=" + this.getVolumeSerial() + ", deviceType=" + this.getDeviceType() + ", dataSetOrganization=" + (Object)((Object)this.getDataSetOrganization()) + ", allocationUnit=" + (Object)((Object)this.getAllocationUnit()) + ", primary=" + this.getPrimary() + ", secondary=" + this.getSecondary() + ", directoryBlocks=" + this.getDirectoryBlocks() + ", averageBlock=" + this.getAverageBlock() + ", recordFormat=" + this.getRecordFormat() + ", blockSize=" + this.getBlockSize() + ", recordLength=" + this.getRecordLength() + ")";
    }

    public DataSetCreateRequest() {
    }

    public DataSetCreateRequest(String name, String volumeSerial, String deviceType, DataSetOrganisationType dataSetOrganization, AllocationUnitType allocationUnit, Integer primary, Integer secondary, Integer directoryBlocks, Integer averageBlock, String recordFormat, Integer blockSize, Integer recordLength) {
        this.name = name;
        this.volumeSerial = volumeSerial;
        this.deviceType = deviceType;
        this.dataSetOrganization = dataSetOrganization;
        this.allocationUnit = allocationUnit;
        this.primary = primary;
        this.secondary = secondary;
        this.directoryBlocks = directoryBlocks;
        this.averageBlock = averageBlock;
        this.recordFormat = recordFormat;
        this.blockSize = blockSize;
        this.recordLength = recordLength;
    }

    public static class DataSetCreateRequestBuilder {
        private String name;
        private String volumeSerial;
        private String deviceType;
        private DataSetOrganisationType dataSetOrganization;
        private AllocationUnitType allocationUnit;
        private Integer primary;
        private Integer secondary;
        private Integer directoryBlocks;
        private Integer averageBlock;
        private String recordFormat;
        private Integer blockSize;
        private Integer recordLength;

        DataSetCreateRequestBuilder() {
        }

        public DataSetCreateRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DataSetCreateRequestBuilder volumeSerial(String volumeSerial) {
            this.volumeSerial = volumeSerial;
            return this;
        }

        public DataSetCreateRequestBuilder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public DataSetCreateRequestBuilder dataSetOrganization(DataSetOrganisationType dataSetOrganization) {
            this.dataSetOrganization = dataSetOrganization;
            return this;
        }

        public DataSetCreateRequestBuilder allocationUnit(AllocationUnitType allocationUnit) {
            this.allocationUnit = allocationUnit;
            return this;
        }

        public DataSetCreateRequestBuilder primary(Integer primary) {
            this.primary = primary;
            return this;
        }

        public DataSetCreateRequestBuilder secondary(Integer secondary) {
            this.secondary = secondary;
            return this;
        }

        public DataSetCreateRequestBuilder directoryBlocks(Integer directoryBlocks) {
            this.directoryBlocks = directoryBlocks;
            return this;
        }

        public DataSetCreateRequestBuilder averageBlock(Integer averageBlock) {
            this.averageBlock = averageBlock;
            return this;
        }

        public DataSetCreateRequestBuilder recordFormat(String recordFormat) {
            this.recordFormat = recordFormat;
            return this;
        }

        public DataSetCreateRequestBuilder blockSize(Integer blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public DataSetCreateRequestBuilder recordLength(Integer recordLength) {
            this.recordLength = recordLength;
            return this;
        }

        public DataSetCreateRequest build() {
            return new DataSetCreateRequest(this.name, this.volumeSerial, this.deviceType, this.dataSetOrganization, this.allocationUnit, this.primary, this.secondary, this.directoryBlocks, this.averageBlock, this.recordFormat, this.blockSize, this.recordLength);
        }

        public String toString() {
            return "DataSetCreateRequest.DataSetCreateRequestBuilder(name=" + this.name + ", volumeSerial=" + this.volumeSerial + ", deviceType=" + this.deviceType + ", dataSetOrganization=" + (Object)((Object)this.dataSetOrganization) + ", allocationUnit=" + (Object)((Object)this.allocationUnit) + ", primary=" + this.primary + ", secondary=" + this.secondary + ", directoryBlocks=" + this.directoryBlocks + ", averageBlock=" + this.averageBlock + ", recordFormat=" + this.recordFormat + ", blockSize=" + this.blockSize + ", recordLength=" + this.recordLength + ")";
        }
    }
}

