/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.unix.files.services.zosmf;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.utils.ResponseCache;
import org.zowe.api.common.zosmf.services.AbstractZosmfRequestRunner;
import org.zowe.unix.files.exceptions.PathNameNotValidException;
import org.zowe.unix.files.exceptions.UnauthorisedDirectoryException;
import org.zowe.unix.files.model.UnixDirectoryAttributesWithChildren;
import org.zowe.unix.files.model.UnixDirectoryChild;
import org.zowe.unix.files.model.UnixEntityType;

public class ListUnixDirectoryZosmfRunner
extends AbstractZosmfRequestRunner<UnixDirectoryAttributesWithChildren> {
    @Autowired
    ZosmfConnector zosmfConnector;
    private String path;

    public ListUnixDirectoryZosmfRunner(String path) {
        this.path = path;
    }

    protected RequestBuilder prepareQuery(ZosmfConnector zosmfConnector) throws URISyntaxException {
        String query = String.format("path=%s", this.path);
        URI requestUrl = zosmfConnector.getFullUrl("restfiles/fs", query);
        RequestBuilder requestBuilder = RequestBuilder.get((URI)requestUrl);
        return requestBuilder;
    }

    protected int[] getSuccessStatus() {
        return new int[]{200};
    }

    protected UnixDirectoryAttributesWithChildren getResult(ResponseCache responseCache) throws IOException {
        JsonObject directoryListResponse = responseCache.getEntityAsJsonObject();
        JsonElement directoryListArray = directoryListResponse.get("items");
        List<UnixDirectoryChild> directoryChildren = this.getChildrenFromJsonArray(directoryListArray.getAsJsonArray());
        JsonObject directoryObject = directoryListArray.getAsJsonArray().get(0).getAsJsonObject();
        UnixDirectoryAttributesWithChildren unixDirectoryAttributesWithChildren = UnixDirectoryAttributesWithChildren.builder().owner(this.getStringOrNull(directoryObject, "user")).group(this.getStringOrNull(directoryObject, "group")).type(this.getEntityTypeFromSymbolicPermissions(this.getStringOrNull(directoryObject, "mode"))).permissionsSymbolic(this.getStringOrNull(directoryObject, "mode")).size(this.getIntegerOrNull(directoryObject, "size")).lastModified(this.getStringOrNull(directoryObject, "mtime")).children(directoryChildren).build();
        return unixDirectoryAttributesWithChildren;
    }

    private List<UnixDirectoryChild> getChildrenFromJsonArray(JsonArray directoryListArray) {
        ArrayList<UnixDirectoryChild> directoryChildren = new ArrayList<UnixDirectoryChild>();
        for (JsonElement jsonElement : directoryListArray) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (this.getStringOrNull(jsonObject, "name").equals(".") || this.getStringOrNull(jsonObject, "name").equals("..")) continue;
            UnixDirectoryChild unixDirectoryChild = UnixDirectoryChild.builder().name(this.getStringOrNull(jsonObject, "name")).type(this.getEntityTypeFromSymbolicPermissions(this.getStringOrNull(jsonObject, "mode"))).link(this.constructLinkString(this.getStringOrNull(jsonObject, "name"))).build();
            directoryChildren.add(unixDirectoryChild);
        }
        return directoryChildren;
    }

    private UnixEntityType getEntityTypeFromSymbolicPermissions(String permissions) {
        if (permissions.startsWith("d")) {
            return UnixEntityType.DIRECTORY;
        }
        return UnixEntityType.FILE;
    }

    private String constructLinkString(String fileName) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String requestURL = request.getRequestURL().toString();
        if (requestURL.charAt(requestURL.length() - 1) == '/') {
            requestURL = requestURL.substring(0, requestURL.length() - 1);
        }
        if (this.path.equals("/")) {
            return String.format("%s/%s", requestURL, fileName);
        }
        return String.format("%s%s/%s", requestURL, this.path, fileName);
    }

    protected ZoweApiRestException createException(JsonObject jsonResponse, int statusCode) {
        if (statusCode == 500) {
            JsonElement details = jsonResponse.get("details");
            JsonElement message = jsonResponse.get("message");
            if (null != details && details.toString().contains("EDC5111I Permission denied.")) {
                throw new UnauthorisedDirectoryException(this.path);
            }
            if (message.toString().contains("Path name is not valid")) {
                throw new PathNameNotValidException(this.path);
            }
        }
        return null;
    }
}

