/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.unix.files.services.zosmf;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.methods.RequestBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.utils.ResponseCache;
import org.zowe.api.common.zosmf.services.AbstractZosmfRequestRunner;
import org.zowe.unix.files.exceptions.FileNotFoundException;
import org.zowe.unix.files.exceptions.PathNameNotValidException;
import org.zowe.unix.files.exceptions.UnauthorisedFileException;
import org.zowe.unix.files.model.UnixFileContent;

public class GetUnixFileContentRunner
extends AbstractZosmfRequestRunner<UnixFileContent> {
    @Autowired
    ZosmfConnector zosmfConnector;
    private String path;

    public GetUnixFileContentRunner(String path) {
        this.path = path;
    }

    protected int[] getSuccessStatus() {
        return new int[]{200};
    }

    protected RequestBuilder prepareQuery(ZosmfConnector zosmfConnector) throws URISyntaxException {
        URI requestUrl = zosmfConnector.getFullUrl("restfiles/fs" + this.path);
        RequestBuilder requestBuilder = RequestBuilder.get((URI)requestUrl);
        return requestBuilder;
    }

    protected UnixFileContent getResult(ResponseCache responseCache) throws IOException {
        return new UnixFileContent(responseCache.getEntity());
    }

    protected ZoweApiRestException createException(JsonObject jsonResponse, int statusCode) {
        JsonElement details = jsonResponse.get("details");
        if (null != details) {
            if (statusCode == 500) {
                if (details.toString().contains("EDC5135I Not a directory.")) {
                    throw new PathNameNotValidException(this.path);
                }
                if (details.toString().contains("EDC5111I Permission denied.")) {
                    throw new UnauthorisedFileException(this.path);
                }
            } else if (statusCode == 404 && details.toString().contains("EDC5129I No such file or directory.")) {
                throw new FileNotFoundException(this.path);
            }
        }
        return null;
    }
}

