/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.data.sets.services.zosmf;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.Header;
import org.apache.http.client.methods.RequestBuilder;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.connectors.zosmf.exceptions.DataSetNotFoundException;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.utils.ResponseCache;
import org.zowe.data.sets.model.DataSetContent;
import org.zowe.data.sets.model.DataSetContentWithEtag;
import org.zowe.data.sets.services.zosmf.AbstractZosmfDataSetsRequestRunner;

public class GetDataSetContentZosmfRequestRunner
extends AbstractZosmfDataSetsRequestRunner<DataSetContentWithEtag> {
    private String dataSetName;

    public GetDataSetContentZosmfRequestRunner(String dataSetName) {
        this.dataSetName = dataSetName;
    }

    protected RequestBuilder prepareQuery(ZosmfConnector zosmfConnector) throws URISyntaxException, IOException {
        String urlPath = String.format("restfiles/ds/%s", this.dataSetName);
        URI requestUrl = zosmfConnector.getFullUrl(urlPath);
        RequestBuilder requestBuilder = RequestBuilder.get((URI)requestUrl);
        requestBuilder.addHeader("X-IBM-Return-Etag", "true");
        return requestBuilder;
    }

    protected int[] getSuccessStatus() {
        return new int[]{200};
    }

    protected DataSetContentWithEtag getResult(ResponseCache responseCache) throws IOException {
        DataSetContent content = new DataSetContent(responseCache.getEntity());
        String eTag = null;
        Header etagHeader = responseCache.getFirstHeader("ETag");
        if (etagHeader != null) {
            eTag = etagHeader.getValue();
        }
        return new DataSetContentWithEtag(content, eTag);
    }

    protected ZoweApiRestException createException(JsonObject jsonResponse, int statusCode) {
        String zosmfMessage = jsonResponse.get("message").getAsString();
        if ("Data set not found.".equals(zosmfMessage)) {
            throw new DataSetNotFoundException(this.dataSetName);
        }
        if ("Member not found".equals(zosmfMessage)) {
            throw new DataSetNotFoundException(this.dataSetName);
        }
        return this.createDataSetException(jsonResponse, statusCode, this.dataSetName);
    }
}

