/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.data.sets.services.zosmf;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.model.ItemsWrapper;
import org.zowe.data.sets.model.DataSetAttributes;
import org.zowe.data.sets.model.DataSetContentWithEtag;
import org.zowe.data.sets.model.DataSetCreateRequest;
import org.zowe.data.sets.services.DataSetService;
import org.zowe.data.sets.services.zosmf.CreateDataSetZosmfRequestRunner;
import org.zowe.data.sets.services.zosmf.DeleteDataSetZosmfRequestRunner;
import org.zowe.data.sets.services.zosmf.GetDataSetContentZosmfRequestRunner;
import org.zowe.data.sets.services.zosmf.ListDataSetMembersZosmfRequestRunner;
import org.zowe.data.sets.services.zosmf.ListDataSetsZosmfRequestRunner;
import org.zowe.data.sets.services.zosmf.PutDataSetContentZosmfRequestRunner;

@Service
public class ZosmfDataSetService
implements DataSetService {
    @Autowired
    ZosmfConnector zosmfConnector;

    @Override
    public ItemsWrapper<String> listDataSetMembers(String dataSetName) {
        ListDataSetMembersZosmfRequestRunner runner = new ListDataSetMembersZosmfRequestRunner(dataSetName);
        return (ItemsWrapper)runner.run(this.zosmfConnector);
    }

    @Override
    public ItemsWrapper<DataSetAttributes> listDataSets(String filter) {
        ListDataSetsZosmfRequestRunner runner = new ListDataSetsZosmfRequestRunner(filter);
        return (ItemsWrapper)runner.run(this.zosmfConnector);
    }

    @Override
    public DataSetContentWithEtag getContent(String dataSetName) {
        GetDataSetContentZosmfRequestRunner runner = new GetDataSetContentZosmfRequestRunner(dataSetName);
        return (DataSetContentWithEtag)runner.run(this.zosmfConnector);
    }

    @Override
    public String putContent(String dataSetName, DataSetContentWithEtag contentWithEtag) {
        PutDataSetContentZosmfRequestRunner runner = new PutDataSetContentZosmfRequestRunner(dataSetName, contentWithEtag);
        return (String)runner.run(this.zosmfConnector);
    }

    @Override
    public String createDataSet(DataSetCreateRequest request) {
        CreateDataSetZosmfRequestRunner runner = new CreateDataSetZosmfRequestRunner(request);
        return (String)runner.run(this.zosmfConnector);
    }

    @Override
    public void deleteDataSet(String dataSetName) {
        DeleteDataSetZosmfRequestRunner runner = new DeleteDataSetZosmfRequestRunner(dataSetName);
        runner.run(this.zosmfConnector);
    }
}

