/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.data.sets.services.zosmf;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.http.client.methods.RequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.model.ItemsWrapper;
import org.zowe.api.common.utils.ResponseCache;
import org.zowe.data.sets.model.AllocationUnitType;
import org.zowe.data.sets.model.DataSetAttributes;
import org.zowe.data.sets.model.DataSetOrganisationType;
import org.zowe.data.sets.services.zosmf.AbstractZosmfDataSetsRequestRunner;

public class ListDataSetsZosmfRequestRunner
extends AbstractZosmfDataSetsRequestRunner<ItemsWrapper<DataSetAttributes>> {
    private static final Logger log = LoggerFactory.getLogger(ListDataSetsZosmfRequestRunner.class);
    private String filter;

    public ListDataSetsZosmfRequestRunner(String filter) {
        this.filter = filter;
    }

    protected RequestBuilder prepareQuery(ZosmfConnector zosmfConnector) throws URISyntaxException, IOException {
        String query = String.format("dslevel=%s", this.filter);
        URI requestUrl = zosmfConnector.getFullUrl("restfiles/ds", query);
        RequestBuilder requestBuilder = RequestBuilder.get((URI)requestUrl);
        requestBuilder.addHeader("X-IBM-Attributes", "base");
        return requestBuilder;
    }

    protected int[] getSuccessStatus() {
        return new int[]{200};
    }

    protected ItemsWrapper<DataSetAttributes> getResult(ResponseCache responseCache) throws IOException {
        JsonObject dataSetsResponse = responseCache.getEntityAsJsonObject();
        JsonElement dataSetJsonArray = dataSetsResponse.get("items");
        ArrayList<DataSetAttributes> dataSets = new ArrayList<DataSetAttributes>();
        for (JsonElement jsonElement : dataSetJsonArray.getAsJsonArray()) {
            try {
                DataSetAttributes dataSet = this.getDataSetFromJson(jsonElement.getAsJsonObject());
                dataSets.add(dataSet);
            }
            catch (IllegalArgumentException e) {
                log.error("listDataSets", (Throwable)e);
            }
        }
        return new ItemsWrapper(dataSets);
    }

    protected ZoweApiRestException createException(JsonObject jsonResponse, int statusCode) {
        return this.createDataSetException(jsonResponse, statusCode, this.filter);
    }

    private DataSetAttributes getDataSetFromJson(JsonObject returned) {
        String spacu;
        DataSetAttributes.DataSetAttributesBuilder builder = DataSetAttributes.builder().catalogName(this.getStringOrNull(returned, "catnm")).name(this.getStringOrNull(returned, "dsname")).migrated(Boolean.valueOf("YES".equals(this.getStringOrNull(returned, "migr")))).volumeSerial(this.getStringOrNull(returned, "vols")).blockSize(this.getIntegerOrNull(returned, "blksz")).deviceType(this.getStringOrNull(returned, "dev")).expirationDate(this.getStringOrNull(returned, "edate")).creationDate(this.getStringOrNull(returned, "cdate")).recordLength(this.getIntegerOrNull(returned, "lrecl")).recordFormat(this.getStringOrNull(returned, "recfm")).allocatedSize(this.getIntegerOrNull(returned, "sizex")).used(this.getIntegerOrNull(returned, "used"));
        String dsorg = this.getStringOrNull(returned, "dsorg");
        if (dsorg != null) {
            builder.dataSetOrganization(DataSetOrganisationType.getByZosmfName((String)dsorg));
        }
        if ((spacu = this.getStringOrNull(returned, "spacu")) != null) {
            builder.allocationUnit(AllocationUnitType.valueOf((String)spacu.substring(0, spacu.length() - 1)));
        }
        return builder.build();
    }
}

