/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.data.sets.services;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.connectors.zosmf.exceptions.DataSetNotFoundException;
import org.zowe.api.common.exceptions.NoZosmfResponseEntityException;
import org.zowe.api.common.exceptions.PreconditionFailedException;
import org.zowe.api.common.exceptions.ServerErrorException;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.utils.JsonUtils;
import org.zowe.api.common.utils.ResponseUtils;
import org.zowe.data.sets.exceptions.InvalidDirectoryBlockException;
import org.zowe.data.sets.exceptions.UnauthorisedDataSetException;
import org.zowe.data.sets.model.AllocationUnitType;
import org.zowe.data.sets.model.DataSetAttributes;
import org.zowe.data.sets.model.DataSetContent;
import org.zowe.data.sets.model.DataSetContentWithEtag;
import org.zowe.data.sets.model.DataSetCreateRequest;
import org.zowe.data.sets.model.DataSetOrganisationType;
import org.zowe.data.sets.model.ZosmfCreateRequest;
import org.zowe.data.sets.services.DataSetService;

@Service
public class ZosmfDataSetService
implements DataSetService {
    private static final Logger log = LoggerFactory.getLogger(ZosmfDataSetService.class);
    private static final String AUTHORIZATION_FAILURE = "ISRZ002 Authorization failed";
    private static final String DATA_SET_NOT_FOUND = "ISRZ002 Data set not cataloged";
    @Autowired
    ZosmfConnector zosmfConnector;

    @Override
    public List<String> listDataSetMembers(String dataSetName) {
        String urlPath = String.format("restfiles/ds/%s/member", dataSetName);
        try {
            URI requestUrl = this.zosmfConnector.getFullUrl(urlPath);
            HttpResponse response = this.zosmfConnector.request(RequestBuilder.get((URI)requestUrl));
            int statusCode = ResponseUtils.getStatus((HttpResponse)response);
            if (statusCode == 200) {
                ArrayList<String> memberNames = new ArrayList<String>();
                JsonObject memberResponse = ResponseUtils.getEntityAsJsonObject((HttpResponse)response);
                JsonElement memberJsonArray = memberResponse.get("items");
                for (JsonElement jsonElement : memberJsonArray.getAsJsonArray()) {
                    memberNames.add(jsonElement.getAsJsonObject().get("member").getAsString());
                }
                return memberNames;
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                ContentType contentType = ContentType.get((HttpEntity)entity);
                String mimeType = contentType.getMimeType();
                if (mimeType.equals(ContentType.APPLICATION_JSON.getMimeType())) {
                    JsonObject jsonResponse = ResponseUtils.getEntityAsJsonObject((HttpResponse)response);
                    JsonElement details = jsonResponse.get("details");
                    if (statusCode == 500) {
                        if (details.toString().contains(AUTHORIZATION_FAILURE)) {
                            throw new UnauthorisedDataSetException(dataSetName);
                        }
                    } else if (statusCode == 404 && details.toString().contains(DATA_SET_NOT_FOUND)) {
                        throw new DataSetNotFoundException(dataSetName);
                    }
                    throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), details.toString(), new Object[0]);
                }
                throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), entity.toString(), new Object[0]);
            }
            throw new NoZosmfResponseEntityException(this.getSpringHttpStatusFromCode(statusCode), urlPath);
        }
        catch (IOException | URISyntaxException e) {
            log.error("listDataSetMembers", (Throwable)e);
            throw new ServerErrorException((Throwable)e);
        }
    }

    @Override
    public List<DataSetAttributes> listDataSets(String filter) {
        try {
            String query = String.format("dslevel=%s", filter);
            URI requestUrl = this.zosmfConnector.getFullUrl("restfiles/ds", query);
            RequestBuilder requestBuilder = RequestBuilder.get((URI)requestUrl);
            requestBuilder.addHeader("X-IBM-Attributes", "base");
            HttpResponse response = this.zosmfConnector.request(requestBuilder);
            int statusCode = ResponseUtils.getStatus((HttpResponse)response);
            if (statusCode == 200) {
                JsonObject dataSetsResponse = ResponseUtils.getEntityAsJsonObject((HttpResponse)response);
                JsonElement dataSetJsonArray = dataSetsResponse.get("items");
                ArrayList<DataSetAttributes> dataSets = new ArrayList<DataSetAttributes>();
                for (JsonElement jsonElement : dataSetJsonArray.getAsJsonArray()) {
                    try {
                        DataSetAttributes dataSet = ZosmfDataSetService.getDataSetFromJson(jsonElement.getAsJsonObject());
                        dataSets.add(dataSet);
                    }
                    catch (IllegalArgumentException e) {
                        log.error("listDataSets", (Throwable)e);
                    }
                }
                return dataSets;
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                ContentType contentType = ContentType.get((HttpEntity)entity);
                String mimeType = contentType.getMimeType();
                if (mimeType.equals(ContentType.APPLICATION_JSON.getMimeType())) {
                    JsonObject jsonResponse = ResponseUtils.getEntityAsJsonObject((HttpResponse)response);
                    JsonElement details = jsonResponse.get("details");
                    throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), details.toString(), new Object[0]);
                }
                throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), entity.toString(), new Object[0]);
            }
            throw new NoZosmfResponseEntityException(this.getSpringHttpStatusFromCode(statusCode), requestUrl.toString());
        }
        catch (IOException | URISyntaxException e) {
            log.error("listDataSets", (Throwable)e);
            throw new ServerErrorException((Throwable)e);
        }
    }

    @Override
    public DataSetContentWithEtag getContent(String dataSetName) {
        String urlPath = String.format("restfiles/ds/%s", dataSetName);
        try {
            URI requestUrl = this.zosmfConnector.getFullUrl(urlPath);
            RequestBuilder requestBuilder = RequestBuilder.get((URI)requestUrl);
            requestBuilder.addHeader("X-IBM-Return-Etag", "true");
            HttpResponse response = this.zosmfConnector.request(requestBuilder);
            int statusCode = ResponseUtils.getStatus((HttpResponse)response);
            if (statusCode == 200) {
                DataSetContent content = new DataSetContent(ResponseUtils.getEntity((HttpResponse)response));
                String eTag = null;
                Header etagHeader = response.getFirstHeader("ETag");
                if (etagHeader != null) {
                    eTag = etagHeader.getValue();
                }
                return new DataSetContentWithEtag(content, eTag);
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                ContentType contentType = ContentType.get((HttpEntity)entity);
                String mimeType = contentType.getMimeType();
                if (mimeType.equals(ContentType.APPLICATION_JSON.getMimeType())) {
                    JsonObject jsonResponse = ResponseUtils.getEntityAsJsonObject((HttpResponse)response);
                    String zosmfMessage = jsonResponse.get("message").getAsString();
                    if ("Data set not found.".equals(zosmfMessage)) {
                        throw new DataSetNotFoundException(dataSetName);
                    }
                    if ("Member not found".equals(zosmfMessage)) {
                        throw new DataSetNotFoundException(dataSetName);
                    }
                    JsonElement details = jsonResponse.get("details");
                    if (statusCode == 500 && details.toString().contains(AUTHORIZATION_FAILURE)) {
                        throw new UnauthorisedDataSetException(dataSetName);
                    }
                    throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), details.toString(), new Object[0]);
                }
                throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), entity.toString(), new Object[0]);
            }
            throw new NoZosmfResponseEntityException(this.getSpringHttpStatusFromCode(statusCode), urlPath);
        }
        catch (IOException | URISyntaxException e) {
            log.error("getContent", (Throwable)e);
            throw new ServerErrorException((Throwable)e);
        }
    }

    @Override
    public String putContent(String dataSetName, DataSetContentWithEtag contentWithEtag) {
        String urlPath = String.format("restfiles/ds/%s", dataSetName);
        try {
            HttpResponse response;
            int statusCode;
            URI requestUrl = this.zosmfConnector.getFullUrl(urlPath);
            DataSetContent content = contentWithEtag.getContent();
            StringEntity requestEntity = new StringEntity(content.getRecords());
            RequestBuilder requestBuilder = RequestBuilder.put((URI)requestUrl).setEntity((HttpEntity)requestEntity);
            requestBuilder.addHeader("Content-type", ContentType.TEXT_PLAIN.getMimeType());
            String ifMatch = contentWithEtag.getEtag();
            if (StringUtils.hasText((String)ifMatch)) {
                requestBuilder.addHeader("If-Match", ifMatch.replaceAll("\"", ""));
            }
            if ((statusCode = ResponseUtils.getStatus((HttpResponse)(response = this.zosmfConnector.request(requestBuilder)))) == 204 || statusCode == 201) {
                Header etagHeader = response.getFirstHeader("ETag");
                return etagHeader.getValue();
            }
            if (statusCode == 412) {
                throw new PreconditionFailedException(dataSetName);
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                ContentType contentType = ContentType.get((HttpEntity)entity);
                String mimeType = contentType.getMimeType();
                if (mimeType.equals(ContentType.APPLICATION_JSON.getMimeType())) {
                    JsonObject jsonResponse = ResponseUtils.getEntityAsJsonObject((HttpResponse)response);
                    String zosmfMessage = jsonResponse.get("message").getAsString();
                    if ("Data set not found.".equals(zosmfMessage)) {
                        throw new DataSetNotFoundException(dataSetName);
                    }
                    JsonElement details = jsonResponse.get("details");
                    if (statusCode == 500 && details.toString().contains(AUTHORIZATION_FAILURE)) {
                        throw new UnauthorisedDataSetException(dataSetName);
                    }
                }
                throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), entity.toString(), new Object[0]);
            }
            throw new NoZosmfResponseEntityException(this.getSpringHttpStatusFromCode(statusCode), urlPath);
        }
        catch (IOException | URISyntaxException e) {
            log.error("putContent", (Throwable)e);
            throw new ServerErrorException((Throwable)e);
        }
    }

    @Override
    public String createDataSet(DataSetCreateRequest input) {
        String dataSetName = input.getName();
        if (input.getDataSetOrganization() == DataSetOrganisationType.PS && input.getDirectoryBlocks() != null && input.getDirectoryBlocks() != 0) {
            throw new InvalidDirectoryBlockException(dataSetName);
        }
        String urlPath = String.format("restfiles/ds/%s", dataSetName);
        try {
            URI requestUrl = this.zosmfConnector.getFullUrl(urlPath);
            JsonObject requestBody = this.convertIntoZosmfRequestJson(input);
            StringEntity requestEntity = new StringEntity(requestBody.toString(), ContentType.APPLICATION_JSON);
            RequestBuilder requestBuilder = RequestBuilder.post((URI)requestUrl).setEntity((HttpEntity)requestEntity);
            HttpResponse response = this.zosmfConnector.request(requestBuilder);
            int statusCode = ResponseUtils.getStatus((HttpResponse)response);
            if (statusCode == 201) {
                return dataSetName;
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                ContentType contentType = ContentType.get((HttpEntity)entity);
                String mimeType = contentType.getMimeType();
                if (mimeType.equals(ContentType.APPLICATION_JSON.getMimeType())) {
                    JsonObject jsonResponse = ResponseUtils.getEntityAsJsonObject((HttpResponse)response);
                    throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), jsonResponse.toString(), new Object[0]);
                }
                throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), entity.toString(), new Object[0]);
            }
            throw new NoZosmfResponseEntityException(this.getSpringHttpStatusFromCode(statusCode), urlPath);
        }
        catch (IOException | URISyntaxException e) {
            log.error("createDataSet", (Throwable)e);
            throw new ServerErrorException((Throwable)e);
        }
    }

    private JsonObject convertIntoZosmfRequestJson(DataSetCreateRequest input) throws IOException {
        ZosmfCreateRequest request = ZosmfCreateRequest.createFromDataSetCreateRequest((DataSetCreateRequest)input);
        return JsonUtils.convertToJsonObject((Object)request);
    }

    @Override
    public void deleteDataSet(String dataSetName) {
        try {
            URI requestUrl = this.zosmfConnector.getFullUrl(String.format("restfiles/ds/%s", dataSetName));
            HttpResponse response = this.zosmfConnector.request(RequestBuilder.delete((URI)requestUrl));
            int statusCode = ResponseUtils.getStatus((HttpResponse)response);
            if (statusCode == 204) {
                return;
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                ContentType contentType = ContentType.get((HttpEntity)entity);
                String mimeType = contentType.getMimeType();
                if (mimeType.equals(ContentType.APPLICATION_JSON.getMimeType())) {
                    JsonObject jsonResponse = ResponseUtils.getEntityAsJsonObject((HttpResponse)response);
                    JsonElement details = jsonResponse.get("details");
                    if (statusCode == 404 && details.toString().contains(String.format("ISRZ002 Data set not cataloged - '%s' was not found in catalog.", dataSetName))) {
                        throw new DataSetNotFoundException(dataSetName);
                    }
                }
                throw new ZoweApiRestException(this.getSpringHttpStatusFromCode(statusCode), entity.toString(), new Object[0]);
            }
            throw new NoZosmfResponseEntityException(this.getSpringHttpStatusFromCode(statusCode), requestUrl.toString());
        }
        catch (IOException | URISyntaxException e) {
            log.error("deleteDataSet", (Throwable)e);
            throw new ServerErrorException((Throwable)e);
        }
    }

    private static DataSetAttributes getDataSetFromJson(JsonObject returned) {
        String spacu;
        DataSetAttributes.DataSetAttributesBuilder builder = DataSetAttributes.builder().catalogName(ZosmfDataSetService.getStringOrNull(returned, "catnm")).name(ZosmfDataSetService.getStringOrNull(returned, "dsname")).migrated(Boolean.valueOf("YES".equals(ZosmfDataSetService.getStringOrNull(returned, "migr")))).volumeSerial(ZosmfDataSetService.getStringOrNull(returned, "vols")).blockSize(ZosmfDataSetService.getIntegerOrNull(returned, "blksz")).deviceType(ZosmfDataSetService.getStringOrNull(returned, "dev")).expirationDate(ZosmfDataSetService.getStringOrNull(returned, "edate")).creationDate(ZosmfDataSetService.getStringOrNull(returned, "cdate")).recordLength(ZosmfDataSetService.getIntegerOrNull(returned, "lrecl")).recordFormat(ZosmfDataSetService.getStringOrNull(returned, "recfm")).allocatedSize(ZosmfDataSetService.getIntegerOrNull(returned, "sizex")).used(ZosmfDataSetService.getIntegerOrNull(returned, "used"));
        String dsorg = ZosmfDataSetService.getStringOrNull(returned, "dsorg");
        if (dsorg != null) {
            builder.dataSetOrganization(DataSetOrganisationType.getByZosmfName((String)dsorg));
        }
        if ((spacu = ZosmfDataSetService.getStringOrNull(returned, "spacu")) != null) {
            builder.allocationUnit(AllocationUnitType.valueOf((String)spacu.substring(0, spacu.length() - 1)));
        }
        return builder.build();
    }

    private static String getStringOrNull(JsonObject json, String key) {
        String value = null;
        JsonElement jsonElement = json.get(key);
        if (jsonElement != null && !jsonElement.isJsonNull() && !jsonElement.getAsString().equals("?") && (value = jsonElement.getAsString()).equals("?")) {
            value = null;
        }
        return value;
    }

    private static Integer getIntegerOrNull(JsonObject json, String key) {
        Integer value = null;
        JsonElement jsonElement = json.get(key);
        if (jsonElement != null && !jsonElement.isJsonNull() && !jsonElement.getAsString().equals("?")) {
            value = jsonElement.getAsInt();
        }
        return value;
    }

    private HttpStatus getSpringHttpStatusFromCode(int statusCode) {
        return HttpStatus.resolve((int)statusCode);
    }
}

