/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.api.common.connectors.zosmf;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.api.common.connectors.zosmf.ConnectionProperties;
import org.zowe.api.common.connectors.zosmf.exceptions.ZosmfConnectionException;

public abstract class ZosmfConnector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZosmfConnector.class);
    private final String host;
    private final int port;

    public ZosmfConnector(ConnectionProperties properties) {
        this.host = properties.getIpAddress();
        this.port = properties.getHttpsPort();
    }

    public URI getFullUrl(String relativePath) throws URISyntaxException {
        return this.getFullUrl(relativePath, null);
    }

    public URI getFullUrl(String relativePath, String query) throws URISyntaxException {
        try {
            return new URI("https", null, this.host, this.port, "/zosmf/api/v1/" + relativePath, query, null);
        }
        catch (URISyntaxException e) {
            log.error("getFullUrl", (Throwable)e);
            throw e;
        }
    }

    public abstract Header getAuthHeader();

    public HttpResponse executeRequest(RequestBuilder requestBuilder) throws IOException {
        HttpClient client;
        requestBuilder.setHeader(this.getAuthHeader());
        requestBuilder.setHeader("X-CSRF-ZOSMF-HEADER", "");
        requestBuilder.setHeader("X-IBM-Response-Timeout", "600");
        try {
            client = ZosmfConnector.createIgnoreSSLClient();
        }
        catch (GeneralSecurityException e) {
            log.error("request", (Throwable)e);
            throw new ZosmfConnectionException(e);
        }
        return client.execute(requestBuilder.build());
    }

    public static HttpClient createIgnoreSSLClient() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslcontext = SSLContext.getInstance("TLS");
        sslcontext.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }}, new SecureRandom());
        return HttpClientBuilder.create().setSSLContext(sslcontext).setSSLHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s1, SSLSession s2) {
                return true;
            }
        }).build();
    }
}

