/*  
 * This program and the accompanying materials are made available under the terms of the    
 * Eclipse Public License v2.0 which accompanies this distribution, and is available at 
 * https://www.eclipse.org/legal/epl-v20.html   
 *  
 * SPDX-License-Identifier: EPL-2.0 
 *  
 * Copyright IBM Corporation 2018, 2020
 */ 
package org.zowe.api.common.utils;  

import org.springframework.security.core.Authentication;    
import org.springframework.security.core.context.SecurityContextHolder; 
import org.zowe.api.common.security.CustomUser; 

public class ZosUtils { 

    public static String getUsername() {    
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication(); 
        CustomUser customUser = (CustomUser) authentication.getPrincipal(); 
        return customUser.getUsername().toUpperCase();  
    }   
}