/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.api.common.security;

import java.util.ArrayList;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.zowe.api.common.connectors.zosmf.ZosmfConnectorLtpaAuth;
import org.zowe.api.common.security.CustomUser;

@Component
public class CustomAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(CustomAuthenticationProvider.class);
    @Autowired
    ZosmfConnectorLtpaAuth zosmfconnector;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = authentication.getName();
        String password = authentication.getCredentials().toString();
        if (!(authentication.getPrincipal() instanceof CustomUser)) {
            try {
                Header ltpaHeader = this.zosmfconnector.getLtpaHeader(username, password);
                ArrayList<SimpleGrantedAuthority> grantedAuths = new ArrayList<SimpleGrantedAuthority>();
                grantedAuths.add(new SimpleGrantedAuthority("ROLE_USER"));
                CustomUser principal = new CustomUser(ltpaHeader.getValue(), username, password, grantedAuths);
                UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)principal, (Object)password, grantedAuths);
                return auth;
            }
            catch (Exception e) {
                log.error("authenticate", (Throwable)e);
                throw new UsernameNotFoundException(username);
            }
        }
        return null;
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }
}

