/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.api.common.zosmf.services;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.zowe.api.common.connectors.zosmf.ZosmfConnector;
import org.zowe.api.common.exceptions.HtmlEscapedZoweApiRestException;
import org.zowe.api.common.exceptions.InvalidAuthTokenException;
import org.zowe.api.common.exceptions.NoZosmfResponseEntityException;
import org.zowe.api.common.exceptions.ServerErrorException;
import org.zowe.api.common.exceptions.ZoweApiRestException;
import org.zowe.api.common.utils.ResponseCache;

public abstract class AbstractZosmfRequestRunner<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractZosmfRequestRunner.class);
    private final ArrayList<Header> requestHeaders;

    public AbstractZosmfRequestRunner(List<Header> headers) {
        this.requestHeaders = (ArrayList)headers;
    }

    public AbstractZosmfRequestRunner() {
        this(Collections.emptyList());
    }

    public T run(ZosmfConnector zosmfConnector) {
        try {
            RequestBuilder requestBuilder = this.prepareQuery(zosmfConnector);
            if (!this.requestHeaders.isEmpty()) {
                requestBuilder = this.addHeadersToRequest(requestBuilder);
            }
            URI uri = requestBuilder.getUri();
            HttpResponse response = zosmfConnector.executeRequest(requestBuilder);
            ResponseCache responseCache = new ResponseCache(response);
            return this.processResponse(responseCache, uri);
        }
        catch (IOException | URISyntaxException e) {
            log.error("run", (Throwable)e);
            throw new ServerErrorException(e);
        }
    }

    protected RequestBuilder addHeadersToRequest(RequestBuilder requestBuilder) {
        for (Header header : this.requestHeaders) {
            requestBuilder.addHeader(header);
        }
        return requestBuilder;
    }

    protected abstract int[] getSuccessStatus();

    protected abstract RequestBuilder prepareQuery(ZosmfConnector var1) throws URISyntaxException, IOException;

    protected T processResponse(ResponseCache responseCache, URI uri) throws IOException {
        int statusCode = responseCache.getStatus();
        boolean success = IntStream.of(this.getSuccessStatus()).anyMatch(x -> x == statusCode);
        if (success) {
            return this.getResult(responseCache);
        }
        log.error(String.format("processResponse - received response code : %s  - received response message: %s ", statusCode, responseCache.getEntity()));
        throw this.createGeneralException(responseCache, uri);
    }

    protected abstract T getResult(ResponseCache var1) throws IOException;

    protected ZoweApiRestException createException(JsonObject jsonResponse, int statusCode) throws IOException {
        return null;
    }

    protected Boolean wasRequestUnauthorised(HttpStatus springStatus, JsonObject jsonResponse) {
        JsonArray messagesArray;
        if (springStatus == HttpStatus.UNAUTHORIZED && jsonResponse.has("messages") && (messagesArray = jsonResponse.get("messages").getAsJsonArray()).get(0).getAsJsonObject().has("messageNumber") && messagesArray.get(0).getAsJsonObject().get("messageNumber").getAsString().equals("ZWEAG102E")) {
            return true;
        }
        return false;
    }

    protected ZoweApiRestException createGeneralException(ResponseCache responseCache, URI uri) throws IOException {
        String entityString = responseCache.getEntity();
        HttpStatus springStatus = responseCache.getSpringHttpStatus();
        if (StringUtils.hasText((String)entityString)) {
            ContentType contentType = responseCache.getContentType();
            String mimeType = contentType.getMimeType();
            if (mimeType.equals(ContentType.APPLICATION_JSON.getMimeType())) {
                JsonObject jsonResponse = responseCache.getEntityAsJsonObject();
                if (Boolean.TRUE.equals(this.wasRequestUnauthorised(springStatus, jsonResponse))) {
                    return new InvalidAuthTokenException();
                }
                ZoweApiRestException exception = this.createException(jsonResponse, responseCache.getStatus());
                if (exception != null) {
                    return exception;
                }
                if (jsonResponse.has("message")) {
                    String zosmfMessage = jsonResponse.get("message").getAsString();
                    return new HtmlEscapedZoweApiRestException(springStatus, zosmfMessage);
                }
                return new HtmlEscapedZoweApiRestException(springStatus, jsonResponse.toString());
            }
            return new HtmlEscapedZoweApiRestException(springStatus, entityString);
        }
        return new NoZosmfResponseEntityException(springStatus, uri.toString());
    }

    protected String getStringOrNull(JsonObject json, String key) {
        String value = null;
        JsonElement jsonElement = json.get(key);
        if (this.shouldRead(jsonElement)) {
            value = jsonElement.getAsString();
        }
        return value;
    }

    protected Integer getIntegerOrNull(JsonObject json, String key) {
        Integer value = null;
        JsonElement jsonElement = json.get(key);
        if (this.shouldRead(jsonElement)) {
            value = jsonElement.getAsInt();
        }
        return value;
    }

    private boolean shouldRead(JsonElement jsonElement) {
        return jsonElement != null && !jsonElement.isJsonNull() && !jsonElement.getAsString().equals("?");
    }
}

