/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.api.common.utils;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.springframework.http.HttpStatus;
import org.springframework.util.Base64Utils;

public class ResponseCache {
    private int statusCode;
    private String entityString;
    private HttpEntity entity;
    private HttpResponse response;

    public ResponseCache(HttpResponse response) throws IOException {
        this.response = response;
        if (response.getStatusLine() != null) {
            this.statusCode = response.getStatusLine().getStatusCode();
        }
        this.entity = response.getEntity();
        if (this.entity != null) {
            if (this.isOctetStream()) {
                byte[] entityContent = EntityUtils.toByteArray((HttpEntity)this.entity);
                this.entityString = Base64Utils.encodeToString((byte[])entityContent);
            } else {
                this.entityString = EntityUtils.toString((HttpEntity)this.entity, (String)"UTF-8");
            }
        }
    }

    public int getStatus() {
        return this.statusCode;
    }

    public HttpStatus getSpringHttpStatus() {
        return HttpStatus.resolve((int)this.statusCode);
    }

    public String getEntity() {
        return this.entityString;
    }

    public JsonElement getEntityAsJson() throws IOException {
        return (JsonElement)new Gson().fromJson(this.entityString, JsonElement.class);
    }

    public JsonObject getEntityAsJsonObject() throws IOException {
        return (JsonObject)new Gson().fromJson(this.entityString, JsonObject.class);
    }

    public JsonArray getEntityAsJsonArray() throws IOException {
        return (JsonArray)new Gson().fromJson(this.entityString, JsonArray.class);
    }

    public ContentType getContentType() {
        return ContentType.get((HttpEntity)this.entity);
    }

    private boolean isOctetStream() {
        return this.getContentType().getMimeType().equals("application/octet-stream");
    }

    public Header getFirstHeader(String name) {
        return this.response.getFirstHeader(name);
    }
}

