/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.api.common.connectors.zosmf;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.zowe.api.common.connectors.zosmf.GatewayProperties;
import org.zowe.api.common.connectors.zosmf.exceptions.ZosmfConnectionException;
import org.zowe.api.common.exceptions.NoAuthTokenException;

@Service
public class ZosmfConnector {
    private static final Logger log = LoggerFactory.getLogger(ZosmfConnector.class);
    private final String gatewayHost;
    private final int gatewayPort;
    @Autowired
    private HttpServletRequest request;

    public URI getFullUrl(String relativePath) throws URISyntaxException {
        return this.getFullUrl(relativePath, null);
    }

    public URI getFullUrl(String relativePath, String query) throws URISyntaxException {
        try {
            return new URI("https", null, this.gatewayHost, this.gatewayPort, "/api/v1/zosmf/" + relativePath, query, null);
        }
        catch (URISyntaxException e) {
            log.error("getFullUrl", (Throwable)e);
            throw e;
        }
    }

    @Autowired
    public ZosmfConnector(GatewayProperties properties) {
        this.gatewayHost = properties.getIpAddress();
        this.gatewayPort = properties.getHttpsPort();
    }

    private String getAuthorizationValueFromHeaders() {
        String cookieHeader = this.request.getHeader("cookie");
        if (cookieHeader != null && !cookieHeader.isEmpty()) {
            String[] cookies = cookieHeader.split(";");
            Optional<String> authTokenCookie = Arrays.stream(cookies).filter(c -> c.contains("apimlAuthenticationToken")).findFirst();
            if (authTokenCookie.isPresent()) {
                return "Bearer " + authTokenCookie.get().split("=")[1];
            }
        } else {
            String header = this.request.getHeader("authorization");
            if (header != null && !header.isEmpty()) {
                return header;
            }
        }
        throw new NoAuthTokenException();
    }

    public HttpResponse request(RequestBuilder requestBuilder) throws IOException {
        HttpClient client;
        requestBuilder.setHeader("Authorization", this.getAuthorizationValueFromHeaders());
        requestBuilder.setHeader("X-CSRF-ZOSMF-HEADER", "");
        requestBuilder.setHeader("X-IBM-Response-Timeout", "600");
        try {
            client = ZosmfConnector.createIgnoreSSLClient();
        }
        catch (GeneralSecurityException e) {
            log.error("request", (Throwable)e);
            throw new ZosmfConnectionException(e);
        }
        return client.execute(requestBuilder.build());
    }

    public static HttpClient createIgnoreSSLClient() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslcontext = SSLContext.getInstance("TLS");
        sslcontext.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }}, new SecureRandom());
        return HttpClientBuilder.create().setSSLContext(sslcontext).setSSLHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s1, SSLSession s2) {
                return true;
            }
        }).build();
    }
}

