/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.api.common.connectors.zosmf;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.zowe.api.common.connectors.zosmf.ZosmfProperties;
import org.zowe.api.common.connectors.zosmf.exceptions.ZosmfConnectionException;
import org.zowe.api.common.security.CustomUser;

@Service
public class ZosmfConnector {
    private static final Logger log = LoggerFactory.getLogger(ZosmfConnector.class);
    private final String zosmfHost;
    private final int zosmfPort;

    public URI getFullUrl(String relativePath) throws URISyntaxException {
        return this.getFullUrl(relativePath, null);
    }

    public URI getFullUrl(String relativePath, String query) throws URISyntaxException {
        try {
            return new URI("https", null, this.zosmfHost, this.zosmfPort, "/zosmf/" + relativePath, query, null);
        }
        catch (URISyntaxException e) {
            log.error("getFullUrl", (Throwable)e);
            throw e;
        }
    }

    @Autowired
    public ZosmfConnector(ZosmfProperties properties) {
        this.zosmfHost = properties.getIpAddress();
        this.zosmfPort = properties.getHttpsPort();
    }

    public HttpResponse request(RequestBuilder requestBuilder) throws IOException {
        HttpClient client;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        CustomUser customUser = (CustomUser)((Object)authentication.getPrincipal());
        requestBuilder.setHeader("Cookie", customUser.getLtpa());
        requestBuilder.setHeader("X-CSRF-ZOSMF-HEADER", "");
        requestBuilder.setHeader("X-IBM-Response-Timeout", "600");
        try {
            client = ZosmfConnector.createIgnoreSSLClient();
        }
        catch (GeneralSecurityException e) {
            log.error("request", (Throwable)e);
            throw new ZosmfConnectionException(e);
        }
        return client.execute(requestBuilder.build());
    }

    public Header getLtpaHeader(String username, String password) throws IOException, KeyManagementException, NoSuchAlgorithmException, URISyntaxException {
        URI targetUrl = this.getFullUrl("restjobs/jobs");
        CredentialsProvider credentialsProvider = this.getCredentialProvider(username, password);
        HttpClient createIgnoreSSLClient = ZosmfConnector.createPreemptiveHttpClientIgnoreSSL(credentialsProvider);
        HttpGet httpGet = new HttpGet(targetUrl);
        httpGet.setHeader("X-CSRF-ZOSMF-HEADER", "");
        HttpResponse response = createIgnoreSSLClient.execute((HttpUriRequest)httpGet, (HttpContext)this.createPreemptiveHttpClientContext(credentialsProvider, targetUrl));
        Header setCookieHeader = response.getFirstHeader("Set-Cookie");
        if (response.getStatusLine().getStatusCode() == 200) {
            return setCookieHeader;
        }
        throw new IOException("login failed");
    }

    private CredentialsProvider getCredentialProvider(String userName, String password) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
        return credentialsProvider;
    }

    private HttpClientContext createPreemptiveHttpClientContext(CredentialsProvider credentialsProvider, URI targetUrl) {
        HttpHost targetHost = new HttpHost(targetUrl.getHost(), targetUrl.getPort(), targetUrl.getScheme());
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(targetHost, (AuthScheme)new BasicScheme());
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider(credentialsProvider);
        context.setAuthCache((AuthCache)authCache);
        return context;
    }

    public static HttpClient createPreemptiveHttpClientIgnoreSSL(CredentialsProvider credentialsProvider) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslcontext = SSLContext.getInstance("TLS");
        sslcontext.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }}, new SecureRandom());
        return HttpClientBuilder.create().setSSLContext(sslcontext).setDefaultCredentialsProvider(credentialsProvider).setSSLHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s1, SSLSession s2) {
                return true;
            }
        }).build();
    }

    public static HttpClient createIgnoreSSLClientWithPassword(String userName, String password) throws NoSuchAlgorithmException, KeyManagementException {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
        SSLContext sslcontext = SSLContext.getInstance("TLS");
        sslcontext.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }}, new SecureRandom());
        return HttpClientBuilder.create().setSSLContext(sslcontext).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setSSLHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s1, SSLSession s2) {
                return true;
            }
        }).build();
    }

    public static HttpClient createIgnoreSSLClient() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslcontext = SSLContext.getInstance("TLS");
        sslcontext.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }}, new SecureRandom());
        return HttpClientBuilder.create().setSSLContext(sslcontext).setSSLHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s1, SSLSession s2) {
                return true;
            }
        }).build();
    }
}

