/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.api.common.utils;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.zowe.api.common.utils.JsonUtils;

public class ResponseUtils {
    public static int getStatus(HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }

    public static String getEntity(HttpResponse response) throws IOException {
        return EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
    }

    public static JsonElement getEntityAsJson(HttpResponse response) throws IOException {
        return (JsonElement)new Gson().fromJson(ResponseUtils.getEntity(response), JsonElement.class);
    }

    public static JsonObject getEntityAsJsonObject(HttpResponse response) throws IOException {
        return (JsonObject)new Gson().fromJson(ResponseUtils.getEntity(response), JsonObject.class);
    }

    public static JsonArray getEntityAsJsonArray(HttpResponse response) throws IOException {
        return (JsonArray)new Gson().fromJson(ResponseUtils.getEntity(response), JsonArray.class);
    }

    private static <T> T getEntityAs(HttpResponse response, Class<T> entityType) throws IOException {
        return JsonUtils.convertString(ResponseUtils.getEntity(response), entityType);
    }
}

