/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.commons.attls;

import org.zowe.commons.attls.Fips140;
import org.zowe.commons.attls.IoctlCallException;
import org.zowe.commons.attls.Protocol;
import org.zowe.commons.attls.SecurityType;
import org.zowe.commons.attls.StatConn;
import org.zowe.commons.attls.StatPolicy;
import org.zowe.commons.attls.UnknownEnumValueException;

public class AttlsContext {
    public static final String ATTLS_LIBRARY_NAME = "zowe-attls";
    private static final int BUFFER_CERTIFICATE_LENGTH = 10240;
    private final boolean alwaysLoadCertificate;
    private int id;
    private byte[] ioctl;
    private byte[] bufferCertificate;
    private boolean queryLoaded;
    private boolean certificateLoaded;
    private StatPolicy statPolicyCache;
    private StatConn statConnCache;
    private Protocol protocolCache;
    private String negotiatedCipher2Cache;
    private SecurityType securityTypeCache;
    private String userIdCache;
    private Fips140 fips140Cache;
    private String negotiatedCipher4Cache;
    private String negotiatedKeyShareCache;
    private byte[] certificateCache;

    public AttlsContext(int id, boolean alwaysLoadCertificate) {
        this.id = id;
        this.alwaysLoadCertificate = alwaysLoadCertificate;
    }

    public native void clean();

    public native StatPolicy getStatPolicy() throws UnknownEnumValueException, IoctlCallException;

    public native StatConn getStatConn() throws UnknownEnumValueException, IoctlCallException;

    public native Protocol getProtocol() throws UnknownEnumValueException, IoctlCallException;

    public native String getNegotiatedCipher2() throws IoctlCallException;

    public native SecurityType getSecurityType() throws UnknownEnumValueException, IoctlCallException;

    public native String getUserId() throws IoctlCallException;

    public native Fips140 getFips140() throws UnknownEnumValueException, IoctlCallException;

    public native byte getFlags() throws IoctlCallException;

    public native String getNegotiatedCipher4() throws IoctlCallException;

    public native byte[] getCertificate() throws IoctlCallException;

    public native void initConnection() throws IoctlCallException;

    public native void resetSession() throws IoctlCallException;

    public native void resetCipher() throws IoctlCallException;

    public native void stopConnection() throws IoctlCallException;

    public native void allowHandShakeTimeout() throws IoctlCallException;

    static {
        if ("z/os".equalsIgnoreCase(System.getProperty("os.name"))) {
            System.loadLibrary(ATTLS_LIBRARY_NAME);
        }
    }
}

