/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.zaasclient.service.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.zowe.apiml.zaasclient.config.ConfigProperties;
import org.zowe.apiml.zaasclient.exception.ZaasClientErrorCodes;
import org.zowe.apiml.zaasclient.exception.ZaasClientException;
import org.zowe.apiml.zaasclient.passticket.ZaasClientTicketRequest;
import org.zowe.apiml.zaasclient.passticket.ZaasPassTicketResponse;
import org.zowe.apiml.zaasclient.service.internal.PassTicketService;
import org.zowe.apiml.zaasclient.util.SimpleHttpResponse;

class PassTicketServiceImpl
implements PassTicketService {
    private final CloseableHttpClient httpClient;
    private final String ticketUrl;
    ConfigProperties passConfigProperties;

    public PassTicketServiceImpl(CloseableHttpClient client, String baseUrl, ConfigProperties configProperties) {
        this.httpClient = client;
        this.ticketUrl = baseUrl + "/ticket";
        this.passConfigProperties = configProperties;
    }

    @Override
    public String passTicket(String jwtToken, String applicationId) throws ZaasClientException {
        try {
            HttpPost httpPost = this.getHttpPost(jwtToken, applicationId);
            SimpleHttpResponse passTicketResponse = (SimpleHttpResponse)this.httpClient.execute((ClassicHttpRequest)httpPost, SimpleHttpResponse::fromResponseWithBytesBodyOnSuccess);
            return this.extractPassTicket(passTicketResponse);
        }
        catch (ZaasClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ZaasClientException(ZaasClientErrorCodes.SERVICE_UNAVAILABLE, (Throwable)e);
        }
    }

    private HttpPost getHttpPost(String jwtToken, String applicationId) throws JsonProcessingException {
        ZaasClientTicketRequest zaasClientTicketRequest = new ZaasClientTicketRequest();
        ObjectMapper mapper = new ObjectMapper();
        zaasClientTicketRequest.setApplicationName(applicationId);
        HttpPost httpPost = new HttpPost(this.ticketUrl);
        httpPost.setEntity((HttpEntity)new StringEntity(mapper.writeValueAsString((Object)zaasClientTicketRequest)));
        httpPost.setHeader("Content-Type", (Object)"application/json");
        httpPost.setHeader("Cookie", (Object)(this.passConfigProperties.getTokenPrefix() + "=" + jwtToken));
        return httpPost;
    }

    private String extractPassTicket(SimpleHttpResponse response) throws IOException, ZaasClientException {
        int statusCode = response.getCode();
        if (statusCode == 200) {
            ObjectMapper mapper = new ObjectMapper();
            ZaasPassTicketResponse zaasPassTicketResponse = (ZaasPassTicketResponse)mapper.readValue(response.getByteBody(), ZaasPassTicketResponse.class);
            return zaasPassTicketResponse.getTicket();
        }
        String obtainedMessage = response.getStringBody();
        if (statusCode == 401) {
            throw new ZaasClientException(ZaasClientErrorCodes.INVALID_AUTHENTICATION, obtainedMessage);
        }
        if (statusCode == 400) {
            throw new ZaasClientException(ZaasClientErrorCodes.BAD_REQUEST, obtainedMessage);
        }
        if (statusCode == 500) {
            throw new ZaasClientException(ZaasClientErrorCodes.SERVICE_UNAVAILABLE, obtainedMessage);
        }
        throw new ZaasClientException(ZaasClientErrorCodes.GENERIC_EXCEPTION, obtainedMessage);
    }
}

