/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.zaasclient.service.internal;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import lombok.Generated;
import org.apache.hc.client5.http.UserTokenHandler;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.HttpsSupport;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.zowe.apiml.zaasclient.config.ConfigProperties;
import org.zowe.apiml.zaasclient.exception.ZaasConfigurationErrorCodes;
import org.zowe.apiml.zaasclient.exception.ZaasConfigurationException;
import org.zowe.apiml.zaasclient.service.internal.CloseableClientProvider;

class ZaasHttpsClientProvider
implements CloseableClientProvider {
    private static final int REQUEST_TIMEOUT = 30000;
    private static final Pattern KEYRING_PATTERN = Pattern.compile("^(safkeyring[^:]*):/{2,4}([^/]+)/([^/]+)$");
    private ConfigProperties configProperties;
    private TrustManagerFactory tmf;
    private KeyManagerFactory kmf;
    private final char[] keyStorePassword;
    private final String keyStoreType;
    private final String keyStorePath;
    private final CookieStore cookieStore = new BasicCookieStore();
    private CloseableHttpClient httpsClient;

    public ZaasHttpsClientProvider(ConfigProperties configProperties) throws ZaasConfigurationException {
        if (configProperties.getTrustStorePath() == null) {
            throw new ZaasConfigurationException(ZaasConfigurationErrorCodes.TRUST_STORE_NOT_PROVIDED);
        }
        this.configProperties = configProperties;
        this.initializeTrustManagerFactory(configProperties.getTrustStorePath(), configProperties.getTrustStoreType(), configProperties.getTrustStorePassword());
        this.keyStorePath = configProperties.getKeyStorePath();
        this.keyStorePassword = configProperties.getKeyStorePassword();
        this.keyStoreType = configProperties.getKeyStoreType();
    }

    static boolean isKeyring(String input) {
        if (input == null) {
            return false;
        }
        Matcher matcher = KEYRING_PATTERN.matcher(input);
        return matcher.matches();
    }

    static String formatKeyringUrl(String input) {
        if (input == null) {
            return null;
        }
        Matcher matcher = KEYRING_PATTERN.matcher(input);
        if (matcher.matches()) {
            return matcher.group(1) + "://" + matcher.group(2) + "/" + matcher.group(3);
        }
        return input;
    }

    public void clearCookieStore() {
        this.cookieStore.clear();
    }

    @Override
    public synchronized CloseableHttpClient getHttpClient() throws ZaasConfigurationException {
        if (this.httpsClient == null) {
            if (this.kmf == null) {
                this.initializeKeyStoreManagerFactory();
            }
            HostnameVerifier hostnameVerifier = this.configProperties.isNonStrictVerifySslCertificatesOfServices() ? new NoopHostnameVerifier() : HttpsSupport.getDefaultHostnameVerifier();
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(this.getSSLContext(), hostnameVerifier);
            PoolingHttpClientConnectionManager manager = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
            this.httpsClient = this.createSecureHttpClient(manager).build();
        }
        return this.httpsClient;
    }

    private void initializeTrustManagerFactory(String trustStorePath, String trustStoreType, char[] trustStorePassword) throws ZaasConfigurationException {
        try {
            this.tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore trustStore = this.getKeystore(trustStorePath, trustStoreType, trustStorePassword);
            this.tmf.init(trustStore);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new ZaasConfigurationException(ZaasConfigurationErrorCodes.WRONG_CRYPTO_CONFIGURATION, (Throwable)e);
        }
        catch (IOException e) {
            throw new ZaasConfigurationException(ZaasConfigurationErrorCodes.IO_CONFIGURATION_ISSUE, (Throwable)e);
        }
    }

    private void initializeKeyStoreManagerFactory() throws ZaasConfigurationException {
        try {
            KeyStore keyStore = this.keyStorePath != null ? this.getKeystore(this.keyStorePath, this.keyStoreType, this.keyStorePassword) : this.getEmptyKeystore();
            this.kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            this.kmf.init(keyStore, this.keyStorePassword);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new ZaasConfigurationException(ZaasConfigurationErrorCodes.WRONG_CRYPTO_CONFIGURATION, (Throwable)e);
        }
        catch (IOException e) {
            throw new ZaasConfigurationException(ZaasConfigurationErrorCodes.IO_CONFIGURATION_ISSUE, (Throwable)e);
        }
    }

    private KeyStore getKeystore(String uri, String keyStoreType, char[] storePassword) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        try (InputStream correctInStream = this.getCorrectInputStream(uri);){
            keyStore.load(correctInStream, storePassword);
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }

    private KeyStore getEmptyKeystore() throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        KeyStore emptyKeystore = KeyStore.getInstance(KeyStore.getDefaultType());
        emptyKeystore.load(null, null);
        return emptyKeystore;
    }

    private InputStream getCorrectInputStream(String uri) throws IOException {
        if (ZaasHttpsClientProvider.isKeyring(uri)) {
            URL url = new URL(ZaasHttpsClientProvider.formatKeyringUrl(uri));
            return url.openStream();
        }
        return new FileInputStream(uri);
    }

    private SSLContext getSSLContext() throws ZaasConfigurationException {
        try {
            SSLContext sslContext = SSLContext.getInstance(this.configProperties.getProtocol());
            sslContext.init(this.kmf != null ? this.kmf.getKeyManagers() : null, this.tmf.getTrustManagers(), new SecureRandom());
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new ZaasConfigurationException(ZaasConfigurationErrorCodes.WRONG_CRYPTO_CONFIGURATION, (Throwable)e);
        }
    }

    public HttpClientBuilder createSecureHttpClient(PoolingHttpClientConnectionManager connectionManager) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofMilliseconds((long)30000L)).build();
        UserTokenHandler userTokenHandler = (route, context) -> context.getAttribute("my-token");
        return HttpClientBuilder.create().setUserTokenHandler(userTokenHandler).setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).disableCookieManagement().evictExpiredConnections().evictIdleConnections((TimeValue)Timeout.ofSeconds((long)30000L)).disableAuthCaching();
    }

    @Generated
    public ZaasHttpsClientProvider(ConfigProperties configProperties, TrustManagerFactory tmf, KeyManagerFactory kmf, char[] keyStorePassword, String keyStoreType, String keyStorePath, CloseableHttpClient httpsClient) {
        this.configProperties = configProperties;
        this.tmf = tmf;
        this.kmf = kmf;
        this.keyStorePassword = keyStorePassword;
        this.keyStoreType = keyStoreType;
        this.keyStorePath = keyStorePath;
        this.httpsClient = httpsClient;
    }
}

