/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.zaasclient.service.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.apiml.zaasclient.config.ConfigProperties;
import org.zowe.apiml.zaasclient.exception.ZaasClientErrorCodes;
import org.zowe.apiml.zaasclient.exception.ZaasClientException;
import org.zowe.apiml.zaasclient.exception.ZaasConfigurationException;
import org.zowe.apiml.zaasclient.passticket.ZaasClientTicketRequest;
import org.zowe.apiml.zaasclient.passticket.ZaasPassTicketResponse;
import org.zowe.apiml.zaasclient.service.internal.CloseableClientProvider;
import org.zowe.apiml.zaasclient.service.internal.PassTicketService;

class PassTicketServiceImpl
implements PassTicketService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PassTicketServiceImpl.class);
    private final CloseableClientProvider httpClientProvider;
    private final String ticketUrl;
    ConfigProperties passConfigProperties;

    public PassTicketServiceImpl(CloseableClientProvider client, String baseUrl, ConfigProperties configProperties) {
        this.httpClientProvider = client;
        this.ticketUrl = baseUrl + "/ticket";
        this.passConfigProperties = configProperties;
    }

    @Override
    public String passTicket(String jwtToken, String applicationId) throws ZaasClientException, ZaasConfigurationException {
        try {
            CloseableHttpClient closeableHttpsClient = this.httpClientProvider.getHttpClient();
            ZaasClientTicketRequest zaasClientTicketRequest = new ZaasClientTicketRequest();
            ObjectMapper mapper = new ObjectMapper();
            zaasClientTicketRequest.setApplicationName(applicationId);
            HttpPost httpPost = new HttpPost(this.ticketUrl);
            httpPost.setEntity((HttpEntity)new StringEntity(mapper.writeValueAsString((Object)zaasClientTicketRequest)));
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("Cookie", this.passConfigProperties.getTokenPrefix() + "=" + jwtToken);
            CloseableHttpResponse response = closeableHttpsClient.execute((HttpUriRequest)httpPost);
            return this.extractPassTicket(response);
        }
        catch (ZaasConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ZaasClientException(ZaasClientErrorCodes.SERVICE_UNAVAILABLE, (Throwable)e);
        }
    }

    private String extractPassTicket(CloseableHttpResponse response) throws IOException, ZaasClientException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            ObjectMapper mapper = new ObjectMapper();
            ZaasPassTicketResponse zaasPassTicketResponse = (ZaasPassTicketResponse)mapper.readValue(response.getEntity().getContent(), ZaasPassTicketResponse.class);
            return zaasPassTicketResponse.getTicket();
        }
        String obtainedMessage = EntityUtils.toString((HttpEntity)response.getEntity());
        if (statusCode == 401) {
            throw new ZaasClientException(ZaasClientErrorCodes.INVALID_AUTHENTICATION, obtainedMessage);
        }
        if (statusCode == 400) {
            throw new ZaasClientException(ZaasClientErrorCodes.BAD_REQUEST, obtainedMessage);
        }
        if (statusCode == 500) {
            throw new ZaasClientException(ZaasClientErrorCodes.SERVICE_UNAVAILABLE, obtainedMessage);
        }
        throw new ZaasClientException(ZaasClientErrorCodes.GENERIC_EXCEPTION, obtainedMessage);
    }
}

