/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.zaasclient.service.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.apiml.zaasclient.exception.ZaasClientErrorCodes;
import org.zowe.apiml.zaasclient.exception.ZaasClientException;
import org.zowe.apiml.zaasclient.exception.ZaasConfigurationException;
import org.zowe.apiml.zaasclient.service.ZaasToken;
import org.zowe.apiml.zaasclient.service.internal.CloseableClientProvider;
import org.zowe.apiml.zaasclient.service.internal.TokenService;
import org.zowe.apiml.zaasclient.service.internal.ZaasHttpsClientProvider;

class ZaasJwtService
implements TokenService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZaasJwtService.class);
    private static final String TOKEN_PREFIX = "apimlAuthenticationToken";
    private final String loginEndpoint;
    private final String queryEndpoint;
    private final String logoutEndpoint;
    private final CloseableClientProvider httpClientProvider;

    public ZaasJwtService(CloseableClientProvider client, String baseUrl) {
        this.httpClientProvider = client;
        this.loginEndpoint = baseUrl + "/login";
        this.queryEndpoint = baseUrl + "/query";
        this.logoutEndpoint = baseUrl + "/logout";
    }

    @Override
    public String login(String userId, String password) throws ZaasClientException {
        return (String)this.doRequest(() -> this.loginWithCredentials(userId, password), this::extractToken);
    }

    private ClientWithResponse loginWithCredentials(String userId, String password) throws ZaasConfigurationException, IOException {
        CloseableHttpClient client = this.httpClientProvider.getHttpClient();
        HttpPost httpPost = new HttpPost(this.loginEndpoint);
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString((Object)new Credentials(userId, password));
        StringEntity entity = new StringEntity(json);
        httpPost.setEntity((HttpEntity)entity);
        httpPost.setHeader("Content-Type", "application/json");
        return new ClientWithResponse(client, client.execute((HttpUriRequest)httpPost));
    }

    @Override
    public String login(String authorizationHeader) throws ZaasClientException {
        return (String)this.doRequest(() -> this.loginWithHeader(authorizationHeader), this::extractToken);
    }

    private ClientWithResponse loginWithHeader(String authorizationHeader) throws ZaasConfigurationException, IOException {
        CloseableHttpClient client = this.httpClientProvider.getHttpClient();
        HttpPost httpPost = new HttpPost(this.loginEndpoint);
        httpPost.setHeader("Authorization", authorizationHeader);
        return new ClientWithResponse(client, client.execute((HttpUriRequest)httpPost));
    }

    @Override
    public ZaasToken query(String jwtToken) throws ZaasClientException {
        return (ZaasToken)this.doRequest(() -> this.queryWithJwtToken(jwtToken), this::extractZaasToken);
    }

    @Override
    public void logout(String jwtToken) throws ZaasClientException {
        this.doRequest(() -> this.logoutJwtToken(jwtToken));
    }

    private ClientWithResponse queryWithJwtToken(String jwtToken) throws ZaasConfigurationException, IOException {
        CloseableHttpClient client = this.httpClientProvider.getHttpClient();
        HttpGet httpGet = new HttpGet(this.queryEndpoint);
        httpGet.addHeader("Cookie", "apimlAuthenticationToken=" + jwtToken);
        return new ClientWithResponse(client, client.execute((HttpUriRequest)httpGet));
    }

    private ClientWithResponse logoutJwtToken(String jwtToken) throws ZaasConfigurationException, IOException, ZaasClientException {
        CloseableHttpClient client = this.httpClientProvider.getHttpClient();
        this.clearZaasClientCookies();
        HttpPost httpPost = new HttpPost(this.logoutEndpoint);
        if (jwtToken.startsWith("Bearer")) {
            httpPost.addHeader("Authorization", jwtToken);
        } else {
            httpPost.addHeader("Cookie", jwtToken);
        }
        return this.getClientWithResponse(client, httpPost);
    }

    private void clearZaasClientCookies() {
        if (this.httpClientProvider instanceof ZaasHttpsClientProvider) {
            ((ZaasHttpsClientProvider)this.httpClientProvider).clearCookieStore();
        }
    }

    private ClientWithResponse getClientWithResponse(CloseableHttpClient client, HttpPost httpPost) throws IOException, ZaasClientException {
        ClientWithResponse clientWithResponse = new ClientWithResponse(client, client.execute((HttpUriRequest)httpPost));
        int httpResponseCode = clientWithResponse.getResponse().getStatusLine().getStatusCode();
        if (httpResponseCode == 204) {
            return clientWithResponse;
        }
        String obtainedMessage = EntityUtils.toString((HttpEntity)clientWithResponse.getResponse().getEntity());
        if (httpResponseCode == 401) {
            throw new ZaasClientException(ZaasClientErrorCodes.INVALID_AUTHENTICATION, obtainedMessage);
        }
        throw new ZaasClientException(ZaasClientErrorCodes.INVALID_JWT_TOKEN, obtainedMessage);
    }

    private void finallyClose(CloseableHttpResponse response) {
        try {
            if (response != null) {
                response.close();
            }
        }
        catch (IOException e) {
            log.warn("It wasn't possible to close the resources. " + e.getMessage());
        }
    }

    private ZaasToken extractZaasToken(CloseableHttpResponse response) throws IOException, ZaasClientException {
        if (response.getStatusLine().getStatusCode() == 200) {
            return (ZaasToken)new ObjectMapper().readValue(response.getEntity().getContent(), ZaasToken.class);
        }
        throw new ZaasClientException(ZaasClientErrorCodes.EXPIRED_JWT_EXCEPTION, EntityUtils.toString((HttpEntity)response.getEntity()));
    }

    private String extractToken(CloseableHttpResponse response) throws ZaasClientException, IOException {
        String token = "";
        int httpResponseCode = response.getStatusLine().getStatusCode();
        if (httpResponseCode == 204) {
            HeaderElement[] elements = response.getHeaders("Set-Cookie")[0].getElements();
            Optional<HeaderElement> apimlAuthCookie = Stream.of(elements).filter(element -> element.getName().equals(TOKEN_PREFIX)).findFirst();
            if (apimlAuthCookie.isPresent()) {
                token = apimlAuthCookie.get().getValue();
            }
        } else {
            String obtainedMessage = EntityUtils.toString((HttpEntity)response.getEntity());
            if (httpResponseCode == 401) {
                throw new ZaasClientException(ZaasClientErrorCodes.INVALID_AUTHENTICATION, obtainedMessage);
            }
            if (httpResponseCode == 400) {
                throw new ZaasClientException(ZaasClientErrorCodes.EMPTY_NULL_USERNAME_PASSWORD, obtainedMessage);
            }
            throw new ZaasClientException(ZaasClientErrorCodes.GENERIC_EXCEPTION, obtainedMessage);
        }
        return token;
    }

    private void doRequest(Operation request) throws ZaasClientException {
        ClientWithResponse clientWithResponse = new ClientWithResponse();
        try {
            clientWithResponse = request.request();
        }
        catch (ZaasClientException e) {
            throw e;
        }
        catch (IOException | ZaasConfigurationException e) {
            throw new ZaasClientException(ZaasClientErrorCodes.SERVICE_UNAVAILABLE, (Throwable)e);
        }
        finally {
            this.finallyClose(clientWithResponse.getResponse());
        }
    }

    private Object doRequest(Operation request, Token token) throws ZaasClientException {
        ClientWithResponse clientWithResponse = new ClientWithResponse();
        try {
            clientWithResponse = request.request();
            Object object = token.extract(clientWithResponse.getResponse());
            return object;
        }
        catch (ZaasClientException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ZaasClientException(ZaasClientErrorCodes.SERVICE_UNAVAILABLE, (Throwable)e);
        }
        catch (Exception e) {
            throw new ZaasClientException(ZaasClientErrorCodes.GENERIC_EXCEPTION, (Throwable)e);
        }
        finally {
            this.finallyClose(clientWithResponse.getResponse());
        }
    }

    static interface Operation {
        public ClientWithResponse request() throws ZaasConfigurationException, IOException, ZaasClientException;
    }

    static interface Token {
        public Object extract(CloseableHttpResponse var1) throws IOException, ZaasClientException;
    }

    static class ClientWithResponse {
        CloseableHttpClient client;
        CloseableHttpResponse response;

        @Generated
        public CloseableHttpClient getClient() {
            return this.client;
        }

        @Generated
        public CloseableHttpResponse getResponse() {
            return this.response;
        }

        @Generated
        public void setClient(CloseableHttpClient client) {
            this.client = client;
        }

        @Generated
        public void setResponse(CloseableHttpResponse response) {
            this.response = response;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClientWithResponse)) {
                return false;
            }
            ClientWithResponse other = (ClientWithResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CloseableHttpClient this$client = this.getClient();
            CloseableHttpClient other$client = other.getClient();
            if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
                return false;
            }
            CloseableHttpResponse this$response = this.getResponse();
            CloseableHttpResponse other$response = other.getResponse();
            return !(this$response == null ? other$response != null : !this$response.equals(other$response));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ClientWithResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CloseableHttpClient $client = this.getClient();
            result = result * 59 + ($client == null ? 43 : $client.hashCode());
            CloseableHttpResponse $response = this.getResponse();
            result = result * 59 + ($response == null ? 43 : $response.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ZaasJwtService.ClientWithResponse(client=" + this.getClient() + ", response=" + this.getResponse() + ")";
        }

        @Generated
        public ClientWithResponse(CloseableHttpClient client, CloseableHttpResponse response) {
            this.client = client;
            this.response = response;
        }

        @Generated
        public ClientWithResponse() {
        }
    }

    static class Credentials {
        String username;
        String password;

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public void setUsername(String username) {
            this.username = username;
        }

        @Generated
        public void setPassword(String password) {
            this.password = password;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Credentials)) {
                return false;
            }
            Credentials other = (Credentials)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Credentials;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ZaasJwtService.Credentials(username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
        }

        @Generated
        public Credentials(String username, String password) {
            this.username = username;
            this.password = password;
        }
    }
}

