/*
 * Decompiled with CFR 0.152.
 */
package org.zowe.apiml.zaasclient.service.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zowe.apiml.zaasclient.exception.ZaasClientErrorCodes;
import org.zowe.apiml.zaasclient.exception.ZaasClientException;
import org.zowe.apiml.zaasclient.exception.ZaasConfigurationException;
import org.zowe.apiml.zaasclient.passticket.ZaasClientTicketRequest;
import org.zowe.apiml.zaasclient.passticket.ZaasPassTicketResponse;
import org.zowe.apiml.zaasclient.service.internal.HttpsClientProvider;
import org.zowe.apiml.zaasclient.service.internal.PassTicketService;

class PassTicketServiceHttps
implements PassTicketService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PassTicketServiceHttps.class);
    private static final String TOKEN_PREFIX = "apimlAuthenticationToken";
    private HttpsClientProvider httpsClientProvider;
    private final String ticketUrl;

    public PassTicketServiceHttps(HttpsClientProvider client, String baseUrl) {
        this.httpsClientProvider = client;
        this.ticketUrl = baseUrl + "/ticket";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String passTicket(String jwtToken, String applicationId) throws ZaasClientException, ZaasConfigurationException {
        CloseableHttpResponse response = null;
        CloseableHttpClient closeableHttpsClient = null;
        try {
            closeableHttpsClient = this.httpsClientProvider.getHttpsClientWithKeyStoreAndTrustStore();
            ZaasClientTicketRequest zaasClientTicketRequest = new ZaasClientTicketRequest();
            ObjectMapper mapper = new ObjectMapper();
            zaasClientTicketRequest.setApplicationName(applicationId);
            HttpPost httpPost = new HttpPost(this.ticketUrl);
            httpPost.setEntity((HttpEntity)new StringEntity(mapper.writeValueAsString((Object)zaasClientTicketRequest)));
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setHeader("Cookie", "apimlAuthenticationToken=" + jwtToken);
            response = closeableHttpsClient.execute((HttpUriRequest)httpPost);
            String string = this.extractPassTicket(response);
            this.finallyClose(response);
            return string;
        }
        catch (ZaasConfigurationException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new ZaasClientException(ZaasClientErrorCodes.SERVICE_UNAVAILABLE, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.finallyClose(response);
                throw throwable;
            }
        }
    }

    private String extractPassTicket(CloseableHttpResponse response) throws IOException, ZaasClientException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            ObjectMapper mapper = new ObjectMapper();
            ZaasPassTicketResponse zaasPassTicketResponse = (ZaasPassTicketResponse)mapper.readValue(response.getEntity().getContent(), ZaasPassTicketResponse.class);
            return zaasPassTicketResponse.getTicket();
        }
        String obtainedMessage = EntityUtils.toString((HttpEntity)response.getEntity());
        if (statusCode == 401) {
            throw new ZaasClientException(ZaasClientErrorCodes.INVALID_AUTHENTICATION, obtainedMessage);
        }
        if (statusCode == 400) {
            throw new ZaasClientException(ZaasClientErrorCodes.BAD_REQUEST, obtainedMessage);
        }
        if (statusCode == 500) {
            throw new ZaasClientException(ZaasClientErrorCodes.SERVICE_UNAVAILABLE, obtainedMessage);
        }
        throw new ZaasClientException(ZaasClientErrorCodes.GENERIC_EXCEPTION, obtainedMessage);
    }

    private void finallyClose(CloseableHttpResponse response) {
        try {
            if (response != null) {
                response.close();
            }
        }
        catch (IOException e) {
            log.warn("It wasn't possible to close the resources. " + e.getMessage());
        }
    }
}

